/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.resolver;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class ExtensibleModelResolver
implements ModelResolver {
    private final ModelResolverExtensionPoint resolverExtensions;
    private final FactoryExtensionPoint modelFactories;
    private final Contribution contribution;
    private ModelResolver defaultResolver;
    private final Map<Class<?>, ModelResolver> resolversByModelType = new HashMap();
    private final Map<Class<?>, ModelResolver> resolversByImplementationClass = new HashMap();
    private Map<Object, Object> map = new HashMap<Object, Object>();
    private Object lastUnresolved;

    public ExtensibleModelResolver(Contribution contribution, ModelResolverExtensionPoint resolverExtensions, FactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
        this.resolverExtensions = resolverExtensions;
        this.modelFactories = modelFactories;
    }

    private ModelResolver getModelResolverInstance(Class<?> modelType) {
        Class<?>[] interfaces = modelType.getInterfaces();
        Class[] classes = new Class[interfaces.length + 1];
        classes[0] = modelType;
        if (interfaces.length != 0) {
            System.arraycopy(interfaces, 0, classes, 1, interfaces.length);
        }
        for (Class c : classes) {
            ModelResolver resolverInstance = this.resolversByModelType.get(c);
            if (resolverInstance != null) {
                return resolverInstance;
            }
            Class<? extends ModelResolver> resolverClass = this.resolverExtensions.getResolver(c);
            if (resolverClass == null) continue;
            resolverInstance = this.resolversByImplementationClass.get(resolverClass);
            if (resolverInstance != null) {
                this.resolversByModelType.put(c, resolverInstance);
                return resolverInstance;
            }
            try {
                Constructor<? extends ModelResolver> constructor = resolverClass.getConstructor(Contribution.class, FactoryExtensionPoint.class);
                if (constructor == null) continue;
                resolverInstance = constructor.newInstance(this.contribution, this.modelFactories);
                this.resolversByImplementationClass.put(resolverClass, resolverInstance);
                this.resolversByModelType.put(c, resolverInstance);
                return resolverInstance;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    @Override
    public void addModel(Object resolved, ProcessorContext context) {
        ModelResolver resolver = this.getModelResolverInstance(resolved.getClass());
        if (resolver != null) {
            resolver.addModel(resolved, context);
        } else {
            this.map.put(resolved, resolved);
        }
    }

    @Override
    public Object removeModel(Object resolved, ProcessorContext context) {
        ModelResolver resolver = this.getModelResolverInstance(resolved.getClass());
        if (resolver != null) {
            return resolver.removeModel(resolved, context);
        }
        return this.map.remove(resolved);
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved, ProcessorContext context) {
        if (unresolved == this.lastUnresolved) {
            return unresolved;
        }
        this.lastUnresolved = unresolved;
        ModelResolver resolver = this.getModelResolverInstance(unresolved.getClass());
        if (resolver != null) {
            T resolved = resolver.resolveModel(modelClass, unresolved, context);
            if (resolved != null && resolved != unresolved) {
                this.lastUnresolved = null;
                return modelClass.cast(resolved);
            }
        } else {
            Object resolved;
            if (this.defaultResolver != null && (resolved = this.defaultResolver.resolveModel(modelClass, unresolved, context)) != null && resolved != unresolved) {
                this.lastUnresolved = null;
                return modelClass.cast(resolved);
            }
            resolved = this.map.get(unresolved);
            if (resolved != null) {
                this.lastUnresolved = null;
                return modelClass.cast(resolved);
            }
        }
        return unresolved;
    }

    public ModelResolver getDefaultModelResolver() {
        return this.defaultResolver;
    }
}

