/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class ExtensibleStAXAttributeProcessor
implements StAXAttributeProcessor<Object> {
    private static final Logger logger = Logger.getLogger(ExtensibleStAXAttributeProcessor.class.getName());
    private static final String XMLSCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    public static final QName ANY_ATTRIBUTE = new QName("http://www.w3.org/2001/XMLSchema", "anyAttribute");
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private StAXAttributeProcessorExtensionPoint processors;

    public ExtensibleStAXAttributeProcessor(StAXAttributeProcessorExtensionPoint processors, XMLInputFactory inputFactory, XMLOutputFactory outputFactory) {
        this.processors = processors;
        this.inputFactory = inputFactory;
        this.outputFactory = outputFactory;
        if (this.outputFactory != null) {
            this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        }
    }

    private void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }

    @Override
    public Object read(QName attributeName, XMLStreamReader source, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        Location location;
        int event = source.getEventType();
        if (event == 7) {
            while (source.next() != 1) {
            }
        }
        StAXAttributeProcessor processor = null;
        processor = this.processors.getProcessor(attributeName);
        if (processor == null) {
            location = source.getLocation();
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attributeName.getNamespaceURI())) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("Attribute " + attributeName + " cannot be processed. (" + location + ")");
                }
                this.warning(context.getMonitor(), "AttributeCannotBeProcessed", this.processors, attributeName, location);
            }
        } else {
            return processor.read(attributeName, source, context);
        }
        processor = this.processors.getProcessor(ANY_ATTRIBUTE);
        if (processor == null) {
            location = source.getLocation();
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Could not find Default Attribute processor !");
            }
            this.warning(context.getMonitor(), "DefaultAttributeProcessorNotAvailable", this.processors, ANY_ATTRIBUTE, location);
        }
        return processor == null ? null : processor.read(attributeName, source, context);
    }

    @Override
    public void write(Object model, XMLStreamWriter outputSource, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        if (model == null) {
            return;
        }
        StAXAttributeProcessor<Object> processor = this.processors.getProcessor(model.getClass());
        if (processor == null) {
            if (!Extension.class.isInstance(model)) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("No StAX processor is configured to handle " + model.getClass());
                }
                this.warning(context.getMonitor(), "NoStaxProcessor", this.processors, model.getClass());
            }
        } else {
            processor.write(model, outputSource, context);
            return;
        }
        processor = this.processors.getProcessor(ANY_ATTRIBUTE);
        if (processor == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("No Default StAX processor is configured to handle " + model.getClass());
            }
        } else {
            processor.write(model, outputSource, context);
            return;
        }
        this.warning(context.getMonitor(), "NoDefaultStaxProcessor", this.processors, model.getClass());
    }

    @Override
    public void resolve(Object model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        StAXAttributeProcessor<?> processor;
        if (model != null && (processor = this.processors.getProcessor(model.getClass())) != null) {
            processor.resolve(model, resolver, context);
        }
    }

    public <M> M read(InputStream is, Class<M> type) throws ContributionReadException {
        return null;
    }

    public void write(Object model, OutputStream os, ProcessorContext context) throws ContributionWriteException {
        try {
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(os);
            this.write(model, writer, context);
            writer.flush();
            writer.close();
        }
        catch (XMLStreamException e) {
            ContributionWriteException cw = new ContributionWriteException(e);
            this.error(context.getMonitor(), "ContributionWriteException", (Object)this.outputFactory, cw);
            throw cw;
        }
    }

    @Override
    public QName getArtifactType() {
        return null;
    }

    @Override
    public Class<Object> getModelType() {
        return Object.class;
    }
}

