/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.tuscany.sca.assembly.xsd.Constants;
import org.apache.tuscany.sca.common.xml.XMLDocumentHelper;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLStreamReader;
import org.apache.tuscany.sca.contribution.processor.ValidationSchemaExtensionPoint;
import org.apache.tuscany.sca.core.DefaultExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.extensibility.ClassLoaderContext;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultValidatingXMLInputFactory
extends ValidatingXMLInputFactory
implements LSResourceResolver {
    private ExtensionPointRegistry registry;
    private XMLInputFactory inputFactory;
    private DocumentBuilderFactory documentBuilderFactory;
    private DOMImplementationLS ls;
    private ValidationSchemaExtensionPoint schemas;
    private MonitorFactory monitorFactory;
    private boolean initialized;
    private boolean hasSchemas;
    private Schema aggregatedSchema;
    private StAXHelper helper;
    public static final QName XSD = new QName("http://www.w3.org/2001/XMLSchema", "schema");

    public DefaultValidatingXMLInputFactory(ExtensionPointRegistry registry) {
        this.registry = registry;
        FactoryExtensionPoint factoryExtensionPoint = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.inputFactory = factoryExtensionPoint.getFactory(XMLInputFactory.class);
        this.documentBuilderFactory = factoryExtensionPoint.getFactory(DocumentBuilderFactory.class);
        this.schemas = registry.getExtensionPoint(ValidationSchemaExtensionPoint.class);
        this.monitorFactory = registry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(MonitorFactory.class);
        this.helper = StAXHelper.getInstance(registry);
    }

    public DefaultValidatingXMLInputFactory(XMLInputFactory inputFactory, ValidationSchemaExtensionPoint schemas) {
        this.inputFactory = inputFactory;
        this.schemas = schemas;
        this.registry = new DefaultExtensionPointRegistry();
    }

    private void error(Monitor monitor, String message, Object model, Throwable ex) {
        Monitor.error(monitor, (Object)this, "contribution-validation-messages", message, ex);
    }

    private void warn(Monitor monitor, String message, Object model, Throwable ex) {
        Monitor.warning(monitor, (Object)this, "contribution-validation-messages", message, ex);
    }

    private Collection<? extends Source> aggregate(URL ... urls) throws IOException, XMLStreamException {
        if (urls.length == 1) {
            return Collections.singletonList(new SAXSource(XMLDocumentHelper.getInputSource(urls[0])));
        }
        HashMap<String, HashSet<URL>> map = new HashMap<String, HashSet<URL>>();
        for (URL url : urls) {
            String tns = this.helper.readAttribute(url, XSD, "targetNamespace");
            HashSet<URL> collection = (HashSet<URL>)map.get(tns);
            if (collection == null) {
                collection = new HashSet<URL>();
                map.put(tns, collection);
            }
            collection.add(url);
        }
        ArrayList<SAXSource> sources = new ArrayList<SAXSource>();
        for (Map.Entry e : map.entrySet()) {
            if (((Collection)e.getValue()).size() == 1) {
                sources.add(new SAXSource(XMLDocumentHelper.getInputSource((URL)((Collection)e.getValue()).iterator().next())));
                continue;
            }
            StringBuffer xsd = new StringBuffer("<schema xmlns=\"http://www.w3.org/2001/XMLSchema\"");
            if (e.getKey() != null) {
                xsd.append(" targetNamespace=\"").append((String)e.getKey()).append("\"");
            }
            xsd.append(">");
            for (URL url : (Collection)e.getValue()) {
                xsd.append("<include schemaLocation=\"").append(url).append("\"/>");
            }
            xsd.append("</schema>");
            SAXSource source = new SAXSource(new InputSource(new StringReader(xsd.toString())));
            sources.add(source);
        }
        return sources;
    }

    private synchronized void initializeSchemas(Monitor monitor) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            List<String> uris = this.schemas.getSchemas();
            int n = uris.size();
            if (n == 0) {
                return;
            }
            this.hasSchemas = true;
            URL[] urls = new URL[uris.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new URL(uris.get(i));
            }
            final Collection<? extends Source> sources = this.aggregate(urls);
            final SchemaFactory schemaFactory = this.newSchemaFactory();
            DOMImplementation impl = null;
            try {
                impl = this.documentBuilderFactory.newDocumentBuilder().getDOMImplementation();
            }
            catch (ParserConfigurationException e) {
                // empty catch block
            }
            if (impl instanceof DOMImplementationLS) {
                this.ls = (DOMImplementationLS)((Object)impl);
                schemaFactory.setResourceResolver(this);
            }
            try {
                this.aggregatedSchema = AccessController.doPrivileged(new PrivilegedExceptionAction<Schema>(){

                    @Override
                    public Schema run() throws SAXException {
                        return schemaFactory.newSchema(sources.toArray(new Source[sources.size()]));
                    }
                });
            }
            catch (PrivilegedActionException e) {
                this.warn(monitor, "PrivilegedActionException", schemaFactory, (SAXException)e.getException());
                this.hasSchemas = false;
                throw (SAXException)e.getException();
            }
        }
        catch (SAXException e) {
        }
        catch (Throwable e) {
            this.warn(monitor, e.getMessage(), this.schemas, e);
            this.hasSchemas = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaFactory newSchemaFactory() {
        ClassLoader cl = ClassLoaderContext.setContextClassLoader(this.getClass().getClassLoader(), this.registry.getServiceDiscovery(), SchemaFactory.class, TransformerFactory.class, SAXParserFactory.class, DocumentBuilderFactory.class);
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            return schemaFactory;
        }
        finally {
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    @Override
    public XMLEventReader createFilteredReader(XMLEventReader arg0, EventFilter arg1) throws XMLStreamException {
        return this.inputFactory.createFilteredReader(arg0, arg1);
    }

    @Override
    public XMLStreamReader createFilteredReader(XMLStreamReader arg0, StreamFilter arg1) throws XMLStreamException {
        return this.inputFactory.createFilteredReader(arg0, arg1);
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream arg0, String arg1) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0, arg1);
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream arg0) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0);
    }

    @Override
    public XMLEventReader createXMLEventReader(Reader arg0) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0);
    }

    @Override
    public XMLEventReader createXMLEventReader(Source arg0) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0);
    }

    @Override
    public XMLEventReader createXMLEventReader(String arg0, InputStream arg1) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0, arg1);
    }

    @Override
    public XMLEventReader createXMLEventReader(String arg0, Reader arg1) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0, arg1);
    }

    @Override
    public XMLEventReader createXMLEventReader(XMLStreamReader arg0) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream arg0, String arg1) throws XMLStreamException {
        Monitor monitor = this.monitorFactory.getContextMonitor();
        this.initializeSchemas(monitor);
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0, arg1), this.aggregatedSchema, monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0, arg1);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream arg0) throws XMLStreamException {
        Monitor monitor = this.monitorFactory.getContextMonitor();
        this.initializeSchemas(monitor);
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0), this.aggregatedSchema, monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Reader arg0) throws XMLStreamException {
        Monitor monitor = this.monitorFactory.getContextMonitor();
        this.initializeSchemas(monitor);
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0), this.aggregatedSchema, monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Source arg0) throws XMLStreamException {
        Monitor monitor = this.monitorFactory.getContextMonitor();
        this.initializeSchemas(monitor);
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0), this.aggregatedSchema, monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String arg0, InputStream arg1) throws XMLStreamException {
        Monitor monitor = this.monitorFactory.getContextMonitor();
        this.initializeSchemas(monitor);
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0, arg1), this.aggregatedSchema, monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0, arg1);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String arg0, Reader arg1) throws XMLStreamException {
        Monitor monitor = this.monitorFactory.getContextMonitor();
        this.initializeSchemas(monitor);
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0, arg1), this.aggregatedSchema, monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0, arg1);
    }

    @Override
    public XMLEventAllocator getEventAllocator() {
        return this.inputFactory.getEventAllocator();
    }

    @Override
    public Object getProperty(String arg0) throws IllegalArgumentException {
        return this.inputFactory.getProperty(arg0);
    }

    @Override
    public XMLReporter getXMLReporter() {
        return this.inputFactory.getXMLReporter();
    }

    @Override
    public XMLResolver getXMLResolver() {
        return this.inputFactory.getXMLResolver();
    }

    @Override
    public boolean isPropertySupported(String arg0) {
        return this.inputFactory.isPropertySupported(arg0);
    }

    @Override
    public void setEventAllocator(XMLEventAllocator arg0) {
        this.inputFactory.setEventAllocator(arg0);
    }

    @Override
    public void setProperty(String arg0, Object arg1) throws IllegalArgumentException {
        this.inputFactory.setProperty(arg0, arg1);
    }

    @Override
    public void setXMLReporter(XMLReporter arg0) {
        this.inputFactory.setXMLReporter(arg0);
    }

    @Override
    public void setXMLResolver(XMLResolver arg0) {
        this.inputFactory.setXMLResolver(arg0);
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        String key = null;
        if ("http://www.w3.org/2001/XMLSchema".equals(type)) {
            key = namespaceURI;
        } else if ("http://www.w3.org/TR/REC-xml".equals(type)) {
            key = publicId;
        }
        URL url = Constants.CACHED_XSDS.get(key);
        if (url != null && !"http://docs.oasis-open.org/ns/opencsa/sca/200912".equals(namespaceURI)) {
            systemId = url.toString();
        } else if (url != null && systemId == null) {
            systemId = url.toString();
        }
        LSInput input = this.ls.createLSInput();
        input.setBaseURI(baseURI);
        input.setPublicId(publicId);
        input.setSystemId(systemId);
        return input;
    }
}

