/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.DefaultArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDeclarationParser;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class DefaultStAXArtifactProcessorExtensionPoint
extends DefaultArtifactProcessorExtensionPoint<StAXArtifactProcessor<?>>
implements StAXArtifactProcessorExtensionPoint {
    private ExtensionPointRegistry registry;
    private FactoryExtensionPoint modelFactories;
    private boolean loaded;
    private StAXArtifactProcessor<Object> extensibleStAXProcessor;
    private StAXAttributeProcessor<Object> extensibleStAXAttributeProcessor;

    public DefaultStAXArtifactProcessorExtensionPoint(ExtensionPointRegistry extensionPoints) {
        this.registry = extensionPoints;
        this.modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        XMLInputFactory inputFactory = this.modelFactories.getFactory(XMLInputFactory.class);
        XMLOutputFactory outputFactory = this.modelFactories.getFactory(XMLOutputFactory.class);
        this.extensibleStAXProcessor = new ExtensibleStAXArtifactProcessor(this, inputFactory, outputFactory);
        StAXAttributeProcessorExtensionPoint attributeExtensionPoint = extensionPoints.getExtensionPoint(StAXAttributeProcessorExtensionPoint.class);
        this.extensibleStAXAttributeProcessor = new ExtensibleStAXAttributeProcessor(attributeExtensionPoint, inputFactory, outputFactory);
    }

    @Override
    public void addArtifactProcessor(StAXArtifactProcessor<?> artifactProcessor) {
        if (artifactProcessor.getArtifactType() != null) {
            this.processorsByArtifactType.put(artifactProcessor.getArtifactType(), artifactProcessor);
        }
        if (artifactProcessor.getModelType() != null) {
            this.processorsByModelType.put(artifactProcessor.getModelType(), artifactProcessor);
        }
    }

    @Override
    public void removeArtifactProcessor(StAXArtifactProcessor<?> artifactProcessor) {
        if (artifactProcessor.getArtifactType() != null) {
            this.processorsByArtifactType.remove(artifactProcessor.getArtifactType());
        }
        if (artifactProcessor.getModelType() != null) {
            this.processorsByModelType.remove(artifactProcessor.getModelType());
        }
    }

    @Override
    public <T> StAXArtifactProcessor<T> getProcessor(Class<T> modelType) {
        this.loadArtifactProcessors();
        return (StAXArtifactProcessor)super.getProcessor(modelType);
    }

    @Override
    public StAXArtifactProcessor<?> getProcessor(Object artifactType) {
        this.loadArtifactProcessors();
        return (StAXArtifactProcessor)super.getProcessor(artifactType);
    }

    private synchronized void loadArtifactProcessors() {
        Collection<ServiceDeclaration> processorDeclarations;
        if (this.loaded) {
            return;
        }
        try {
            processorDeclarations = this.registry.getServiceDiscovery().getServiceDeclarations(StAXArtifactProcessor.class.getName());
        }
        catch (IOException e) {
            IllegalStateException ie = new IllegalStateException(e);
            throw ie;
        }
        for (ServiceDeclaration processorDeclaration : processorDeclarations) {
            Map<String, String> attributes = processorDeclaration.getAttributes();
            QName artifactType = ServiceDeclarationParser.getQName(attributes.get("qname"));
            String modelTypeName = attributes.get("model");
            String factoryName = attributes.get("factory");
            LazyStAXArtifactProcessor processor = new LazyStAXArtifactProcessor(artifactType, modelTypeName, factoryName, processorDeclaration, this.registry, this.modelFactories, this.extensibleStAXProcessor, this.extensibleStAXAttributeProcessor);
            this.addArtifactProcessor(processor);
        }
        this.loaded = true;
    }

    private static class LazyStAXArtifactProcessor
    implements StAXArtifactProcessor {
        private ExtensionPointRegistry extensionPoints;
        private QName artifactType;
        private String modelTypeName;
        private String factoryName;
        private ServiceDeclaration processorDeclaration;
        private StAXArtifactProcessor<?> processor;
        private Class<?> modelType;
        private StAXArtifactProcessor<Object> extensionProcessor;
        private StAXAttributeProcessor<Object> extensionAttributeProcessor;

        LazyStAXArtifactProcessor(QName artifactType, String modelTypeName, String factoryName, ServiceDeclaration processorDeclaration, ExtensionPointRegistry extensionPoints, FactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, StAXAttributeProcessor<Object> extensionAttributeProcessor) {
            this.extensionPoints = extensionPoints;
            this.artifactType = artifactType;
            this.modelTypeName = modelTypeName;
            this.factoryName = factoryName;
            this.processorDeclaration = processorDeclaration;
            this.extensionProcessor = extensionProcessor;
            this.extensionAttributeProcessor = extensionAttributeProcessor;
        }

        @Override
        public QName getArtifactType() {
            return this.artifactType;
        }

        private void error(Monitor monitor, String message, Object model, Exception ex) {
            if (monitor != null) {
                Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, ex);
                monitor.problem(problem);
            }
        }

        private StAXArtifactProcessor getProcessor() {
            if (this.processor == null) {
                if (this.processorDeclaration.getClassName().equals("org.apache.tuscany.sca.assembly.xml.DefaultBeanModelProcessor")) {
                    FactoryExtensionPoint modelFactories = this.extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
                    try {
                        Object modelFactory;
                        Class<?> processorClass = this.processorDeclaration.loadClass();
                        if (this.factoryName != null) {
                            Class<?> factoryClass = this.processorDeclaration.loadClass(this.factoryName);
                            modelFactory = modelFactories.getFactory(factoryClass);
                        } else {
                            modelFactory = null;
                        }
                        Constructor<?> constructor = processorClass.getConstructor(FactoryExtensionPoint.class, QName.class, Class.class, Object.class);
                        this.processor = (StAXArtifactProcessor)constructor.newInstance(modelFactories, this.artifactType, this.getModelType(), modelFactory);
                    }
                    catch (Exception e) {
                        IllegalStateException ie = new IllegalStateException(e);
                        throw ie;
                    }
                }
                FactoryExtensionPoint modelFactories = this.extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
                try {
                    Class<?> processorClass = this.processorDeclaration.loadClass();
                    try {
                        Constructor<?> constructor = processorClass.getConstructor(FactoryExtensionPoint.class);
                        this.processor = (StAXArtifactProcessor)constructor.newInstance(modelFactories);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Constructor<?> constructor = processorClass.getConstructor(ExtensionPointRegistry.class);
                            this.processor = (StAXArtifactProcessor)constructor.newInstance(this.extensionPoints);
                        }
                        catch (NoSuchMethodException e1) {
                            try {
                                Constructor<?> constructor = processorClass.getConstructor(FactoryExtensionPoint.class, StAXArtifactProcessor.class);
                                this.processor = (StAXArtifactProcessor)constructor.newInstance(modelFactories, this.extensionProcessor);
                            }
                            catch (NoSuchMethodException e2) {
                                try {
                                    Constructor<?> constructor = processorClass.getConstructor(FactoryExtensionPoint.class, StAXArtifactProcessor.class, StAXAttributeProcessor.class);
                                    this.processor = (StAXArtifactProcessor)constructor.newInstance(modelFactories, this.extensionProcessor, this.extensionAttributeProcessor);
                                }
                                catch (NoSuchMethodException e2a) {
                                    try {
                                        Constructor<?> constructor = processorClass.getConstructor(ExtensionPointRegistry.class, StAXArtifactProcessor.class);
                                        this.processor = (StAXArtifactProcessor)constructor.newInstance(this.extensionPoints, this.extensionProcessor);
                                    }
                                    catch (NoSuchMethodException e3) {
                                        try {
                                            Constructor<?> constructor = processorClass.getConstructor(ExtensionPointRegistry.class, StAXArtifactProcessor.class, StAXAttributeProcessor.class);
                                            this.processor = (StAXArtifactProcessor)constructor.newInstance(this.extensionPoints, this.extensionProcessor, this.extensionAttributeProcessor);
                                        }
                                        catch (NoSuchMethodException e3a) {
                                            Constructor<?> constructor = processorClass.getConstructor(new Class[0]);
                                            this.processor = (StAXArtifactProcessor)constructor.newInstance(new Object[0]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    IllegalStateException ie = new IllegalStateException(e);
                    throw ie;
                }
            }
            return this.processor;
        }

        public Object read(XMLStreamReader inputSource, ProcessorContext context) throws ContributionReadException, XMLStreamException {
            return this.getProcessor().read(inputSource, context);
        }

        public void write(Object model, XMLStreamWriter outputSource, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
            this.getProcessor().write(model, outputSource, context);
        }

        @Override
        public Class<?> getModelType() {
            if (this.modelTypeName != null && this.modelType == null) {
                try {
                    this.modelType = this.processorDeclaration.loadClass(this.modelTypeName);
                }
                catch (Exception e) {
                    IllegalStateException ie = new IllegalStateException(e);
                    throw ie;
                }
            }
            return this.modelType;
        }

        @Override
        public void resolve(Object model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
            this.getProcessor().resolve(model, resolver, context);
        }
    }
}

