/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.java.JavaImportExportFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class JavaImportProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<JavaImport> {
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    private static final QName IMPORT_JAVA = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "import.java");
    private static final String PACKAGE = "package";
    private static final String LOCATION = "location";
    private final JavaImportExportFactory factory;

    public JavaImportProcessor(FactoryExtensionPoint modelFactories) {
        this.factory = modelFactories.getFactory(JavaImportExportFactory.class);
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-java-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return IMPORT_JAVA;
    }

    @Override
    public Class<JavaImport> getModelType() {
        return JavaImport.class;
    }

    @Override
    public JavaImport read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException {
        JavaImport javaImport = this.factory.createJavaImport();
        QName element = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        element = reader.getName();
                        if (!IMPORT_JAVA.equals(element)) break;
                        String packageName = reader.getAttributeValue(null, PACKAGE);
                        if (packageName == null) {
                            this.error(context.getMonitor(), "AttributePackageMissing", reader, new Object[0]);
                        } else {
                            javaImport.setPackage(packageName);
                        }
                        String location = this.getURIString(reader, LOCATION);
                        javaImport.setLocation(location);
                        break;
                    }
                    case 2: {
                        if (!IMPORT_JAVA.equals(reader.getName())) break;
                        return javaImport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error(context.getMonitor(), "XMLStreamException", reader, ex);
        }
        return javaImport;
    }

    @Override
    public void write(JavaImport javaImport, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(IMPORT_JAVA.getNamespaceURI(), IMPORT_JAVA.getLocalPart());
        if (javaImport.getPackage() != null) {
            writer.writeAttribute(PACKAGE, javaImport.getPackage());
        }
        if (javaImport.getLocation() != null) {
            writer.writeAttribute(LOCATION, javaImport.getLocation());
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(JavaImport model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }
}

