/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.xml.stax.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class NamespaceContextImpl
implements NamespaceContext {
    private NamespaceContext parent;
    private Map<String, String> map = new HashMap<String, String>();

    public NamespaceContextImpl(NamespaceContext parent) {
        this.parent = parent;
        if (parent == null) {
            this.map.put("xml", "http://www.w3.org/XML/1998/namespace");
            this.map.put("xmlns", "http://www.w3.org/2000/xmlns/");
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix is null");
        }
        String ns = this.map.get(prefix);
        if (ns != null) {
            return ns;
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        return null;
    }

    @Override
    public String getPrefix(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException("Namespace is null");
        }
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!entry.getValue().equals(nsURI)) continue;
            return entry.getKey();
        }
        if (this.parent != null) {
            return this.parent.getPrefix(nsURI);
        }
        return null;
    }

    public Iterator getPrefixes(String nsURI) {
        ArrayList<String> prefixList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!entry.getValue().equals(nsURI)) continue;
            prefixList.add(entry.getKey());
        }
        final Iterator currentIterator = prefixList.iterator();
        final Iterator<String> parentIterator = this.parent == null ? null : this.parent.getPrefixes(nsURI);
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return currentIterator.hasNext() || parentIterator != null && parentIterator.hasNext();
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException("End of iterator has reached");
                }
                return currentIterator.hasNext() ? currentIterator.next() : parentIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void register(String prefix, String ns) {
        this.map.put(prefix, ns);
    }

    public NamespaceContext getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.map.toString());
        if (this.parent != null) {
            sb.append("\nParent: ");
            sb.append(this.parent);
        }
        return sb.toString();
    }
}

