/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.java.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public class IOHelper {
    public static InputStream openStream(URL url) throws IOException {
        File file = IOHelper.toFile(url);
        if (file != null) {
            return new FileInputStream(file);
        }
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            connection.setUseCaches(false);
        }
        InputStream is = connection.getInputStream();
        return is;
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static URI createURI(String uri) {
        if (uri == null) {
            return null;
        }
        if (uri.indexOf(37) != -1) {
            return URI.create(uri);
        }
        int index = uri.indexOf(58);
        String scheme = null;
        String ssp = uri;
        if (index != -1) {
            scheme = uri.substring(0, index);
            ssp = uri.substring(index + 1);
        }
        try {
            return new URI(scheme, ssp, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URI toURI(URL url) {
        if (url == null) {
            return null;
        }
        return IOHelper.createURI(url.toString());
    }

    public static URL normalize(URL url) {
        try {
            File file = IOHelper.toFile(url);
            if (file != null) {
                return file.toURI().toURL();
            }
            return IOHelper.toURI(url).toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static File toFile(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = 0;
        while ((pos = filename.indexOf(37, pos)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return new File(filename);
    }

    public static URL codeLocation(Class<?> clazz) {
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (url == null) {
            url = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class");
        }
        return url;
    }

    public static URL getLocationAsURL(String location) {
        URI uri = IOHelper.createURI(location);
        if (uri.getScheme() == null) {
            uri = new File(location).toURI();
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(location, e);
        }
    }
}

