/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.client.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.oasisopen.sca.NoSuchServiceException;

public class SCAClientProxyHandler
implements InvocationHandler {
    protected EndpointRegistry endpointRegistry;
    protected EndpointReference endpointReference;
    protected String serviceName;

    public SCAClientProxyHandler(String serviceName, ExtensionPointRegistry extensionsRegistry, EndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
        this.serviceName = serviceName;
        FactoryExtensionPoint factories = extensionsRegistry.getExtensionPoint(FactoryExtensionPoint.class);
        AssemblyFactory assemblyFactory = factories.getFactory(AssemblyFactory.class);
        this.endpointReference = assemblyFactory.createEndpointReference();
        this.endpointReference.setReference(assemblyFactory.createComponentReference());
        Endpoint targetEndpoint = assemblyFactory.createEndpoint();
        targetEndpoint.setURI(serviceName);
        this.endpointReference.setTargetEndpoint(targetEndpoint);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        List<Endpoint> endpoints = this.endpointRegistry.findEndpoint(this.endpointReference);
        if (endpoints.size() < 1) {
            throw new NoSuchServiceException(this.serviceName);
        }
        String uri = endpoints.get(0).getBinding().getURI();
        return null;
    }
}

