/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.client.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.node.NodeFactory;
import org.apache.tuscany.sca.node.impl.NodeFactoryImpl;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeProperties;
import org.oasisopen.sca.NoSuchDomainException;
import org.oasisopen.sca.NoSuchServiceException;
import org.oasisopen.sca.ServiceRuntimeException;

public class SCAClientHandler
implements InvocationHandler {
    private String domainURI;
    private String serviceName;
    private Class<?> serviceInterface;

    public SCAClientHandler(String domainURI, String serviceName, Class<?> serviceInterface) {
        this.domainURI = domainURI;
        this.serviceName = serviceName;
        this.serviceInterface = serviceInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDomain() throws NoSuchDomainException {
        NodeFactoryImpl nodeFactory = (NodeFactoryImpl)NodeFactory.newInstance(this.domainURI);
        try {
            nodeFactory.init();
            ExtensionPointRegistry extensionsRegistry = nodeFactory.getExtensionPointRegistry();
            Properties props = extensionsRegistry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(RuntimeProperties.class).getProperties();
            props.setProperty("client", "true");
            ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance(extensionsRegistry);
            String registryURI = this.domainURI;
            if (registryURI.indexOf(":") == -1) {
                registryURI = "tuscanyclient:" + registryURI;
            }
            if (registryURI.startsWith("uri:")) {
                registryURI = "tuscanyclient:" + registryURI.substring(4);
            }
            if (registryURI.startsWith("tuscany:")) {
                registryURI = "tuscanyclient:" + registryURI.substring(8);
            }
            try {
                domainRegistryFactory.getEndpointRegistry(registryURI, this.domainURI);
            }
            catch (Exception e) {
                throw new NoSuchDomainException(this.domainURI, e);
            }
        }
        finally {
            nodeFactory.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        NodeFactoryImpl nodeFactory = (NodeFactoryImpl)NodeFactory.newInstance(this.domainURI);
        try {
            RuntimeEndpointReference epr;
            EndpointRegistry endpointRegistry;
            nodeFactory.init();
            ExtensionPointRegistry extensionsRegistry = nodeFactory.getExtensionPointRegistry();
            Properties props = extensionsRegistry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(RuntimeProperties.class).getProperties();
            props.setProperty("client", "true");
            ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance(extensionsRegistry);
            String registryURI = this.domainURI;
            if (registryURI.indexOf(":") == -1) {
                registryURI = "tuscanyclient:" + registryURI;
            }
            if (registryURI.startsWith("uri:")) {
                registryURI = "tuscanyclient:" + registryURI.substring(4);
            }
            if (registryURI.startsWith("tuscany:")) {
                registryURI = "tuscanyclient:" + registryURI.substring(8);
            }
            try {
                endpointRegistry = domainRegistryFactory.getEndpointRegistry(registryURI, this.domainURI);
            }
            catch (Exception e) {
                throw new NoSuchDomainException(this.domainURI, e);
            }
            FactoryExtensionPoint factories = extensionsRegistry.getExtensionPoint(FactoryExtensionPoint.class);
            AssemblyFactory assemblyFactory = factories.getFactory(AssemblyFactory.class);
            JavaInterfaceFactory javaInterfaceFactory = factories.getFactory(JavaInterfaceFactory.class);
            ExtensibleProxyFactory proxyFactory = new ExtensibleProxyFactory(extensionsRegistry.getExtensionPoint(ProxyFactoryExtensionPoint.class));
            String client = "sca.client." + UUID.randomUUID();
            CompositeContext compositeContext = new CompositeContext(extensionsRegistry, endpointRegistry, null, this.domainURI.toString(), client, nodeFactory.getDeployer().getSystemDefinitions());
            List<Endpoint> eps = endpointRegistry.findEndpoint(this.serviceName);
            if (eps == null || eps.size() < 1) {
                throw new NoSuchServiceException(this.serviceName);
            }
            Endpoint endpoint = eps.get(0);
            try {
                epr = this.createEndpointReference(javaInterfaceFactory, compositeContext, assemblyFactory, endpoint, this.serviceInterface);
            }
            catch (Exception e) {
                throw new ServiceRuntimeException(e);
            }
            InvocationHandler handler = Proxy.getInvocationHandler(proxyFactory.createProxy(this.serviceInterface, epr));
            Object object = handler.invoke(proxy, method, args);
            return object;
        }
        finally {
            nodeFactory.destroy();
        }
    }

    private RuntimeEndpointReference createEndpointReference(JavaInterfaceFactory javaInterfaceFactory, CompositeContext compositeContext, AssemblyFactory assemblyFactory, Endpoint endpoint, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Component component = endpoint.getComponent();
        ComponentService service = endpoint.getService();
        ComponentReference componentReference = assemblyFactory.createComponentReference();
        componentReference.setName("sca.client." + service.getName());
        componentReference.setCallback(service.getCallback());
        componentReference.getTargets().add(service);
        componentReference.getPolicySets().addAll(service.getPolicySets());
        componentReference.getRequiredIntents().addAll(service.getRequiredIntents());
        componentReference.getBindings().add(endpoint.getBinding());
        InterfaceContract interfaceContract = service.getInterfaceContract();
        Service componentTypeService = service.getService();
        if (componentTypeService != null && componentTypeService.getInterfaceContract() != null) {
            interfaceContract = componentTypeService.getInterfaceContract();
        }
        interfaceContract = this.getInterfaceContract(javaInterfaceFactory, interfaceContract, businessInterface);
        componentReference.setInterfaceContract(interfaceContract);
        componentReference.setMultiplicity(Multiplicity.ONE_ONE);
        EndpointReference endpointReference = assemblyFactory.createEndpointReference();
        endpointReference.setComponent(component);
        endpointReference.setReference(componentReference);
        endpointReference.setBinding(endpoint.getBinding());
        endpointReference.setUnresolved(false);
        endpointReference.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
        endpointReference.setTargetEndpoint(endpoint);
        componentReference.getEndpointReferences().add(endpointReference);
        ((RuntimeComponentReference)componentReference).setComponent((RuntimeComponent)component);
        ((RuntimeEndpointReference)endpointReference).bind(compositeContext);
        return (RuntimeEndpointReference)endpointReference;
    }

    private InterfaceContract getInterfaceContract(JavaInterfaceFactory javaInterfaceFactory, InterfaceContract interfaceContract, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Class<?> cls;
        Interface interfaze;
        if (businessInterface == null) {
            return interfaceContract;
        }
        boolean compatible = false;
        if (interfaceContract != null && interfaceContract.getInterface() != null && (interfaze = interfaceContract.getInterface()) instanceof JavaInterface && (cls = ((JavaInterface)interfaze).getJavaClass()) != null && businessInterface.isAssignableFrom(cls)) {
            compatible = true;
        }
        if (!compatible) {
            interfaceContract = javaInterfaceFactory.createJavaInterfaceContract();
            JavaInterface callInterface = javaInterfaceFactory.createJavaInterface(businessInterface);
            interfaceContract.setInterface(callInterface);
            if (callInterface.getCallbackClass() != null) {
                interfaceContract.setCallbackInterface(javaInterfaceFactory.createJavaInterface(callInterface.getCallbackClass()));
            }
        }
        return interfaceContract;
    }
}

