/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.client.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.List;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.client.impl.SCAClientHandler;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.NodeFactory;
import org.apache.tuscany.sca.node.impl.NodeFactoryImpl;
import org.apache.tuscany.sca.node.impl.NodeImpl;
import org.oasisopen.sca.NoSuchDomainException;
import org.oasisopen.sca.NoSuchServiceException;
import org.oasisopen.sca.client.SCAClientFactory;
import org.oasisopen.sca.client.SCAClientFactoryFinder;

public class SCAClientFactoryImpl2
extends SCAClientFactory {
    public static void setSCAClientFactoryFinder(SCAClientFactoryFinder factoryFinder) {
        SCAClientFactory.factoryFinder = factoryFinder;
    }

    public SCAClientFactoryImpl2(URI domainURI) throws NoSuchDomainException {
        super(domainURI);
        this.checkDomainURI(domainURI);
    }

    private void checkDomainURI(URI domainURI) throws NoSuchDomainException {
        String domainName = this.getDomainName();
        for (NodeFactory nodeFactory : NodeFactory.getNodeFactories()) {
            List<Node> nodes = ((NodeFactoryImpl)nodeFactory).getNodesInDomain(domainName);
            if (nodes.isEmpty()) continue;
            return;
        }
        SCAClientHandler handler = new SCAClientHandler(domainName, null, null);
        handler.checkDomain();
    }

    @Override
    public <T> T getService(Class<T> serviceInterface, String serviceName) throws NoSuchServiceException, NoSuchDomainException {
        boolean foundDomain = false;
        for (NodeFactory nodeFactory : NodeFactory.getNodeFactories()) {
            for (Node node : ((NodeFactoryImpl)nodeFactory).getNodesInDomain(this.getDomainName())) {
                foundDomain = true;
                for (Endpoint ep : ((NodeImpl)node).getServiceEndpoints()) {
                    if (!ep.matches(serviceName)) continue;
                    return node.getService(serviceInterface, serviceName);
                }
            }
        }
        if (foundDomain) {
            throw new NoSuchServiceException(serviceName);
        }
        SCAClientHandler handler = new SCAClientHandler(this.getDomainURI().toString(), serviceName, serviceInterface);
        return (T)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface}, (InvocationHandler)handler);
    }

    private String getDomainName() {
        String domainName = this.getDomainURI().toString();
        return domainName;
    }
}

