/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.client.impl;

import java.net.URI;
import java.util.List;
import java.util.UUID;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.node.NodeFactory;
import org.apache.tuscany.sca.node.impl.NodeFactoryImpl;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.NoSuchDomainException;
import org.oasisopen.sca.NoSuchServiceException;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.client.SCAClientFactory;
import org.oasisopen.sca.client.SCAClientFactoryFinder;

public class SCAClientFactoryImpl
extends SCAClientFactory {
    private final ExtensionPointRegistry extensionsRegistry;
    private final AssemblyFactory assemblyFactory;
    private final JavaInterfaceFactory javaInterfaceFactory;
    private final ProxyFactory proxyFactory;
    private final EndpointRegistry endpointRegistry;
    private final NodeFactoryImpl nodeFactory = (NodeFactoryImpl)NodeFactory.getInstance();
    private final CompositeContext compositeContext;

    public static void setSCAClientFactoryFinder(SCAClientFactoryFinder factoryFinder) {
        SCAClientFactory.factoryFinder = factoryFinder;
    }

    public SCAClientFactoryImpl(URI domainURI) throws NoSuchDomainException {
        super(domainURI);
        this.nodeFactory.init();
        this.extensionsRegistry = this.nodeFactory.getExtensionPointRegistry();
        ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance(this.extensionsRegistry);
        String registryURI = this.getDomainURI().toString();
        this.endpointRegistry = domainRegistryFactory.getEndpointRegistry(registryURI, this.getDomainURI().toString());
        if (this.endpointRegistry == null) {
            throw new NoSuchDomainException(domainURI.toString());
        }
        FactoryExtensionPoint factories = this.extensionsRegistry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = factories.getFactory(AssemblyFactory.class);
        this.javaInterfaceFactory = factories.getFactory(JavaInterfaceFactory.class);
        this.proxyFactory = ExtensibleProxyFactory.getInstance(this.extensionsRegistry);
        String client = "sca.client." + UUID.randomUUID();
        this.compositeContext = new CompositeContext(this.extensionsRegistry, this.endpointRegistry, null, domainURI.toString(), client, this.nodeFactory.getDeployer().getSystemDefinitions());
    }

    @Override
    public <T> T getService(Class<T> serviceInterface, String serviceName) throws NoSuchServiceException, NoSuchDomainException {
        RuntimeEndpointReference epr;
        List<Endpoint> eps = this.endpointRegistry.findEndpoint(serviceName);
        if (eps == null || eps.size() < 1) {
            throw new NoSuchServiceException(serviceName);
        }
        Endpoint endpoint = eps.get(0);
        try {
            epr = this.createEndpointReference(endpoint, serviceInterface);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        return this.proxyFactory.createProxy(serviceInterface, epr);
    }

    private RuntimeEndpointReference createEndpointReference(Endpoint endpoint, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Component component = endpoint.getComponent();
        ComponentService service = endpoint.getService();
        ComponentReference componentReference = this.assemblyFactory.createComponentReference();
        componentReference.setName("sca.client." + service.getName());
        componentReference.setCallback(service.getCallback());
        componentReference.getTargets().add(service);
        componentReference.getPolicySets().addAll(service.getPolicySets());
        componentReference.getRequiredIntents().addAll(service.getRequiredIntents());
        componentReference.getBindings().add(endpoint.getBinding());
        InterfaceContract interfaceContract = service.getInterfaceContract();
        Service componentTypeService = service.getService();
        if (componentTypeService != null && componentTypeService.getInterfaceContract() != null) {
            interfaceContract = componentTypeService.getInterfaceContract();
        }
        interfaceContract = this.getInterfaceContract(interfaceContract, businessInterface);
        componentReference.setInterfaceContract(interfaceContract);
        componentReference.setMultiplicity(Multiplicity.ONE_ONE);
        EndpointReference endpointReference = this.assemblyFactory.createEndpointReference();
        endpointReference.setComponent(component);
        endpointReference.setReference(componentReference);
        endpointReference.setBinding(endpoint.getBinding());
        endpointReference.setUnresolved(false);
        endpointReference.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
        endpointReference.setTargetEndpoint(endpoint);
        componentReference.getEndpointReferences().add(endpointReference);
        ((RuntimeComponentReference)componentReference).setComponent((RuntimeComponent)component);
        ((RuntimeEndpointReference)endpointReference).bind(this.compositeContext);
        return (RuntimeEndpointReference)endpointReference;
    }

    private InterfaceContract getInterfaceContract(InterfaceContract interfaceContract, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Class<?> cls;
        Interface interfaze;
        if (businessInterface == null) {
            return interfaceContract;
        }
        boolean compatible = false;
        if (interfaceContract != null && interfaceContract.getInterface() != null && (interfaze = interfaceContract.getInterface()) instanceof JavaInterface && (cls = ((JavaInterface)interfaze).getJavaClass()) != null && businessInterface.isAssignableFrom(cls)) {
            compatible = true;
        }
        if (!compatible) {
            interfaceContract = this.javaInterfaceFactory.createJavaInterfaceContract();
            JavaInterface callInterface = this.javaInterfaceFactory.createJavaInterface(businessInterface);
            interfaceContract.setInterface(callInterface);
            if (callInterface.getCallbackClass() != null) {
                interfaceContract.setCallbackInterface(this.javaInterfaceFactory.createJavaInterface(callInterface.getCallbackClass()));
            }
        }
        return interfaceContract;
    }
}

