/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.builder.impl.PolicyAttachmentBuilderImpl;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicyAppliesToBuilderImpl
extends PolicyAttachmentBuilderImpl {
    public PolicyAppliesToBuilderImpl(ExtensionPointRegistry registry) {
        super(registry);
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.policy.builder.PolicyAppliesToBuilder";
    }

    @Override
    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        try {
            Document document = this.saveAsDOM(composite);
            HashMap<PolicySet, List<PolicySubject>> appliesToSubjects = new HashMap<PolicySet, List<PolicySubject>>();
            return this.checkAppliesTo(document, appliesToSubjects, composite, context);
        }
        catch (Exception e) {
            throw new CompositeBuilderException(e);
        }
    }

    private Composite checkAppliesTo(Document document, Map<PolicySet, List<PolicySubject>> appliesToSubjects, Composite topComposite, BuilderContext context) throws Exception {
        for (Component component : topComposite.getComponents()) {
            if (!(component.getImplementation() instanceof Composite)) continue;
            Composite nested = (Composite)component.getImplementation();
            this.checkAppliesTo(this.saveAsDOM(nested), new HashMap<PolicySet, List<PolicySubject>>(), nested, context);
        }
        for (Component component : topComposite.getComponents()) {
            List<PolicySet> policySetsToRemove;
            for (ComponentService componentService : component.getServices()) {
                for (Endpoint ep : componentService.getEndpoints()) {
                    policySetsToRemove = this.checkAppliesToSubject(document, appliesToSubjects, topComposite, ep.getService(), ep.getService().getPolicySets());
                    ep.getPolicySets().removeAll(policySetsToRemove);
                    if (!(ep.getBinding() instanceof PolicySubject)) continue;
                    policySetsToRemove = this.checkAppliesToSubject(document, appliesToSubjects, topComposite, (PolicySubject)((Object)ep.getBinding()), ((PolicySubject)((Object)ep.getBinding())).getPolicySets());
                    ep.getPolicySets().removeAll(policySetsToRemove);
                }
            }
            for (ComponentReference componentReference : component.getReferences()) {
                for (EndpointReference epr : componentReference.getEndpointReferences()) {
                    policySetsToRemove = this.checkAppliesToSubject(document, appliesToSubjects, topComposite, epr.getReference(), epr.getReference().getPolicySets());
                    epr.getPolicySets().removeAll(policySetsToRemove);
                    if (!(epr.getBinding() instanceof PolicySubject)) continue;
                    policySetsToRemove = this.checkAppliesToSubject(document, appliesToSubjects, topComposite, (PolicySubject)((Object)epr.getBinding()), ((PolicySubject)((Object)epr.getBinding())).getPolicySets());
                    epr.getPolicySets().removeAll(policySetsToRemove);
                }
            }
            Implementation implementation = component.getImplementation();
            if (implementation == null || !(implementation instanceof PolicySubject)) continue;
            this.checkAppliesToSubject(document, appliesToSubjects, topComposite, implementation, implementation.getPolicySets());
        }
        return topComposite;
    }

    private List<PolicySet> checkAppliesToSubject(Document document, Map<PolicySet, List<PolicySubject>> appliesToSubjects, Composite composite, PolicySubject policySubject, List<PolicySet> policySets) throws Exception {
        ArrayList<PolicySet> policySetsToRemove = new ArrayList<PolicySet>();
        for (PolicySet policySet : policySets) {
            XPathExpression appliesTo;
            List<PolicySubject> subjects = appliesToSubjects.get(policySet);
            if (subjects == null && (appliesTo = policySet.getAppliesToXPathExpression()) != null) {
                NodeList nodes = (NodeList)appliesTo.evaluate(document, XPathConstants.NODESET);
                if (nodes.getLength() > 0) {
                    subjects = new ArrayList<PolicySubject>();
                    appliesToSubjects.put(policySet, subjects);
                }
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String index = PolicyAppliesToBuilderImpl.getStructuralURI(node);
                    PolicySubject subject = this.lookup(composite, index);
                    if (subject == null) continue;
                    subjects.add(subject);
                }
            }
            if (subjects == null || subjects.contains(policySubject)) continue;
            policySetsToRemove.add(policySet);
        }
        policySets.removeAll(policySetsToRemove);
        return policySetsToRemove;
    }
}

