/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;

public class EndpointBuilderImpl
implements CompositeBuilder {
    private static final String BUILDER_VALIDATION_BUNDLE = "org.apache.tuscany.sca.builder.builder-validation-messages";
    private AssemblyFactory assemblyFactory;

    public EndpointBuilderImpl(ExtensionPointRegistry registry) {
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
    }

    @Override
    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        this.processComponentServices(composite, context);
        return composite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processComponentServices(Composite composite, BuilderContext context) {
        Monitor monitor = context.getMonitor();
        for (Component component : composite.getComponents()) {
            try {
                monitor.pushContext("Component: " + component.getName().toString());
                Implementation implementation = component.getImplementation();
                if (implementation instanceof Composite) {
                    this.processComponentServices((Composite)implementation, context);
                }
                for (ComponentService service : component.getServices()) {
                    try {
                        monitor.pushContext("Service: " + service.getName());
                        List asyncOperations = null;
                        try {
                            asyncOperations = (List)service.getInterfaceContract().getInterface().getAttributes().get("JAXWS-ASYNC-OPERATIONS");
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (asyncOperations != null && !asyncOperations.isEmpty()) {
                            Monitor.error(monitor, (Object)this, BUILDER_VALIDATION_BUNDLE, "JaxWSClientAsyncMethodsNotAllowed", service, service.getName());
                        }
                        for (Binding binding : service.getBindings()) {
                            Endpoint endpoint = this.assemblyFactory.createEndpoint();
                            endpoint.setComponent(component);
                            endpoint.setService(service);
                            endpoint.setBinding(binding);
                            endpoint.setUnresolved(false);
                            service.getEndpoints().add(endpoint);
                        }
                    }
                    finally {
                        monitor.popContext();
                    }
                }
            }
            finally {
                monitor.popContext();
            }
        }
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.EndpointBuilder";
    }
}

