/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.builder.ContractBuilder;
import org.apache.tuscany.sca.builder.impl.ComponentBuilderImpl;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.Compatibility;
import org.apache.tuscany.sca.interfacedef.IncompatibleInterfaceContractException;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.PolicySubject;

public class CompositeComponentTypeBuilderImpl {
    private static final Logger logger = Logger.getLogger(CompositeComponentTypeBuilderImpl.class.getName());
    protected static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    protected static final String BINDING_SCA = "binding.sca";
    protected static final QName BINDING_SCA_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.sca");
    private ComponentBuilderImpl componentBuilder;
    private AssemblyFactory assemblyFactory;
    private SCABindingFactory scaBindingFactory;
    private InterfaceContractMapper interfaceContractMapper;
    private BuilderExtensionPoint builders;
    private ContractBuilder contractBuilder;

    public CompositeComponentTypeBuilderImpl(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.scaBindingFactory = modelFactories.getFactory(SCABindingFactory.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
        this.builders = registry.getExtensionPoint(BuilderExtensionPoint.class);
        this.contractBuilder = this.builders.getContractBuilder();
    }

    public void setComponentBuilder(ComponentBuilderImpl componentBuilder) {
        this.componentBuilder = componentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createComponentType(Component outerComponent, Composite composite, BuilderContext context) {
        Monitor monitor = context.getMonitor();
        monitor.pushContext("Composite: " + composite.getName().toString());
        try {
            for (Component component : composite.getComponents()) {
                if (component != composite.getComponent(component.getName())) {
                    Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "DuplicateComponentName", composite.getName().toString(), component.getName());
                }
                if (component.getAutowire() == null) {
                    component.setAutowire(composite.getAutowire());
                }
                this.componentBuilder.configureComponentFromComponentType(outerComponent, composite, component, context);
            }
            HashMap<String, Component> components = new HashMap<String, Component>();
            HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
            HashMap<String, ComponentReference> componentReferences = new HashMap<String, ComponentReference>();
            this.indexComponentsServicesAndReferences(composite, components, componentServices, componentReferences);
            this.calculateServices(composite, components, componentServices, context);
            this.calculateReferences(composite, components, componentReferences, context);
        }
        finally {
            monitor.popContext();
        }
    }

    private void indexComponentsServicesAndReferences(Composite composite, Map<String, Component> components, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences) {
        for (Component component : composite.getComponents()) {
            String uri;
            components.put(component.getName(), component);
            ComponentService nonCallbackService = null;
            int nonCallbackServices = 0;
            for (ComponentService componentService : component.getServices()) {
                uri = component.getName() + '/' + componentService.getName();
                componentServices.put(uri, componentService);
                if (componentService.isForCallback()) continue;
                if (nonCallbackServices == 0) {
                    nonCallbackService = componentService;
                }
                ++nonCallbackServices;
            }
            if (nonCallbackServices == 1) {
                componentServices.put(component.getName(), nonCallbackService);
            }
            for (ComponentReference componentReference : component.getReferences()) {
                uri = component.getName() + '/' + componentReference.getName();
                componentReferences.put(uri, componentReference);
            }
        }
    }

    private void calculateServices(ComponentType componentType, Map<String, Component> components, Map<String, ComponentService> componentServices, BuilderContext context) {
        Monitor monitor = context.getMonitor();
        this.connectPromotedServices(componentType, components, componentServices, monitor);
        for (Service service : componentType.getServices()) {
            CompositeService compositeService = (CompositeService)service;
            ComponentService promotedComponentService = compositeService.getPromotedService();
            this.calculatePromotedServiceInterfaceContract(compositeService, promotedComponentService, monitor);
            this.calculatePromotedBindings(compositeService, promotedComponentService);
            this.componentBuilder.policyBuilder.configure(compositeService, context);
        }
    }

    private void calculateReferences(ComponentType componentType, Map<String, Component> components, Map<String, ComponentReference> componentReferences, BuilderContext context) {
        Monitor monitor = context.getMonitor();
        this.connectPromotedReferences(componentType, components, componentReferences, monitor);
        for (Reference reference : componentType.getReferences()) {
            CompositeReference compositeReference = (CompositeReference)reference;
            List<ComponentReference> promotedReferences = compositeReference.getPromotedReferences();
            for (ComponentReference promotedComponentReference : promotedReferences) {
                this.reconcileReferenceMultiplicity(componentType, compositeReference, promotedComponentReference, monitor);
                this.validateNonOverridable(componentType, compositeReference, promotedComponentReference, monitor);
                this.calculatePromotedReferenceInterfaceContract(compositeReference, promotedComponentReference, monitor);
            }
            this.componentBuilder.policyBuilder.configure(compositeReference, context);
        }
    }

    private void connectPromotedServices(ComponentType componentType, Map<String, Component> components, Map<String, ComponentService> componentServices, Monitor monitor) {
        for (Service service : componentType.getServices()) {
            CompositeService compositeService = (CompositeService)service;
            ComponentService componentService = compositeService.getPromotedService();
            if (componentService == null || !componentService.isUnresolved()) continue;
            String promotedComponentName = compositeService.getPromotedComponent().getName();
            String promotedServiceName = componentService.getName() != null ? (compositeService.isForCallback() ? componentService.getName() : promotedComponentName + '/' + componentService.getName()) : promotedComponentName;
            ComponentService promotedService = componentServices.get(promotedServiceName);
            if (promotedService != null) {
                Component promotedComponent = components.get(promotedComponentName);
                compositeService.setPromotedComponent(promotedComponent);
                compositeService.setPromotedService(promotedService);
                continue;
            }
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PromotedServiceNotFound", ((Composite)componentType).getName().toString(), promotedServiceName);
        }
    }

    private void connectPromotedReferences(ComponentType componentType, Map<String, Component> components, Map<String, ComponentReference> componentReferences, Monitor monitor) {
        for (Reference reference : componentType.getReferences()) {
            CompositeReference compositeReference = (CompositeReference)reference;
            List<ComponentReference> promotedReferences = compositeReference.getPromotedReferences();
            int n = promotedReferences.size();
            for (int i = 0; i < n; ++i) {
                ComponentReference componentReference = promotedReferences.get(i);
                if (!componentReference.isUnresolved()) continue;
                String componentReferenceName = componentReference.getName();
                if ((componentReference = componentReferences.get(componentReferenceName)) != null) {
                    Component promotedComponent = compositeReference.getPromotedComponents().get(i);
                    promotedComponent = components.get(promotedComponent.getName());
                    compositeReference.getPromotedComponents().set(i, promotedComponent);
                    componentReference.setPromoted(true);
                    promotedReferences.set(i, componentReference);
                    continue;
                }
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PromotedReferenceNotFound", ((Composite)componentType).getName().toString(), componentReferenceName);
            }
        }
    }

    protected void createSCABinding(Contract contract, Definitions definitions) {
        SCABinding scaBinding = this.scaBindingFactory.createSCABinding();
        scaBinding.setName(contract.getName());
        if (definitions != null) {
            for (BindingType attachPointType : definitions.getBindingTypes()) {
                if (!attachPointType.getType().equals(BINDING_SCA_QNAME)) continue;
                ((PolicySubject)((Object)scaBinding)).setExtensionType(attachPointType);
            }
        }
        contract.getBindings().add(scaBinding);
        contract.setOverridingBindings(false);
    }

    private void calculatePromotedServiceInterfaceContract(Service topContract, Service bottomContract, Monitor monitor) {
        InterfaceContract topInterfaceContract = topContract.getInterfaceContract();
        InterfaceContract bottomInterfaceContract = bottomContract.getInterfaceContract();
        if (topInterfaceContract == null) {
            topContract.setInterfaceContract(bottomInterfaceContract);
        } else if (bottomInterfaceContract != null) {
            boolean isCompatible = true;
            String incompatibilityReason = "";
            try {
                isCompatible = this.checkSubsetCompatibility(topInterfaceContract, bottomInterfaceContract);
            }
            catch (IncompatibleInterfaceContractException ex) {
                isCompatible = false;
                incompatibilityReason = ex.getMessage();
            }
            if (!isCompatible) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "ServiceInterfaceNotSubSet", topContract.getName(), incompatibilityReason);
            }
            if (topInterfaceContract.getInterface() == null) {
                topInterfaceContract.setInterface(bottomInterfaceContract.getInterface());
            }
            if (topInterfaceContract.getCallbackInterface() == null) {
                topInterfaceContract.setCallbackInterface(bottomInterfaceContract.getCallbackInterface());
            }
        }
    }

    private void calculatePromotedReferenceInterfaceContract(Reference topContract, Reference bottomContract, Monitor monitor) {
        InterfaceContract topInterfaceContract = topContract.getInterfaceContract();
        InterfaceContract bottomInterfaceContract = bottomContract.getInterfaceContract();
        if (topInterfaceContract == null) {
            topContract.setInterfaceContract(bottomInterfaceContract);
        } else if (bottomInterfaceContract != null) {
            boolean isCompatible = true;
            String incompatibilityReason = "";
            try {
                isCompatible = this.checkSubsetCompatibility(bottomInterfaceContract, topInterfaceContract);
            }
            catch (IncompatibleInterfaceContractException ex) {
                isCompatible = false;
                incompatibilityReason = ex.getMessage();
            }
            if (!isCompatible) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "ReferenceInterfaceNotSubSet", topContract.getName(), incompatibilityReason);
            }
            if (topInterfaceContract.getInterface() == null) {
                topInterfaceContract.setInterface(bottomInterfaceContract.getInterface());
            }
            if (topInterfaceContract.getCallbackInterface() == null) {
                topInterfaceContract.setCallbackInterface(bottomInterfaceContract.getCallbackInterface());
            }
        }
    }

    private void calculatePromotedBindings(CompositeService compositeService, ComponentService promotedComponentService) {
        if (compositeService.getBindings().isEmpty()) {
            for (Binding binding : promotedComponentService.getBindings()) {
                try {
                    compositeService.getBindings().add((Binding)binding.clone());
                }
                catch (CloneNotSupportedException ex) {}
            }
        }
        if (compositeService.getBindings().isEmpty()) {
            this.createSCABinding(compositeService, null);
        }
        if (promotedComponentService.getCallback() != null) {
            if (compositeService.getCallback() != null) {
                compositeService.getCallback().getBindings().clear();
            } else {
                compositeService.setCallback(this.assemblyFactory.createCallback());
            }
            for (Binding binding : promotedComponentService.getCallback().getBindings()) {
                try {
                    compositeService.getCallback().getBindings().add((Binding)binding.clone());
                }
                catch (CloneNotSupportedException ex) {}
            }
        }
    }

    private void reconcileReferenceMultiplicity(ComponentType componentType, Reference compositeReference, Reference promotedComponentReference, Monitor monitor) {
        if (compositeReference.getMultiplicity() != null) {
            if (!this.isValidMultiplicityOverride(promotedComponentReference.getTargets().size() > 0, promotedComponentReference.getMultiplicity(), compositeReference.getMultiplicity())) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "CompositeReferenceIncompatibleMultiplicity", componentType.getURI(), compositeReference.getName(), promotedComponentReference.getName());
            }
        } else {
            compositeReference.setMultiplicity(promotedComponentReference.getMultiplicity());
        }
    }

    private boolean isValidMultiplicityOverride(boolean componentRefHasTarget, Multiplicity componentRefMul, Multiplicity compositeRefMul) {
        if (componentRefMul != null && compositeRefMul != null && componentRefMul != compositeRefMul) {
            if (componentRefHasTarget) {
                switch (componentRefMul) {
                    case ZERO_ONE: {
                        return compositeRefMul == Multiplicity.ZERO_ONE || compositeRefMul == Multiplicity.ONE_ONE;
                    }
                    case ONE_ONE: {
                        return compositeRefMul == Multiplicity.ZERO_ONE || compositeRefMul == Multiplicity.ONE_ONE;
                    }
                    case ZERO_N: {
                        return true;
                    }
                    case ONE_N: {
                        return true;
                    }
                }
                return false;
            }
            switch (componentRefMul) {
                case ZERO_ONE: {
                    return compositeRefMul == Multiplicity.ONE_ONE;
                }
                case ONE_ONE: {
                    return compositeRefMul == Multiplicity.ONE_ONE;
                }
                case ZERO_N: {
                    return true;
                }
                case ONE_N: {
                    return compositeRefMul == Multiplicity.ONE_ONE || compositeRefMul == Multiplicity.ONE_N;
                }
            }
            return false;
        }
        return true;
    }

    private void validateNonOverridable(ComponentType componentType, Reference compositeReference, Reference promotedComponentReference, Monitor monitor) {
        if (promotedComponentReference.getMultiplicity() == Multiplicity.ONE_ONE && ((ComponentReference)promotedComponentReference).isNonOverridable()) {
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "CompositeReferencePromotesNonOverridableReference", componentType.getURI(), compositeReference.getName(), promotedComponentReference.getName());
        }
    }

    private boolean checkSubsetCompatibility(InterfaceContract contractA, InterfaceContract contractB) throws IncompatibleInterfaceContractException {
        if (contractA.getClass() != contractB.getClass()) {
            if (contractA instanceof JavaInterfaceContract) {
                this.contractBuilder.build(contractA, null);
                contractA = ((JavaInterfaceContract)contractA).getNormalizedWSDLContract();
            }
            if (contractB instanceof JavaInterfaceContract) {
                this.contractBuilder.build(contractB, null);
                contractB = ((JavaInterfaceContract)contractB).getNormalizedWSDLContract();
            }
        }
        return this.interfaceContractMapper.checkCompatibility(contractA, contractB, Compatibility.SUBSET, false, false);
    }
}

