/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.xml.EndPointReferenceHelper;
import org.apache.tuscany.sca.binding.ws.xml.WebServiceConstants;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLObject;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.PolicyFactory;

public class WebServiceBindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WebServiceBinding>,
WebServiceConstants {
    private ExtensionPointRegistry extensionPoints;
    private WSDLFactory wsdlFactory;
    private WebServiceBindingFactory wsFactory;
    private PolicyFactory policyFactory;
    private PolicySubjectProcessor policyProcessor;
    private StAXHelper staxHelper;

    public WebServiceBindingProcessor(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        FactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.wsFactory = modelFactories.getFactory(WebServiceBindingFactory.class);
        this.wsdlFactory = modelFactories.getFactory(WSDLFactory.class);
        this.policyProcessor = new PolicySubjectProcessor(this.policyFactory);
        this.staxHelper = StAXHelper.getInstance(extensionPoints);
    }

    private void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "binding-wsxml-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "binding-wsxml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    @Override
    public WebServiceBinding read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String wsdliLocation;
        Monitor monitor = context.getMonitor();
        WebServiceBinding wsBinding = this.wsFactory.createWebServiceBinding();
        wsBinding.setUnresolved(true);
        this.policyProcessor.readPolicies(wsBinding, reader);
        String name = reader.getAttributeValue(null, "name");
        if (name != null) {
            wsBinding.setName(name);
        }
        ArrayList<String> endpointSpecifications = new ArrayList<String>();
        String uri = this.getURIString(reader, "uri");
        if (uri != null) {
            wsBinding.setURI(uri);
            if (context.getParentModel() instanceof Reference) {
                try {
                    URI tmpURI = new URI(uri);
                    if (!tmpURI.isAbsolute()) {
                        this.error(monitor, "URINotAbsolute", reader, uri);
                    }
                }
                catch (URISyntaxException ex) {
                    this.error(monitor, "InvalidURISyntax", reader, ex.getMessage());
                }
                endpointSpecifications.add("uri");
            }
            if (context.getParentModel() instanceof Callback && ((Callback)context.getParentModel()).getParentContract() instanceof Service) {
                this.error(monitor, "URIFoundForServiceCallback", reader, uri);
            }
        }
        Boolean wsdlElementIsBinding = null;
        String wsdlElement = this.getURIString(reader, "wsdlElement");
        if (wsdlElement != null) {
            int s;
            int index = wsdlElement.indexOf(35);
            if (index == -1) {
                this.error(monitor, "InvalidWsdlElementAttr", reader, wsdlElement);
                return wsBinding;
            }
            String namespace = wsdlElement.substring(0, index);
            wsBinding.setNamespace(namespace);
            String localName = wsdlElement.substring(index + 1);
            if (localName.startsWith("wsdl.service")) {
                if (context.getParentModel() instanceof Service) {
                    this.error(monitor, "WSDLServiceOnService", reader, wsdlElement);
                }
                localName = localName.substring("wsdl.service(".length(), localName.length() - 1);
                wsBinding.setServiceName(new QName(namespace, localName));
                endpointSpecifications.add("#wsdl.service");
            } else if (localName.startsWith("wsdl.port")) {
                s = (localName = localName.substring("wsdl.port(".length(), localName.length() - 1)).indexOf(47);
                if (s == -1) {
                    this.error(monitor, "InvalidWsdlElementAttr", reader, wsdlElement);
                } else {
                    wsBinding.setServiceName(new QName(namespace, localName.substring(0, s)));
                    wsBinding.setPortName(localName.substring(s + 1));
                }
                endpointSpecifications.add("#wsdl.port");
            } else if (localName.startsWith("wsdl.endpoint")) {
                s = (localName = localName.substring("wsdl.endpoint(".length(), localName.length() - 1)).indexOf(47);
                if (s == -1) {
                    this.error(monitor, "InvalidWsdlElementAttr", reader, wsdlElement);
                } else {
                    wsBinding.setServiceName(new QName(namespace, localName.substring(0, s)));
                    wsBinding.setEndpointName(localName.substring(s + 1));
                }
            } else if (localName.startsWith("wsdl.binding")) {
                localName = localName.substring("wsdl.binding(".length(), localName.length() - 1);
                wsBinding.setBindingName(new QName(namespace, localName));
                wsdlElementIsBinding = true;
            } else {
                this.error(monitor, "InvalidWsdlElementAttr", reader, wsdlElement);
            }
        }
        if ((wsdliLocation = reader.getAttributeValue("http://www.w3.org/ns/wsdl-instance", "wsdlLocation")) != null) {
            String[] iris;
            if (wsdlElement == null) {
                this.error(monitor, "WsdliLocationMissingWsdlElement", reader, new Object[0]);
            }
            if ((iris = wsdliLocation.split(" ")).length % 2 != 0) {
                this.error(monitor, "WsdliLocationNotIRIPairs", reader, new Object[0]);
            }
            for (int i = 0; i < iris.length - 1; i += 2) {
                wsBinding.getWsdliLocations().put(iris[i], iris[i + 1]);
            }
        }
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"EndpointReference".equals(reader.getName().getLocalPart())) break;
                    if (!(wsdlElement == null || wsdlElementIsBinding != null && wsdlElementIsBinding.booleanValue())) {
                        this.error(monitor, "MustUseWsdlBinding", reader, wsdlElement);
                        throw new ContributionReadException(wsdlElement + " must use wsdl.binding when using wsa:EndpointReference");
                    }
                    wsBinding.setEndPointReference(EndPointReferenceHelper.readEndPointReference(reader));
                    endpointSpecifications.add("wsa:EndpointReference");
                }
            }
            if (event != 2 || !BINDING_WS_QNAME.equals(reader.getName())) continue;
            break;
        }
        if (endpointSpecifications.size() > 1) {
            this.error(monitor, "MultipleEndpointsSpecified", reader, ((Object)endpointSpecifications).toString());
        }
        return wsBinding;
    }

    protected void processEndPointReference(XMLStreamReader reader, WebServiceBinding wsBinding) {
    }

    @Override
    public void write(WebServiceBinding wsBinding, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        String wsdlElement;
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.ws");
        this.policyProcessor.writePolicyAttributes(wsBinding, writer);
        if (wsBinding.getName() != null) {
            writer.writeAttribute("name", wsBinding.getName());
        }
        if (wsBinding.getURI() != null) {
            writer.writeAttribute("uri", wsBinding.getURI());
        }
        if (wsBinding.getPortName() != null) {
            wsdlElement = wsBinding.getServiceName().getNamespaceURI() + "#wsdl.port(" + wsBinding.getServiceName().getLocalPart() + "/" + wsBinding.getPortName() + ")";
            writer.writeAttribute("wsdlElement", wsdlElement);
        } else if (wsBinding.getEndpointName() != null) {
            wsdlElement = wsBinding.getServiceName().getNamespaceURI() + "#wsdl.endpoint(" + wsBinding.getServiceName().getLocalPart() + "/" + wsBinding.getEndpointName() + ")";
            writer.writeAttribute("wsdlElement", wsdlElement);
        } else if (wsBinding.getBindingName() != null) {
            wsdlElement = wsBinding.getBindingName().getNamespaceURI() + "#wsdl.binding(" + wsBinding.getBindingName().getLocalPart() + ")";
            writer.writeAttribute("wsdlElement", wsdlElement);
        } else if (wsBinding.getServiceName() != null) {
            wsdlElement = wsBinding.getServiceName().getNamespaceURI() + "#wsdl.service(" + wsBinding.getServiceName().getLocalPart() + ")";
            writer.writeAttribute("wsdlElement", wsdlElement);
        }
        if (wsBinding.getWsdliLocations().size() > 0) {
            StringBuilder wsdliLocation = new StringBuilder();
            Map<String, String> wl = wsBinding.getWsdliLocations();
            for (String ns : wl.keySet()) {
                if (wsdliLocation.length() > 0) {
                    wsdliLocation.append(' ');
                }
                wsdliLocation.append(ns);
                wsdliLocation.append(' ');
                wsdliLocation.append(wl.get(ns));
            }
            writer.writeAttribute("http://www.w3.org/ns/wsdl-instance", "wsdlLocation", wsdliLocation.toString());
        }
        if (wsBinding.getEndPointReference() != null) {
            EndPointReferenceHelper.writeEndPointReference(wsBinding.getEndPointReference(), writer, this.staxHelper);
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(WebServiceBinding model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (model == null || !model.isUnresolved()) {
            return;
        }
        Monitor monitor = context.getMonitor();
        WSDLDefinition wsdlDefinition = this.wsdlFactory.createWSDLDefinition();
        wsdlDefinition.setUnresolved(true);
        wsdlDefinition.setNamespace(model.getNamespace());
        wsdlDefinition.setNameOfBindingToResolve(model.getBindingName());
        wsdlDefinition.setNameOfServiceToResolve(model.getServiceName());
        wsdlDefinition.getWsdliLocations().putAll(model.getWsdliLocations());
        WSDLDefinition resolved = resolver.resolveModel(WSDLDefinition.class, wsdlDefinition, context);
        if (!resolved.isUnresolved()) {
            PortType portType;
            wsdlDefinition.setDefinition(resolved.getDefinition());
            wsdlDefinition.setLocation(resolved.getLocation());
            wsdlDefinition.setURI(resolved.getURI());
            wsdlDefinition.getImportedDefinitions().addAll(resolved.getImportedDefinitions());
            wsdlDefinition.getXmlSchemas().addAll(resolved.getXmlSchemas());
            wsdlDefinition.setUnresolved(false);
            model.setUserSpecifiedWSDLDefinition(wsdlDefinition);
            if (model.getBindingName() != null) {
                WSDLObject<Binding> binding = wsdlDefinition.getWSDLObject(Binding.class, model.getBindingName());
                if (binding != null) {
                    wsdlDefinition.setDefinition(binding.getDefinition());
                    model.setBinding(binding.getElement());
                } else {
                    this.error(monitor, "WsdlBindingDoesNotMatch", wsdlDefinition, model.getBindingName());
                }
            }
            if (model.getServiceName() != null) {
                WSDLObject<javax.wsdl.Service> service = wsdlDefinition.getWSDLObject(javax.wsdl.Service.class, model.getServiceName());
                if (service != null) {
                    wsdlDefinition.setDefinition(service.getDefinition());
                    model.setService(service.getElement());
                    Port port = null;
                    port = model.getPortName() != null ? service.getElement().getPort(model.getPortName()) : (Port)service.getElement().getPorts().values().iterator().next();
                    if (port != null) {
                        model.setPort(port);
                        model.setBinding(port.getBinding());
                        if (model.getURI() == null) {
                            model.setURI(WebServiceBindingProcessor.getPortAddress(port));
                        }
                    } else {
                        this.error(monitor, "WsdlPortTypeDoesNotMatch", wsdlDefinition, model.getPortName());
                    }
                } else {
                    this.error(monitor, "WsdlServiceDoesNotMatch", wsdlDefinition, model.getServiceName());
                }
            }
            if ((portType = this.getPortType(model)) != null) {
                WSDLInterfaceContract interfaceContract = this.wsdlFactory.createWSDLInterfaceContract();
                WSDLInterface wsdlInterface = null;
                try {
                    wsdlInterface = this.wsdlFactory.createWSDLInterface(portType, wsdlDefinition, resolver, context.getMonitor());
                }
                catch (InvalidInterfaceException e) {
                    this.warning(monitor, "InvalidInterfaceException", this.wsdlFactory, model.getName(), e.getMessage());
                }
                interfaceContract.setInterface(wsdlInterface);
                interfaceContract.setCallbackInterface(wsdlInterface.getCallbackInterface());
                model.setBindingInterfaceContract(interfaceContract);
            }
            this.validateWSDL(context, model);
        } else {
            if (model.getBindingName() != null) {
                this.error(monitor, "WsdlBindingDoesNotMatch", model, model.getBindingName());
            }
            if (model.getServiceName() != null) {
                this.error(monitor, "WsdlServiceDoesNotMatch", model, model.getServiceName());
            }
        }
        this.policyProcessor.resolvePolicies(model, resolver, context);
    }

    private void validateWSDL(ProcessorContext context, WebServiceBinding model) {
        Binding binding;
        WSDLDefinition wsdlDefinition = model.getUserSpecifiedWSDLDefinition();
        Port port = model.getPort();
        if (port != null) {
            this.validateWSDLPort(context, model, port);
        }
        if ((binding = model.getBinding()) != null) {
            this.validateWSDLBinding(context, model, binding);
        }
    }

    private void validateWSDLPort(ProcessorContext context, WebServiceBinding model, Port port) {
        this.validateWSDLBinding(context, model, port.getBinding());
    }

    private void validateWSDLBinding(ProcessorContext context, WebServiceBinding model, Binding binding) {
        if (!model.isHTTPTransport() && !model.isJMSTransport()) {
            this.error(context.getMonitor(), "InvalidWSDLBindingTransport", model, model.getBindingTransport());
        }
    }

    private PortType getPortType(WebServiceBinding model) {
        Map ports;
        PortType portType = null;
        if (model.getPort() != null) {
            portType = model.getPort().getBinding().getPortType();
        } else if (model.getEndpoint() != null) {
            portType = model.getPort().getBinding().getPortType();
        } else if (model.getBinding() != null) {
            portType = model.getBinding().getPortType();
        } else if (model.getService() != null && !(ports = model.getService().getPorts()).isEmpty()) {
            Port port = (Port)ports.values().iterator().next();
            portType = port.getBinding().getPortType();
        }
        return portType;
    }

    public static String getPortAddress(Port port) {
        Object ext = port.getExtensibilityElements().get(0);
        if (ext instanceof SOAPAddress) {
            return ((SOAPAddress)ext).getLocationURI();
        }
        if (ext instanceof SOAP12Address) {
            return ((SOAP12Address)ext).getLocationURI();
        }
        return null;
    }

    @Override
    public QName getArtifactType() {
        return WebServiceConstants.BINDING_WS_QNAME;
    }

    @Override
    public Class<WebServiceBinding> getModelType() {
        return WebServiceBinding.class;
    }
}

