/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.wsdlgen;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.binding.ws.wsdlgen.WSDLDefinitionGenerator;
import org.apache.tuscany.sca.binding.ws.wsdlgen.WSDLGenerationException;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSDLServiceGenerator {
    public static boolean printWSDL;
    private static final Logger logger;
    private static final QName TRANSPORT_JMS_QUALIFIED_INTENT;
    private static final String DEFAULT_QUEUE_CONNECTION_FACTORY = "TuscanyQueueConnectionFactory";
    private static final String ADDRESS = "Address";

    private WSDLServiceGenerator() {
    }

    private static void logWarning(Problem problem) {
        Logger problemLogger = Logger.getLogger(problem.getSourceClassName(), problem.getResourceBundleName());
        if (problemLogger != null) {
            problemLogger.logp(Level.WARNING, problem.getSourceClassName(), (String)null, problem.getMessageId(), problem.getMessageParams());
        } else {
            logger.severe("Can't get logger " + problem.getSourceClassName() + " with bundle " + problem.getResourceBundleName());
        }
    }

    private static void warning(Monitor monitor, String message, WebServiceBinding wsBinding, String ... messageParameters) {
        Problem problem = monitor.createProblem(WSDLServiceGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.WARNING, (Object)wsBinding, message, messageParameters);
        if (monitor != null) {
            monitor.problem(problem);
        } else {
            WSDLServiceGenerator.logWarning(problem);
        }
    }

    private static void error(Monitor monitor, String message, WebServiceBinding wsBinding, String ... messageParameters) {
        Problem problem = monitor.createProblem(WSDLServiceGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.ERROR, (Object)wsBinding, message, messageParameters);
        if (monitor == null) {
            throw new WSDLGenerationException(problem.toString(), null, problem);
        }
        monitor.problem(problem);
    }

    protected static Definition configureWSDLDefinition(WebServiceBinding wsBinding, Component component, AbstractContract contract, Monitor monitor) {
        assert (!(contract instanceof CompositeService));
        String contractName = contract.getName();
        ArrayList<Port> ports = new ArrayList<Port>();
        WSDLDefinition wsdlDefinition = wsBinding.getUserSpecifiedWSDLDefinition();
        if (wsdlDefinition == null) {
            WSDLServiceGenerator.error(monitor, "NoWsdlInterface", wsBinding, component.getName(), contract.getName());
            return null;
        }
        Definition def = wsdlDefinition.getDefinition();
        if (wsdlDefinition.getBinding() == null) {
            Binding binding;
            PortType portType;
            boolean ok;
            WSDLFactory factory = null;
            try {
                factory = WSDLFactory.newInstance();
            }
            catch (WSDLException e) {
                throw new WSDLGenerationException(e);
            }
            Definition newDef = factory.newDefinition();
            String nsName = component.getName() + "/" + contractName;
            String namespaceURI = null;
            try {
                URI userTNS = new URI(def.getTargetNamespace());
                namespaceURI = userTNS.resolve("/" + nsName).toString();
            }
            catch (URISyntaxException e1) {
                throw new WSDLGenerationException(e1);
            }
            catch (IllegalArgumentException e2) {
                throw new WSDLGenerationException(e2);
            }
            String defsName = component.getName() + "." + contractName;
            newDef.setQName(new QName(namespaceURI, defsName));
            newDef.setTargetNamespace(namespaceURI);
            newDef.addNamespace("tns", namespaceURI);
            newDef.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
            ArrayList<WSDLDefinition> imports = new ArrayList<WSDLDefinition>();
            Interface interfaze = wsBinding.getBindingInterfaceContract().getInterface();
            if (interfaze instanceof WSDLInterface && !(ok = WSDLServiceGenerator.importPortType(portType = ((WSDLInterface)interfaze).getPortType(), wsdlDefinition, newDef, imports))) {
                WSDLServiceGenerator.error(monitor, "PortTypeNotFound", wsBinding, portType.getQName().toString(), component.getName(), contract.getName());
            }
            if ((binding = wsBinding.getBinding()) != null) {
                ok = WSDLServiceGenerator.importBinding(binding, wsdlDefinition, newDef, imports);
                if (ok) {
                    boolean ok2 = WSDLServiceGenerator.importPortType(binding.getPortType(), wsdlDefinition, newDef, imports);
                    if (!ok2) {
                        WSDLServiceGenerator.error(monitor, "PortTypeNotFound", wsBinding, binding.getPortType().getQName().toString(), component.getName(), contract.getName());
                    }
                } else {
                    WSDLServiceGenerator.error(monitor, "BindingNotFound", wsBinding, binding.getQName().toString(), component.getName(), contract.getName());
                }
            }
            QName serviceQName = wsBinding.getServiceName();
            String portName = wsBinding.getPortName();
            if (serviceQName != null) {
                Service service = def.getService(serviceQName);
                if (portName != null) {
                    Port port = service.getPort(portName);
                    Port newPort = WSDLServiceGenerator.copyPort(newDef, port, wsBinding);
                    if (newPort != null) {
                        WSDLServiceGenerator.importBinding(port.getBinding(), wsdlDefinition, newDef, imports);
                        ports.add(newPort);
                    } else {
                        WSDLServiceGenerator.error(monitor, "InvalidPort", wsBinding, serviceQName.toString(), portName, component.getName(), contract.getName());
                    }
                } else {
                    for (Object port : service.getPorts().values()) {
                        Port newPort = WSDLServiceGenerator.copyPort(newDef, (Port)port, wsBinding);
                        if (newPort != null) {
                            WSDLServiceGenerator.importBinding(((Port)port).getBinding(), wsdlDefinition, newDef, imports);
                            ports.add(newPort);
                            continue;
                        }
                        WSDLServiceGenerator.warning(monitor, "IgnoringPort", wsBinding, serviceQName.toString(), ((Port)port).getName(), component.getName(), contract.getName());
                    }
                    if (ports.size() == 0) {
                        WSDLServiceGenerator.error(monitor, "NoValidPorts", wsBinding, serviceQName.toString(), component.getName(), contract.getName());
                    }
                }
            }
            def = newDef;
        }
        WSDLDefinitionGenerator helper = new WSDLDefinitionGenerator(wsBinding);
        WSDLInterface wi = (WSDLInterface)wsBinding.getBindingInterfaceContract().getInterface();
        PortType portType = wi.getPortType();
        Service service = helper.createService(def, portType, contract.getName());
        if (wsBinding.getBinding() == null && ports.size() == 0) {
            Message firstMessage;
            Part firstPart;
            Binding binding = helper.createBinding(def, portType);
            if (BindingWSDLGenerator.requiresSOAP12(wsBinding)) {
                def.addNamespace("SOAP12", "http://schemas.xmlsoap.org/wsdl/soap12/");
            } else {
                def.addNamespace("SOAP11", "http://schemas.xmlsoap.org/wsdl/soap/");
            }
            helper.createBindingOperations(def, binding, portType);
            binding.setUndefined(false);
            if (wsdlDefinition != null && wsdlDefinition.getDefinition() != null && (firstPart = (Part)(firstMessage = (Message)wsdlDefinition.getDefinition().getMessages().values().iterator().next()).getParts().values().iterator().next()).getTypeName() != null) {
                for (Object ext : binding.getExtensibilityElements()) {
                    if (!(ext instanceof SOAPBinding)) continue;
                    ((SOAPBinding)ext).setStyle("rpc");
                    break;
                }
            }
            def.addBinding(binding);
            String endpointURI = WSDLServiceGenerator.computeActualURI(wsBinding, null);
            Port port = helper.createPort(def, binding, service, endpointURI);
            wsBinding.setService(service);
            wsBinding.setPort(port);
        } else {
            if (ports.size() > 0) {
                for (Port port : ports) {
                    service.addPort(port);
                }
                if (ports.size() == 1) {
                    wsBinding.setPort((Port)ports.get(0));
                } else {
                    wsBinding.setPort(null);
                }
            } else {
                Port port;
                String endpointURI = WSDLServiceGenerator.computeActualURI(wsBinding, null);
                port = helper.createPort(def, wsBinding.getBinding(), service, endpointURI);
                if (BindingWSDLGenerator.requiresSOAP12(wsBinding)) {
                    def.addNamespace("SOAP12", "http://schemas.xmlsoap.org/wsdl/soap12/");
                } else {
                    def.addNamespace("SOAP11", "http://schemas.xmlsoap.org/wsdl/soap/");
                }
                wsBinding.setPort(port);
            }
            wsBinding.setService(service);
        }
        if (printWSDL) {
            try {
                System.out.println("Generated WSDL for " + component.getName() + "/" + contractName);
                WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
                writer.writeWSDL(def, System.out);
            }
            catch (WSDLException e) {
                throw new WSDLGenerationException(e);
            }
        }
        return def;
    }

    private static boolean importPortType(PortType portType, WSDLDefinition wsdlDef, Definition newDef, List<WSDLDefinition> imports) {
        return WSDLServiceGenerator.addImport(portType.getQName(), PortType.class, wsdlDef, newDef, imports);
    }

    private static boolean importBinding(Binding binding, WSDLDefinition wsdlDef, Definition newDef, List<WSDLDefinition> imports) {
        boolean ok = WSDLServiceGenerator.addImport(binding.getQName(), Binding.class, wsdlDef, newDef, imports);
        if (ok) {
            List bindingExtensions = binding.getExtensibilityElements();
            for (Object extension : bindingExtensions) {
                if (extension instanceof SOAPBinding) {
                    newDef.addNamespace("SOAP11", "http://schemas.xmlsoap.org/wsdl/soap/");
                }
                if (!(extension instanceof SOAP12Binding)) continue;
                newDef.addNamespace("SOAP12", "http://schemas.xmlsoap.org/wsdl/soap12/");
            }
        }
        return ok;
    }

    private static boolean addImport(QName name, Class type, WSDLDefinition wsdlDef, Definition newDef, List<WSDLDefinition> imports) {
        String namespace = name.getNamespaceURI();
        if (newDef.getImports(namespace) == null) {
            WSDLDefinition impDef = WSDLServiceGenerator.findDefinition(wsdlDef, name, type);
            if (impDef != null) {
                Import imp = newDef.createImport();
                imp.setNamespaceURI(namespace);
                imp.setLocationURI(impDef.getURI().toString());
                imp.setDefinition(impDef.getDefinition());
                newDef.addNamespace("ns" + imports.size(), namespace);
                newDef.addImport(imp);
                imports.add(impDef);
                return true;
            }
            return false;
        }
        return true;
    }

    private static WSDLDefinition findDefinition(WSDLDefinition wsdlDef, QName name, Class type) {
        if (wsdlDef == null || name == null) {
            return wsdlDef;
        }
        if (wsdlDef.getURI() != null) {
            Map types;
            Definition def = wsdlDef.getDefinition();
            Map map = types = type == PortType.class ? def.getPortTypes() : def.getBindings();
            if (types.get(name) != null) {
                return wsdlDef;
            }
        }
        for (WSDLDefinition impDef : wsdlDef.getImportedDefinitions()) {
            WSDLDefinition d = WSDLServiceGenerator.findDefinition(impDef, name, type);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    private static Port copyPort(Definition def, Port port, WebServiceBinding wsBinding) {
        Port newPort = def.createPort();
        newPort.setName(port.getName());
        newPort.setBinding(port.getBinding());
        List portExtensions = port.getExtensibilityElements();
        for (Object extension : portExtensions) {
            String uri;
            ExtensibilityElement newExt = null;
            if (extension instanceof SOAPAddress) {
                def.addNamespace("SOAP11", "http://schemas.xmlsoap.org/wsdl/soap/");
                try {
                    newExt = def.getExtensionRegistry().createExtension(Port.class, WSDLDefinitionGenerator.SOAP_ADDRESS);
                }
                catch (WSDLException e) {
                    // empty catch block
                }
                uri = WSDLServiceGenerator.computeActualURI(wsBinding, port);
                ((SOAPAddress)newExt).setLocationURI(uri);
                newPort.addExtensibilityElement(newExt);
                continue;
            }
            if (extension instanceof SOAP12Address) {
                def.addNamespace("SOAP12", "http://schemas.xmlsoap.org/wsdl/soap12/");
                try {
                    newExt = def.getExtensionRegistry().createExtension(Port.class, WSDLDefinitionGenerator.SOAP12_ADDRESS);
                }
                catch (WSDLException e) {
                    // empty catch block
                }
                uri = WSDLServiceGenerator.computeActualURI(wsBinding, port);
                ((SOAP12Address)newExt).setLocationURI(uri);
                newPort.addExtensibilityElement(newExt);
                continue;
            }
            return null;
        }
        return newPort;
    }

    private static String computeActualURI(WebServiceBinding wsBinding, Port port) {
        URI eprURI = null;
        if (wsBinding.getEndPointReference() != null) {
            eprURI = WSDLServiceGenerator.getEPR(wsBinding);
        }
        URI wsdlURI = null;
        if (wsBinding.getServiceName() != null && wsBinding.getBindingName() == null) {
            wsdlURI = WSDLServiceGenerator.getEndpoint(port);
        }
        if (wsdlURI != null && wsdlURI.isAbsolute()) {
            return wsdlURI.toString();
        }
        if (eprURI != null && eprURI.isAbsolute()) {
            return eprURI.toString();
        }
        String actualURI = wsBinding.getURI();
        if (eprURI != null && eprURI.toString().length() != 0) {
            actualURI = actualURI + "/" + eprURI;
        }
        if (wsdlURI != null && wsdlURI.toString().length() != 0) {
            actualURI = actualURI + "/" + wsdlURI;
        }
        if (actualURI != null) {
            actualURI = URI.create(actualURI).normalize().toString();
        }
        return actualURI;
    }

    private static URI getEPR(WebServiceBinding wsBinding) {
        NodeList nodeList = wsBinding.getEndPointReference().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (!(childNode instanceof Element) || !ADDRESS.equals(childNode.getLocalName())) continue;
            NodeList addrNodes = childNode.getChildNodes();
            for (int j = 0; j < addrNodes.getLength(); ++j) {
                Node addrNode = addrNodes.item(j);
                if (!(addrNode instanceof Text)) continue;
                return URI.create(((Text)addrNode).getWholeText());
            }
        }
        return null;
    }

    private static URI getEndpoint(Port wsdlPort) {
        if (wsdlPort != null) {
            List wsdlPortExtensions = wsdlPort.getExtensibilityElements();
            for (Object extension : wsdlPortExtensions) {
                if (extension instanceof SOAPAddress) {
                    String uri = ((SOAPAddress)extension).getLocationURI();
                    return uri == null || "".equals(uri) ? null : URI.create(uri);
                }
                if (!(extension instanceof SOAP12Address)) continue;
                SOAP12Address address = (SOAP12Address)extension;
                String uri = address.getLocationURI();
                return uri == null || "".equals(uri) ? null : URI.create(uri);
            }
        }
        return null;
    }

    static {
        logger = Logger.getLogger(WSDLServiceGenerator.class.getName());
        TRANSPORT_JMS_QUALIFIED_INTENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "transport.jms");
    }
}

