/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.wsdlgen;

import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.binding.ws.wsdlgen.WSDLGenerationException;
import org.w3c.dom.Element;

public class WSDLDefinitionGenerator {
    private static final String SOAP_NS = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final QName SOAP_ADDRESS = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address");
    private static final QName SOAP_BINDING = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "binding");
    private static final QName SOAP_BODY = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "body");
    private static final QName SOAP_FAULT = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "fault");
    private static final QName SOAP_OPERATION = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "operation");
    private static final String SOAP12_NS = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final QName SOAP12_ADDRESS = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "address");
    private static final QName SOAP12_BINDING = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "binding");
    private static final QName SOAP12_BODY = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "body");
    private static final QName SOAP12_FAULT = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "fault");
    private static final QName SOAP12_OPERATION = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "operation");
    private static final String BINDING_SUFFIX = "Binding";
    private static final String SERVICE_SUFFIX = "Service";
    private static final String PORT_SUFFIX = "Port";
    private boolean requiresSOAP12;
    private QName soapAddress;
    private QName soapBinding;
    private QName soapBody;
    private QName soapFault;
    private QName soapOperation;
    private String wsBindingName;

    public WSDLDefinitionGenerator(WebServiceBinding wsBinding) {
        this(BindingWSDLGenerator.requiresSOAP12(wsBinding));
        this.wsBindingName = wsBinding.getName();
    }

    public WSDLDefinitionGenerator(boolean isSOAP12) {
        this.requiresSOAP12 = isSOAP12;
        this.soapAddress = this.requiresSOAP12 ? SOAP12_ADDRESS : SOAP_ADDRESS;
        this.soapBinding = this.requiresSOAP12 ? SOAP12_BINDING : SOAP_BINDING;
        this.soapBody = this.requiresSOAP12 ? SOAP12_BODY : SOAP_BODY;
        this.soapFault = this.requiresSOAP12 ? SOAP12_FAULT : SOAP_FAULT;
        this.soapOperation = this.requiresSOAP12 ? SOAP12_OPERATION : SOAP_OPERATION;
    }

    public Definition cloneDefinition(WSDLFactory factory, Definition definition) throws WSDLException {
        Element root = definition.getDocumentationElement();
        root = (Element)root.cloneNode(true);
        WSDLReader reader = factory.newWSDLReader();
        return reader.readWSDL(definition.getDocumentBaseURI(), root);
    }

    public Types createTypes(Definition definition) {
        Types types = definition.createTypes();
        definition.setTypes(types);
        return types;
    }

    public Binding createBinding(Definition definition, PortType portType) {
        try {
            Binding binding = definition.createBinding();
            binding.setPortType(portType);
            this.configureBinding(definition, binding, portType);
            ExtensibilityElement bindingExtension = definition.getExtensionRegistry().createExtension(Binding.class, this.soapBinding);
            if (this.requiresSOAP12) {
                ((SOAP12Binding)bindingExtension).setStyle("document");
                ((SOAP12Binding)bindingExtension).setTransportURI("http://schemas.xmlsoap.org/soap/http");
            } else {
                ((SOAPBinding)bindingExtension).setStyle("document");
                ((SOAPBinding)bindingExtension).setTransportURI("http://schemas.xmlsoap.org/soap/http");
            }
            binding.addExtensibilityElement(bindingExtension);
            return binding;
        }
        catch (WSDLException e) {
            throw new WSDLGenerationException(e);
        }
    }

    protected void configureBinding(Definition definition, Binding binding, PortType portType) throws WSDLException {
        QName name;
        if (this.wsBindingName != null && definition.getBinding(name = new QName(definition.getTargetNamespace(), this.wsBindingName + this.getSOAPVersionString() + BINDING_SUFFIX)) == null) {
            binding.setQName(name);
            return;
        }
        QName portTypeName = portType.getQName();
        if (portTypeName != null) {
            String suffix = BINDING_SUFFIX;
            while (true) {
                QName name2;
                if (definition.getBinding(name2 = new QName(definition.getTargetNamespace(), portTypeName.getLocalPart() + suffix)) == null) {
                    binding.setQName(name2);
                    break;
                }
                suffix = "_" + suffix;
            }
        }
    }

    public void createBindingOperations(Definition definition, Binding binding, PortType portType) {
        try {
            for (Operation operation : portType.getOperations()) {
                BindingOperation bindingOperation = this.createBindingOperation(definition, operation, "urn:" + operation.getName());
                binding.addBindingOperation(bindingOperation);
            }
        }
        catch (WSDLException e) {
            throw new WSDLGenerationException(e);
        }
    }

    public BindingOperation createBindingOperation(Definition definition, Operation operation, String action) throws WSDLException {
        BindingOperation bindingOperation = definition.createBindingOperation();
        bindingOperation.setOperation(operation);
        this.configureBindingOperation(bindingOperation, operation);
        ExtensibilityElement operationExtension = definition.getExtensionRegistry().createExtension(BindingOperation.class, this.soapOperation);
        if (this.requiresSOAP12) {
            ((SOAP12Operation)operationExtension).setSoapActionURI(action);
        } else {
            ((SOAPOperation)operationExtension).setSoapActionURI(action);
        }
        bindingOperation.addExtensibilityElement(operationExtension);
        if (operation.getInput() != null) {
            BindingInput bindingInput = definition.createBindingInput();
            this.configureBindingInput(bindingInput, operation.getInput());
            ExtensibilityElement inputExtension = definition.getExtensionRegistry().createExtension(BindingInput.class, this.soapBody);
            if (this.requiresSOAP12) {
                ((SOAP12Body)inputExtension).setUse("literal");
            } else {
                ((SOAPBody)inputExtension).setUse("literal");
            }
            bindingInput.addExtensibilityElement(inputExtension);
            bindingOperation.setBindingInput(bindingInput);
        }
        if (operation.getOutput() != null) {
            BindingOutput bindingOutput = definition.createBindingOutput();
            this.configureBindingOutput(bindingOutput, operation.getOutput());
            ExtensibilityElement outputExtension = definition.getExtensionRegistry().createExtension(BindingOutput.class, this.soapBody);
            if (this.requiresSOAP12) {
                ((SOAP12Body)outputExtension).setUse("literal");
            } else {
                ((SOAPBody)outputExtension).setUse("literal");
            }
            bindingOutput.addExtensibilityElement(outputExtension);
            bindingOperation.setBindingOutput(bindingOutput);
        }
        for (Fault fault : operation.getFaults().values()) {
            BindingFault bindingFault = definition.createBindingFault();
            ExtensibilityElement faultExtension = definition.getExtensionRegistry().createExtension(BindingFault.class, this.soapFault);
            this.configureBindingFault(bindingFault, faultExtension, fault);
            bindingFault.addExtensibilityElement(faultExtension);
            bindingOperation.addBindingFault(bindingFault);
        }
        return bindingOperation;
    }

    protected void configureBindingOperation(BindingOperation bindingOperation, Operation operation) throws WSDLException {
        bindingOperation.setName(operation.getName());
    }

    protected void configureBindingInput(BindingInput bindingInput, Input input) throws WSDLException {
        bindingInput.setName(input.getName());
    }

    protected void configureBindingOutput(BindingOutput bindingOutput, Output output) throws WSDLException {
        bindingOutput.setName(output.getName());
    }

    protected void configureBindingFault(BindingFault bindingFault, ExtensibilityElement faultExtension, Fault fault) throws WSDLException {
        String faultName = fault.getName();
        bindingFault.setName(faultName);
        if (this.requiresSOAP12) {
            ((SOAP12Fault)faultExtension).setName(faultName);
            ((SOAP12Fault)faultExtension).setUse("literal");
        } else {
            ((SOAPFault)faultExtension).setName(faultName);
            ((SOAPFault)faultExtension).setUse("literal");
        }
    }

    public Service createService(Definition definition, PortType portType, String serviceName) {
        try {
            Service service = definition.createService();
            this.configureService(definition, service, portType, serviceName);
            definition.addService(service);
            return service;
        }
        catch (WSDLException e) {
            throw new WSDLGenerationException(e);
        }
    }

    public Service createService(Definition definition, Binding binding, String serviceName) {
        try {
            Service service = definition.createService();
            this.configureService(definition, service, binding.getPortType(), serviceName);
            definition.addService(service);
            return service;
        }
        catch (WSDLException e) {
            throw new WSDLGenerationException(e);
        }
    }

    protected void configureService(Definition definition, Service service, PortType portType, String serviceName) throws WSDLException {
        QName name;
        if (serviceName != null && definition.getService(name = new QName(definition.getTargetNamespace(), serviceName)) == null) {
            service.setQName(name);
            return;
        }
        QName portTypeName = portType.getQName();
        if (portTypeName != null) {
            String suffix = SERVICE_SUFFIX;
            while (true) {
                QName name2;
                if (definition.getService(name2 = new QName(definition.getTargetNamespace(), portTypeName.getLocalPart() + suffix)) == null) {
                    service.setQName(name2);
                    break;
                }
                suffix = "_" + suffix;
            }
        }
    }

    public Port createPort(Definition definition, Binding binding, Service service, String uri) {
        try {
            Port port = definition.createPort();
            port.setBinding(binding);
            this.configurePort(port, binding);
            if (uri != null) {
                ExtensibilityElement portExtension = definition.getExtensionRegistry().createExtension(Port.class, this.soapAddress);
                if (this.requiresSOAP12) {
                    ((SOAP12Address)portExtension).setLocationURI(uri);
                } else {
                    ((SOAPAddress)portExtension).setLocationURI(uri);
                }
                port.addExtensibilityElement(portExtension);
            }
            service.addPort(port);
            return port;
        }
        catch (WSDLException e) {
            throw new WSDLGenerationException(e);
        }
    }

    protected void configurePort(Port port, Binding binding) throws WSDLException {
        if (this.wsBindingName != null) {
            port.setName(this.wsBindingName + this.getSOAPVersionString() + PORT_SUFFIX);
        } else if (binding.getPortType() != null && binding.getPortType().getQName() != null) {
            port.setName(binding.getPortType().getQName().getLocalPart() + PORT_SUFFIX);
        }
    }

    private String getSOAPVersionString() {
        if (this.requiresSOAP12) {
            return "SOAP12";
        }
        return "SOAP11";
    }
}

