/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.wsdlgen;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.ContractBuilder;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.xsd.XSDFactory;

public class WSDLContractBuilder
implements ContractBuilder {
    private ExtensionPointRegistry extensionPoints;
    private FactoryExtensionPoint modelFactories;
    private DataBindingExtensionPoint dataBindings;
    private WSDLFactory wsdlFactory;
    private XSDFactory xsdFactory;
    private DocumentBuilderFactory documentBuilderFactory;

    public WSDLContractBuilder(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        this.modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.dataBindings = extensionPoints.getExtensionPoint(DataBindingExtensionPoint.class);
        this.wsdlFactory = this.modelFactories.getFactory(WSDLFactory.class);
        this.xsdFactory = this.modelFactories.getFactory(XSDFactory.class);
        this.documentBuilderFactory = this.modelFactories.getFactory(DocumentBuilderFactory.class);
    }

    @Override
    public boolean build(InterfaceContract interfaceContract, BuilderContext context) {
        JavaInterfaceContract javaContract = (JavaInterfaceContract)interfaceContract;
        WSDLInterfaceContract wsdlContract = BindingWSDLGenerator.createWSDLInterfaceContract(javaContract, false, null, this.dataBindings, this.wsdlFactory, this.xsdFactory, this.documentBuilderFactory, null);
        javaContract.setNormailizedWSDLContract(wsdlContract);
        return true;
    }
}

