/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.wsdlgen;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.wsdlgen.Interface2WSDLGenerator;
import org.apache.tuscany.sca.binding.ws.wsdlgen.WSDLGenerationException;
import org.apache.tuscany.sca.binding.ws.wsdlgen.WSDLServiceGenerator;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ResolverExtension;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.xsd.XSDFactory;

public class BindingWSDLGenerator {
    private static final Logger logger = Logger.getLogger(BindingWSDLGenerator.class.getName());
    private static final QName SOAP12_INTENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "SOAP.v1_2");
    public static boolean printWSDL;

    private BindingWSDLGenerator() {
    }

    private static void logWarning(Problem problem) {
        Logger problemLogger = Logger.getLogger(problem.getSourceClassName(), problem.getResourceBundleName());
        if (problemLogger != null) {
            problemLogger.logp(Level.WARNING, problem.getSourceClassName(), (String)null, problem.getMessageId(), problem.getMessageParams());
        } else {
            logger.severe("Can't get logger " + problem.getSourceClassName() + " with bundle " + problem.getResourceBundleName());
        }
    }

    private static void warning(Monitor monitor, String message, WebServiceBinding wsBinding, String ... messageParameters) {
        Problem problem = monitor.createProblem(BindingWSDLGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.WARNING, (Object)wsBinding, message, messageParameters);
        if (monitor != null) {
            monitor.problem(problem);
        } else {
            BindingWSDLGenerator.logWarning(problem);
        }
    }

    private static void error(Monitor monitor, String message, WebServiceBinding wsBinding, String ... messageParameters) {
        Problem problem = monitor.createProblem(BindingWSDLGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.ERROR, (Object)wsBinding, message, messageParameters);
        if (monitor == null) {
            throw new WSDLGenerationException(problem.toString(), null, problem);
        }
        monitor.problem(problem);
    }

    private static void error(Monitor monitor, String message, WebServiceBinding wsBinding, Exception ex) {
        Problem problem = monitor.createProblem(BindingWSDLGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.ERROR, (Object)wsBinding, message, ex);
        if (monitor == null) {
            throw new WSDLGenerationException(problem.toString(), ex, problem);
        }
        monitor.problem(problem);
    }

    private static void fatal(Monitor monitor, String message, WebServiceBinding wsBinding, String ... messageParameters) {
        Problem problem = monitor.createProblem(BindingWSDLGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.ERROR, (Object)wsBinding, message, messageParameters);
        throw new WSDLGenerationException(problem.toString(), null, problem);
    }

    private static void fatal(Monitor monitor, String message, WebServiceBinding wsBinding, Exception ex) {
        Problem problem = monitor.createProblem(BindingWSDLGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.ERROR, (Object)wsBinding, message, ex);
        throw new WSDLGenerationException(problem.toString(), ex, problem);
    }

    public static void generateWSDL(Component component, Contract contract, WebServiceBinding wsBinding, ExtensionPointRegistry extensionPoints, Monitor monitor) {
        if (monitor == null) {
            monitor = new BuilderContext(extensionPoints).getMonitor();
        }
        try {
            BindingWSDLGenerator.createWSDLDocument(component, contract, wsBinding, extensionPoints, monitor);
        }
        catch (WSDLGenerationException ex) {
            if (ex.getProblem() != null) {
                BindingWSDLGenerator.warning(monitor, "WsdlGenProblem", wsBinding, component.getName(), contract.getName());
                if (monitor != null) {
                    monitor.problem(ex.getProblem());
                }
                throw ex;
            }
            if (ex.getCause() instanceof Exception) {
                BindingWSDLGenerator.warning(monitor, "WsdlGenException", wsBinding, component.getName(), contract.getName());
                BindingWSDLGenerator.error(monitor, "WsdlGenException2", wsBinding, (Exception)ex.getCause());
            }
            throw new IllegalStateException(ex);
        }
        catch (RuntimeException ex) {
            BindingWSDLGenerator.warning(monitor, "WsdlGenException", wsBinding, component.getName(), contract.getName());
            BindingWSDLGenerator.error(monitor, "WsdlGenException2", wsBinding, component.getName(), contract.getName(), ex.getMessage());
        }
    }

    private static void createWSDLDocument(Component component, Contract contract, WebServiceBinding wsBinding, ExtensionPointRegistry extensionPoints, Monitor monitor) {
        Definition definition;
        InterfaceContract icontract;
        FactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        DataBindingExtensionPoint dataBindings = extensionPoints.getExtensionPoint(DataBindingExtensionPoint.class);
        WSDLFactory wsdlFactory = modelFactories.getFactory(WSDLFactory.class);
        XSDFactory xsdFactory = modelFactories.getFactory(XSDFactory.class);
        DocumentBuilderFactory documentBuilderFactory = modelFactories.getFactory(DocumentBuilderFactory.class);
        if (contract.getInterfaceContract(wsBinding) == null) {
            BindingWSDLGenerator.fatal(monitor, "MissingInterfaceContract", wsBinding, component.getName(), contract.getName());
        }
        if ((icontract = wsBinding.getBindingInterfaceContract()) == null) {
            icontract = contract.getInterfaceContract(wsBinding).makeUnidirectional(false);
            if (icontract instanceof JavaInterfaceContract) {
                ModelResolver resolver = component instanceof ResolverExtension ? ((ResolverExtension)((Object)component)).getModelResolver() : null;
                icontract = BindingWSDLGenerator.createWSDLInterfaceContract((JavaInterfaceContract)icontract, BindingWSDLGenerator.requiresSOAP12(wsBinding), resolver, dataBindings, wsdlFactory, xsdFactory, documentBuilderFactory, monitor);
            } else {
                try {
                    icontract = (InterfaceContract)icontract.clone();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            wsBinding.setBindingInterfaceContract(icontract);
        }
        if ((definition = wsBinding.getGeneratedWSDLDocument()) == null) {
            definition = WSDLServiceGenerator.configureWSDLDefinition(wsBinding, component, contract, monitor);
            wsBinding.setGeneratedWSDLDocument(definition);
        }
    }

    protected static boolean requiresSOAP12(WebServiceBinding wsBinding) {
        if (wsBinding instanceof PolicySubject) {
            List<Intent> intents = ((PolicySubject)((Object)wsBinding)).getRequiredIntents();
            for (Intent intent : intents) {
                if (!SOAP12_INTENT.equals(intent.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static WSDLInterfaceContract createWSDLInterfaceContract(JavaInterfaceContract contract, boolean requiresSOAP12, ModelResolver resolver, DataBindingExtensionPoint dataBindings, WSDLFactory wsdlFactory, XSDFactory xsdFactory, DocumentBuilderFactory documentBuilderFactory, Monitor monitor) {
        WSDLInterface wsdlInterface;
        WSDLInterfaceContract wsdlContract = wsdlFactory.createWSDLInterfaceContract();
        if (contract.getInterface() != null) {
            wsdlInterface = BindingWSDLGenerator.createWSDLInterface((JavaInterface)contract.getInterface(), requiresSOAP12, resolver, dataBindings, wsdlFactory, xsdFactory, documentBuilderFactory, monitor);
            wsdlContract.setInterface(wsdlInterface);
        }
        if (contract.getCallbackInterface() != null) {
            wsdlInterface = BindingWSDLGenerator.createWSDLInterface((JavaInterface)contract.getCallbackInterface(), requiresSOAP12, resolver, dataBindings, wsdlFactory, xsdFactory, documentBuilderFactory, monitor);
            wsdlContract.setCallbackInterface(wsdlInterface);
        }
        return wsdlContract;
    }

    public static WSDLInterface createWSDLInterface(JavaInterface javaInterface, boolean requiresSOAP12, ModelResolver resolver, DataBindingExtensionPoint dataBindings, WSDLFactory wsdlFactory, XSDFactory xsdFactory, DocumentBuilderFactory documentBuilderFactory, Monitor monitor) {
        WSDLInterface wsdlInterface = wsdlFactory.createWSDLInterface();
        WSDLDefinition wsdlDefinition = wsdlFactory.createWSDLDefinition();
        Definition def = null;
        try {
            Interface2WSDLGenerator wsdlGenerator = new Interface2WSDLGenerator(requiresSOAP12, resolver, dataBindings, xsdFactory, documentBuilderFactory, monitor);
            def = wsdlGenerator.generate(javaInterface, wsdlDefinition);
        }
        catch (WSDLException e) {
            throw new WSDLGenerationException(e);
        }
        if (printWSDL) {
            try {
                System.out.println("Generated WSDL for Java interface " + javaInterface.getName() + " class " + javaInterface.getJavaClass().getName());
                WSDLWriter writer = javax.wsdl.factory.WSDLFactory.newInstance().newWSDLWriter();
                writer.writeWSDL(def, System.out);
            }
            catch (WSDLException e) {
                throw new WSDLGenerationException(e);
            }
        }
        wsdlDefinition.setDefinition(def);
        wsdlInterface.setWsdlDefinition(wsdlDefinition);
        wsdlInterface.setRemotable(true);
        wsdlInterface.setUnresolved(false);
        wsdlInterface.setRemotable(true);
        PortType portType = (PortType)def.getAllPortTypes().values().iterator().next();
        wsdlInterface.setPortType(portType);
        try {
            wsdlFactory.createWSDLInterface(wsdlInterface, portType, wsdlDefinition, resolver, monitor);
        }
        catch (InvalidInterfaceException e) {
            throw new WSDLGenerationException(e);
        }
        return wsdlInterface;
    }
}

