/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.jaxws;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.oasisopen.sca.ServiceRuntimeException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
public class JAXWSBindingProvider
implements Provider<SOAPMessage> {
    public static final String WSA_FINAL_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    public static final QName QNAME_WSA_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address");
    public static final QName QNAME_WSA_FROM = new QName("http://www.w3.org/2005/08/addressing", "From");
    public static final QName QNAME_WSA_REPLYTO = new QName("http://www.w3.org/2005/08/addressing", "ReplyTo");
    public static final QName QNAME_WSA_REFERENCE_PARAMETERS = new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters");
    public static final QName QNAME_WSA_MESSAGEID = new QName("http://www.w3.org/2005/08/addressing", "MessageID");
    private MessageFactory messageFactory;
    private RuntimeEndpoint endpoint;
    private WebServiceBinding wsBinding;
    private javax.xml.soap.MessageFactory soapMessageFactory;
    private SOAPFactory soapFactory;
    @Resource
    private WebServiceContext context;
    private RuntimeAssemblyFactory assemblyFactory;
    private WebServiceBindingFactory webServiceBindingFactory;
    private static String WS_REF_PARMS = "WS_REFERENCE_PARAMETERS";
    private static String WS_MESSAGE_ID = "WS_MESSAGE_ID";
    private static String WS_ADDR_ANONYMOUS = "http://www.w3.org/2005/08/addressing/anonymous";
    private static String WS_ADDR_NONE = "http://www.w3.org/2005/08/addressing/none";

    public JAXWSBindingProvider() {
    }

    public JAXWSBindingProvider(RuntimeEndpoint endpoint, ServletHost servletHost, FactoryExtensionPoint modelFactories, DataBindingExtensionPoint dataBindings, String defaultPort) {
        this.messageFactory = modelFactories.getFactory(MessageFactory.class);
        this.soapMessageFactory = modelFactories.getFactory(javax.xml.soap.MessageFactory.class);
        this.soapFactory = modelFactories.getFactory(SOAPFactory.class);
        this.assemblyFactory = (RuntimeAssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.webServiceBindingFactory = modelFactories.getFactory(WebServiceBindingFactory.class);
        this.endpoint = endpoint;
        this.wsBinding = (WebServiceBinding)endpoint.getBinding();
        if (this.wsBinding.getGeneratedWSDLDocument() == null) {
            throw new ServiceRuntimeException("No WSDL document for " + endpoint.getURI());
        }
        InterfaceContract contract = this.wsBinding.getBindingInterfaceContract();
        contract.getInterface().resetDataBinding(Node.class.getName());
        if (!this.wsBinding.getURI().startsWith("http://")) {
            String serviceURI = null;
            List wsdlPortExtensions = this.wsBinding.getPort().getExtensibilityElements();
            for (Object extension : wsdlPortExtensions) {
                if (!(extension instanceof SOAPAddress)) continue;
                serviceURI = ((SOAPAddress)extension).getLocationURI();
            }
            if (serviceURI == null || !serviceURI.startsWith("http://")) {
                serviceURI = "http://localhost:" + defaultPort + this.wsBinding.getURI();
            }
            this.wsBinding.setURI(serviceURI);
        }
        System.out.println("Binding.ws JAXWS provider - Service URI: " + this.wsBinding.getURI());
    }

    public void start() {
    }

    public void stop() {
    }

    public SOAPMessage invoke(SOAPMessage request) {
        try {
            Node root = request.getSOAPBody().getFirstChild();
            String operationName = root.getLocalName();
            Operation operation = null;
            for (InvocationChain invocationChain : this.endpoint.getInvocationChains()) {
                if (!operationName.equals(invocationChain.getSourceOperation().getName())) continue;
                operation = invocationChain.getSourceOperation();
                break;
            }
            if (operation == null) {
                throw new SOAPException("Operation not found: " + operationName);
            }
            Message requestMsg = this.messageFactory.createMessage();
            Object[] body = new Object[]{root};
            requestMsg.setBody(body);
            requestMsg.setOperation(operation);
            SOAPHeader header = request.getSOAPHeader();
            String callbackAddress = null;
            if (header != null) {
                callbackAddress = this.handleCallbackAddress(header, requestMsg);
                this.handleMessageIDHeader(header, requestMsg);
            }
            EndpointReference from = null;
            if (callbackAddress != null) {
                this.checkCallbackAddress(callbackAddress, request);
                from = this.assemblyFactory.createEndpointReference();
                Endpoint fromEndpoint = this.assemblyFactory.createEndpoint();
                from.setTargetEndpoint(fromEndpoint);
                from.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
                requestMsg.setFrom(from);
                Endpoint callbackEndpoint = this.assemblyFactory.createEndpoint();
                WebServiceBinding cbBinding = this.webServiceBindingFactory.createWebServiceBinding();
                cbBinding.setURI(callbackAddress);
                callbackEndpoint.setBinding(cbBinding);
                callbackEndpoint.setURI(callbackAddress);
                callbackEndpoint.setUnresolved(true);
                from.setCallbackEndpoint(callbackEndpoint);
            }
            Message responseMsg = this.endpoint.invoke(operation, requestMsg);
            SOAPMessage response = this.soapMessageFactory.createMessage();
            if (responseMsg.isFault()) {
                FaultException fe = (FaultException)responseMsg.getBody();
                SOAPFault fault = response.getSOAPBody().addFault(new QName(response.getSOAPBody().getNamespaceURI(), "Server"), fe.getMessage());
                Detail d = fault.addDetail();
                DetailEntry de = d.addDetailEntry(fe.getFaultName());
                SOAPElement dece = de.addChildElement("message");
                if (fe.getMessage() != null) {
                    dece.addTextNode(fe.getMessage());
                }
            } else {
                Element element = (Element)responseMsg.getBody();
                response.getSOAPBody().addChildElement(this.soapFactory.createElement(element));
            }
            return response;
        }
        catch (SOAPException e) {
            throw new ServiceRuntimeException(e);
        }
    }

    private String handleCallbackAddress(SOAPHeader header, Message msg) {
        Iterator it2;
        SOAPElement from;
        String callbackAddress = null;
        Iterator it = header.getChildElements(QNAME_WSA_FROM);
        SOAPElement sOAPElement = from = it.hasNext() ? (SOAPElement)it.next() : null;
        if (from == null) {
            it2 = header.getChildElements(QNAME_WSA_REPLYTO);
            SOAPElement sOAPElement2 = from = it2.hasNext() ? (SOAPElement)it2.next() : null;
        }
        if (from != null) {
            SOAPElement callbackAddrElement;
            it2 = header.getChildElements(QNAME_WSA_ADDRESS);
            SOAPElement sOAPElement3 = callbackAddrElement = it2.hasNext() ? (SOAPElement)it2.next() : null;
            if (callbackAddrElement != null) {
                Iterator it3;
                SOAPElement refParms;
                if (this.endpoint.getService().getInterfaceContract().getCallbackInterface() != null) {
                    callbackAddress = callbackAddrElement.getTextContent();
                }
                SOAPElement sOAPElement4 = refParms = (it3 = header.getChildElements(QNAME_WSA_REFERENCE_PARAMETERS)).hasNext() ? (SOAPElement)it3.next() : null;
                if (refParms != null) {
                    msg.getHeaders().put(WS_REF_PARMS, refParms);
                }
            }
        }
        return callbackAddress;
    }

    private void handleMessageIDHeader(SOAPHeader header, Message msg) {
        SOAPElement messageID;
        if (header == null) {
            return;
        }
        Iterator it = header.getChildElements(QNAME_WSA_MESSAGEID);
        SOAPElement sOAPElement = messageID = it.hasNext() ? (SOAPElement)it.next() : null;
        if (messageID != null) {
            String idValue = messageID.getTextContent();
            msg.getHeaders().put(WS_MESSAGE_ID, idValue);
        }
    }

    private void checkCallbackAddress(String callbackAddress, SOAPMessage request) {
        if (WS_ADDR_ANONYMOUS.equals(callbackAddress) || WS_ADDR_NONE.equals(callbackAddress)) {
            this.triggerOnlyNonAnonymousAddressSupportedFault(request, "wsa:From");
        }
    }

    public void triggerOnlyNonAnonymousAddressSupportedFault(SOAPMessage request, String incorrectHeaderName) {
    }
}

