/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.provider;

import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.invocation.AsyncResponseInvoker;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.InvokerAsyncRequest;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class SCABindingInvoker
extends InterceptorAsyncImpl {
    private InvocationChain chain;
    private Mediator mediator;
    private Operation sourceOperation;
    private Operation targetOperation;
    private boolean passByValue;
    private RuntimeEndpointReference epr;
    private RuntimeEndpoint ep;
    private ExtensionPointRegistry registry;

    public SCABindingInvoker(InvocationChain chain, Operation sourceOperation, Mediator mediator, boolean passByValue, RuntimeEndpointReference epr, ExtensionPointRegistry registry) {
        this.chain = chain;
        this.mediator = mediator;
        this.sourceOperation = sourceOperation;
        this.targetOperation = chain.getTargetOperation();
        this.passByValue = passByValue;
        this.epr = epr;
        this.ep = (RuntimeEndpoint)epr.getTargetEndpoint();
        this.registry = registry;
    }

    @Override
    public Invoker getNext() {
        return this.chain.getHeadInvoker("service.policy");
    }

    @Override
    public void setNext(Invoker next) {
    }

    @Override
    public Message processRequest(Message msg) {
        if (this.passByValue) {
            msg.setBody(this.mediator.copyInput(msg.getBody(), this.sourceOperation, this.targetOperation));
        }
        this.ep.getInvocationChains();
        if (!this.ep.getCallbackEndpointReferences().isEmpty()) {
            RuntimeEndpointReference asyncEPR = (RuntimeEndpointReference)this.ep.getCallbackEndpointReferences().get(0);
            msg.getHeaders().put("ASYNC_CALLBACK", asyncEPR);
        }
        if (this.ep.isAsyncInvocation()) {
            String msgID = (String)msg.getHeaders().get("MESSAGE_ID");
            String operationName = msg.getOperation().getName();
            AsyncResponseInvoker<RuntimeEndpointReference> respInvoker = new AsyncResponseInvoker<RuntimeEndpointReference>(this.ep, null, this.epr, msgID, operationName, this.getMessageFactory());
            respInvoker.setBindingType("SCA_LOCAL");
            msg.getHeaders().put("ASYNC_RESPONSE_INVOKER", respInvoker);
        }
        return msg;
    }

    @Override
    public Message processResponse(Message msg) {
        if (this.passByValue) {
            if (msg.isFault()) {
                msg.setFaultBody(this.mediator.copyFault(msg.getBody(), this.sourceOperation, this.targetOperation));
            } else if (this.sourceOperation.getOutputType() != null) {
                msg.setBody(this.mediator.copyOutput(msg.getBody(), this.sourceOperation, this.targetOperation));
            }
        }
        return msg;
    }

    @Override
    public void invokeAsyncRequest(Message msg) throws Throwable {
        try {
            msg = this.processRequest(msg);
            InvokerAsyncRequest theNext = (InvokerAsyncRequest)((Object)this.getNext());
            if (theNext != null) {
                theNext.invokeAsyncRequest(msg);
            }
            this.postProcessRequest(msg);
        }
        catch (Throwable e) {
            this.postProcessRequest(msg, e);
        }
    }

    @Override
    public void invokeAsyncResponse(Message msg) {
        InvokerAsyncResponse thePrevious;
        AsyncResponseInvoker respInvoker = (AsyncResponseInvoker)(msg = this.processResponse(msg)).getHeaders().get("ASYNC_RESPONSE_INVOKER");
        if (respInvoker != null && "SCA_LOCAL".equals(respInvoker.getBindingType())) {
            RuntimeEndpointReference responseEPR = (RuntimeEndpointReference)respInvoker.getResponseTargetAddress();
            msg.setFrom(responseEPR);
            String msgID = respInvoker.getRelatesToMsgID();
            msg.getHeaders().put("RELATES_TO", msgID);
        }
        if ((thePrevious = this.getPrevious()) != null) {
            thePrevious.invokeAsyncResponse(msg);
        }
    }

    @Override
    public boolean isLocalSCABIndingInvoker() {
        return true;
    }

    private MessageFactory getMessageFactory() {
        FactoryExtensionPoint modelFactories = this.registry.getExtensionPoint(FactoryExtensionPoint.class);
        return modelFactories.getFactory(MessageFactory.class);
    }
}

