/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.provider;

import org.apache.tuscany.sca.binding.sca.provider.DelegatingSCAServiceBindingProvider;
import org.apache.tuscany.sca.binding.sca.provider.SCABindingAsyncResponseInvoker;
import org.apache.tuscany.sca.binding.sca.provider.SCABindingLocalInvocationInterceptor;
import org.apache.tuscany.sca.binding.sca.provider.SCABindingMapper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.provider.EndpointAsyncProvider;
import org.apache.tuscany.sca.provider.OptimisingBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class RuntimeSCAServiceBindingProvider
implements EndpointAsyncProvider,
OptimisingBindingProvider {
    private RuntimeEndpoint endpoint;
    private RuntimeComponentService service;
    private ServiceBindingProvider distributedProvider;
    private SCABindingMapper scaBindingMapper;

    public RuntimeSCAServiceBindingProvider(ExtensionPointRegistry extensionPoints, RuntimeEndpoint endpoint) {
        this.endpoint = endpoint;
        this.service = (RuntimeComponentService)endpoint.getService();
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.scaBindingMapper = utilities.getUtility(SCABindingMapper.class);
        if (this.service.getInterfaceContract().getInterface().isRemotable() && this.scaBindingMapper.isRemotable(endpoint)) {
            this.distributedProvider = new DelegatingSCAServiceBindingProvider(endpoint, this.scaBindingMapper);
        }
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        if (this.distributedProvider != null) {
            return this.distributedProvider.getBindingInterfaceContract();
        }
        return this.endpoint.getComponentTypeServiceInterfaceContract();
    }

    @Override
    public boolean supportsOneWayInvocation() {
        if (this.distributedProvider != null) {
            return this.distributedProvider.supportsOneWayInvocation();
        }
        return false;
    }

    @Override
    public void start() {
        if (this.distributedProvider != null) {
            this.distributedProvider.start();
        }
    }

    @Override
    public void stop() {
        this.endpoint.getBinding().setURI(null);
        if (this.distributedProvider != null) {
            this.distributedProvider.stop();
        }
    }

    @Override
    public void configure() {
    }

    @Override
    public boolean supportsNativeAsync() {
        return true;
    }

    @Override
    public InvokerAsyncResponse createAsyncResponseInvoker() {
        if (this.distributedProvider != null) {
            return ((EndpointAsyncProvider)this.distributedProvider).createAsyncResponseInvoker();
        }
        return new SCABindingAsyncResponseInvoker(null, null);
    }

    @Override
    public void optimiseBinding(RuntimeEndpoint ep) {
        for (InvocationChain chain : ep.getInvocationChains()) {
            chain.addHeadInterceptor("service.policy", new SCABindingLocalInvocationInterceptor());
        }
    }
}

