/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.provider;

import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.binding.sca.provider.DelegatingSCAReferenceBindingProvider;
import org.apache.tuscany.sca.binding.sca.provider.SCABindingInvoker;
import org.apache.tuscany.sca.binding.sca.provider.SCABindingMapper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.Compatibility;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.EndpointReferenceAsyncProvider;
import org.apache.tuscany.sca.provider.EndpointReferenceProvider;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.ServiceUnavailableException;

public class RuntimeSCAReferenceBindingProvider
implements EndpointReferenceAsyncProvider {
    private RuntimeEndpointReference endpointReference;
    private RuntimeComponent component;
    private RuntimeComponentReference reference;
    private SCABinding binding;
    private boolean remotable;
    private boolean started = false;
    private ReferenceBindingProvider distributedProvider;
    private Mediator mediator;
    private InterfaceContractMapper interfaceContractMapper;
    private SCABindingMapper scaBindingMapper;
    private ExtensionPointRegistry registry;

    public RuntimeSCAReferenceBindingProvider(ExtensionPointRegistry extensionPoints, RuntimeEndpointReference endpointReference) {
        this.registry = extensionPoints;
        this.endpointReference = endpointReference;
        this.component = (RuntimeComponent)endpointReference.getComponent();
        this.reference = (RuntimeComponentReference)endpointReference.getReference();
        this.binding = (SCABinding)endpointReference.getBinding();
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.mediator = utilities.getUtility(Mediator.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
        this.scaBindingMapper = utilities.getUtility(SCABindingMapper.class);
        this.remotable = this.isTargetRemote();
        this.getDistributedProvider();
    }

    private boolean isTargetRemote() {
        return this.endpointReference.getTargetEndpoint().isRemote();
    }

    private ReferenceBindingProvider getDistributedProvider() {
        if (this.remotable && this.distributedProvider == null) {
            if (this.reference.getInterfaceContract() != null && !this.reference.getInterfaceContract().getInterface().isRemotable()) {
                throw new ServiceRuntimeException("Reference interface not remotable for component: " + this.component.getName() + " and reference: " + this.reference.getName());
            }
            if (this.scaBindingMapper.isRemotable(this.endpointReference)) {
                this.distributedProvider = new DelegatingSCAReferenceBindingProvider(this.endpointReference, this.scaBindingMapper);
            }
        }
        return this.distributedProvider;
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        if (this.remotable && this.distributedProvider != null) {
            return this.distributedProvider.getBindingInterfaceContract();
        }
        RuntimeEndpoint endpoint = (RuntimeEndpoint)this.endpointReference.getTargetEndpoint();
        if (endpoint != null) {
            return endpoint.getComponentTypeServiceInterfaceContract();
        }
        return this.endpointReference.getComponentTypeReferenceInterfaceContract();
    }

    @Override
    public boolean supportsOneWayInvocation() {
        if (this.remotable && this.distributedProvider != null) {
            return this.distributedProvider.supportsOneWayInvocation();
        }
        return false;
    }

    private Invoker getInvoker(RuntimeEndpointReference epr, Operation operation) {
        RuntimeComponentService service;
        Endpoint target = epr.getTargetEndpoint();
        if (target != null && (service = (RuntimeComponentService)target.getService()) != null) {
            InvocationChain chain = ((RuntimeEndpoint)target).getInvocationChain(operation);
            boolean passByValue = false;
            Operation targetOp = chain.getTargetOperation();
            if (!operation.getInterface().isRemotable()) {
                if (this.interfaceContractMapper.isCompatibleByReference(operation, targetOp, Compatibility.SUBSET)) {
                    passByValue = false;
                }
            } else {
                boolean allowsPBR;
                Reference ref = epr.getReference().getReference();
                boolean bl = allowsPBR = ref != null && ref.isAllowsPassByReference() && chain.allowsPassByReference();
                if (allowsPBR && this.interfaceContractMapper.isCompatibleByReference(operation, targetOp, Compatibility.SUBSET)) {
                    passByValue = false;
                } else if (this.interfaceContractMapper.isCompatibleByValue(operation, targetOp, Compatibility.SUBSET)) {
                    passByValue = true;
                }
            }
            return chain == null ? null : new SCABindingInvoker(chain, operation, this.mediator, passByValue, epr, this.registry);
        }
        return null;
    }

    @Override
    public Invoker createInvoker(Operation operation) {
        if (this.remotable && this.distributedProvider != null) {
            return this.distributedProvider.createInvoker(operation);
        }
        Invoker invoker = this.getInvoker(this.endpointReference, operation);
        if (invoker == null) {
            throw new ServiceUnavailableException("Unable to create SCA binding invoker for local target " + this.component.getName() + " reference " + this.reference.getName() + " (bindingURI=" + this.binding.getURI() + " operation=" + operation.getName() + ")");
        }
        return invoker;
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        if (this.distributedProvider != null) {
            this.distributedProvider.start();
        }
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        try {
            if (this.distributedProvider != null) {
                this.distributedProvider.stop();
            }
        }
        finally {
            this.started = false;
        }
    }

    @Override
    public void configure() {
        if (this.distributedProvider instanceof EndpointReferenceProvider) {
            ((EndpointReferenceProvider)this.distributedProvider).configure();
        }
    }

    @Override
    public boolean supportsNativeAsync() {
        return true;
    }
}

