/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.provider;

import java.util.logging.Logger;
import org.apache.tuscany.sca.binding.sca.provider.SCABindingMapper;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.provider.EndpointAsyncProvider;
import org.apache.tuscany.sca.provider.EndpointProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class DelegatingSCAServiceBindingProvider
implements EndpointAsyncProvider {
    private static final Logger logger = Logger.getLogger(DelegatingSCAServiceBindingProvider.class.getName());
    private ServiceBindingProvider provider;
    private RuntimeEndpoint endpoint;
    private RuntimeEndpoint mappedEndpoint;
    private boolean started = false;

    public DelegatingSCAServiceBindingProvider(RuntimeEndpoint endpoint, SCABindingMapper mapper) {
        this.endpoint = endpoint;
        this.mappedEndpoint = mapper.map(endpoint);
        if (this.mappedEndpoint != null) {
            this.provider = this.mappedEndpoint.getBindingProvider();
        }
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.provider.getBindingInterfaceContract();
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return this.provider.supportsOneWayInvocation();
    }

    @Override
    public void configure() {
        if (this.provider instanceof EndpointProvider) {
            ((EndpointProvider)this.provider).configure();
        }
    }

    @Override
    public boolean supportsNativeAsync() {
        if (this.provider instanceof EndpointAsyncProvider) {
            return ((EndpointAsyncProvider)this.provider).supportsNativeAsync();
        }
        return false;
    }

    @Override
    public InvokerAsyncResponse createAsyncResponseInvoker() {
        if (this.provider instanceof EndpointAsyncProvider) {
            return ((EndpointAsyncProvider)this.provider).createAsyncResponseInvoker();
        }
        return null;
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.provider.start();
        this.endpoint.getBinding().setURI(this.mappedEndpoint.getBinding().getURI());
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        try {
            this.provider.stop();
        }
        finally {
            this.started = false;
        }
    }
}

