/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.provider;

import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.binding.sca.provider.SCABindingMapper;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclarationParser;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.provider.ProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.runtime.DomainRegistryFactory;
import org.apache.tuscany.sca.runtime.DomainRegistryFactoryExtensionPoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class DefaultSCABindingMapper
implements SCABindingMapper {
    private static final Logger logger = Logger.getLogger(DefaultSCABindingMapper.class.getName());
    protected ExtensionPointRegistry registry;
    protected ProviderFactoryExtensionPoint providerFactories;
    protected StAXArtifactProcessorExtensionPoint processors;
    protected QName defaultMappedBinding;

    public DefaultSCABindingMapper(ExtensionPointRegistry registry, Map<String, String> attributes) {
        this.registry = registry;
        this.providerFactories = registry.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.processors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.defaultMappedBinding = this.getDefaultMappedBinding(attributes);
    }

    protected QName getDefaultMappedBinding(Map<String, String> attributes) {
        String qname;
        QName defaultMappedBinding = null;
        if (attributes != null && (qname = attributes.get("mappedBinding")) != null) {
            defaultMappedBinding = ServiceDeclarationParser.getQName(qname);
        }
        if (defaultMappedBinding == null) {
            qname = System.getProperty("org.apache.tuscany.sca.binding.sca.provider.SCABindingMapper.mappedBinding");
            if (qname != null) {
                defaultMappedBinding = ServiceDeclarationParser.getQName(qname);
            } else {
                defaultMappedBinding = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "binding.hazelcast");
                if (this.registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class).getProcessor(defaultMappedBinding) == null) {
                    defaultMappedBinding = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.ws");
                    if (this.registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class).getProcessor(defaultMappedBinding) == null) {
                        defaultMappedBinding = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "binding.rmi");
                    }
                }
            }
        }
        return defaultMappedBinding;
    }

    private BindingBuilder getBindingBuilder(QName binding) {
        StAXArtifactProcessor processor = this.processors.getProcessor(binding);
        if (processor == null) {
            logger.warning("Mapped binding for binding.sca is not supported: " + binding);
        }
        try {
            Binding bindingTemplate;
            ProviderFactory providerFactory;
            if (processor != null && (providerFactory = this.providerFactories.getProviderFactory((bindingTemplate = this.createDelegatingBinding(binding)).getClass())) == null) {
                logger.warning("Mapped binding for binding.sca is not supported: " + binding);
                processor = null;
            }
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
        BuilderExtensionPoint builders = this.registry.getExtensionPoint(BuilderExtensionPoint.class);
        BindingBuilder builder = builders.getBindingBuilder(binding);
        return builder;
    }

    protected boolean isDistributed() {
        String[] schemes;
        DomainRegistryFactoryExtensionPoint factories = this.registry.getExtensionPoint(DomainRegistryFactoryExtensionPoint.class);
        List<DomainRegistryFactory> list = factories.getDomainRegistryFactories();
        return list.size() != 1 || !Arrays.asList(schemes = list.get(0).getSupportedSchemes()).contains("local");
    }

    @Override
    public RuntimeEndpoint map(RuntimeEndpoint endpoint) {
        QName bindingType = this.chooseBinding(endpoint);
        if (this.processors.getProcessor(bindingType) == null) {
            logger.warning("Mapped binding for binding.sca is not supported: " + bindingType);
            return null;
        }
        RuntimeEndpoint ep = null;
        try {
            ep = (RuntimeEndpoint)endpoint.clone();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Binding binding = this.map(endpoint.getBinding(), bindingType);
        ep.setBinding(binding);
        BindingBuilder builder = this.getBindingBuilder(bindingType);
        if (builder != null) {
            builder.build(ep.getComponent(), ep.getService(), binding, new BuilderContext(this.registry), false);
        }
        return ep;
    }

    @Override
    public RuntimeEndpointReference map(RuntimeEndpointReference endpointReference) {
        QName bindingType = this.chooseBinding(endpointReference);
        if (this.processors.getProcessor(bindingType) == null) {
            logger.warning("Mapped binding for binding.sca is not supported: " + bindingType);
            return null;
        }
        RuntimeEndpointReference epr = null;
        try {
            epr = (RuntimeEndpointReference)endpointReference.clone();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Binding binding = this.map(endpointReference.getBinding(), bindingType);
        epr.setBinding(binding);
        BindingBuilder builder = this.getBindingBuilder(bindingType);
        if (builder != null) {
            builder.build(epr.getComponent(), epr.getReference(), binding, new BuilderContext(this.registry), false);
        }
        return epr;
    }

    protected Binding map(Binding scaBinding, QName newBindingType) {
        try {
            Binding binding = this.createDelegatingBinding(newBindingType);
            binding.setName(scaBinding.getName());
            binding.setURI(scaBinding.getURI());
            binding.setOperationSelector(scaBinding.getOperationSelector());
            binding.setRequestWireFormat(scaBinding.getRequestWireFormat());
            binding.setResponseWireFormat(scaBinding.getResponseWireFormat());
            if (binding instanceof PolicySubject && scaBinding instanceof PolicySubject) {
                PolicySubject subject1 = (PolicySubject)((Object)binding);
                PolicySubject subject2 = (PolicySubject)((Object)scaBinding);
                subject1.getPolicySets().addAll(subject2.getPolicySets());
                subject1.getRequiredIntents().addAll(subject2.getRequiredIntents());
            }
            return binding;
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
    }

    protected Binding createDelegatingBinding(QName bindingType) throws XMLStreamException, ContributionReadException {
        StAXArtifactProcessor processor = this.processors.getProcessor(bindingType);
        if (processor == null) {
            logger.warning("Mapped binding for binding.sca is not supported: " + bindingType);
        }
        StringBuffer xml = new StringBuffer();
        xml.append("<").append(bindingType.getLocalPart()).append(" xmlns:b=\"").append(bindingType.getNamespaceURI()).append("\"/>");
        StAXHelper staxHelper = StAXHelper.getInstance(this.registry);
        XMLStreamReader reader = staxHelper.createXMLStreamReader(new StringReader(xml.toString()));
        reader.nextTag();
        Binding binding = (Binding)processor.read(reader, new ProcessorContext(this.registry));
        return binding;
    }

    @Override
    public boolean isRemotable(RuntimeEndpoint endpoint) {
        return this.isDistributed() && this.processors.getProcessor(this.chooseBinding(endpoint)) != null;
    }

    @Override
    public boolean isRemotable(RuntimeEndpointReference endpointReference) {
        return this.isDistributed() && this.processors.getProcessor(this.chooseBinding(endpointReference)) != null;
    }

    protected QName chooseBinding(RuntimeEndpoint endpoint) {
        return this.defaultMappedBinding;
    }

    protected QName chooseBinding(RuntimeEndpointReference endpointReference) {
        return this.defaultMappedBinding;
    }
}

