/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.OperationSelector;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.binding.rest.RESTBinding;
import org.apache.tuscany.sca.binding.rest.RESTBindingFactory;
import org.apache.tuscany.sca.common.http.HTTPHeader;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class RESTBindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<RESTBinding> {
    private static final QName HEADERS_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "http-headers");
    private static final QName HEADER_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "header");
    private static final QName RESPONSE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "response");
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String URI = "uri";
    private RESTBindingFactory httpBindingFactory;
    private StAXArtifactProcessor<Object> extensionProcessor;

    public RESTBindingProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<Object> extensionProcessor, StAXAttributeProcessor<Object> extensionAttributeProcessor) {
        FactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.httpBindingFactory = modelFactories.getFactory(RESTBindingFactory.class);
        this.extensionProcessor = extensionProcessor;
    }

    @Override
    public QName getArtifactType() {
        return RESTBinding.TYPE;
    }

    @Override
    public Class<RESTBinding> getModelType() {
        return RESTBinding.class;
    }

    @Override
    public RESTBinding read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        RESTBinding restBinding = this.httpBindingFactory.createRESTBinding();
        while (reader.hasNext()) {
            QName elementName = null;
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    Object extension;
                    String name;
                    elementName = reader.getName();
                    if (RESTBinding.TYPE.equals(elementName)) {
                        String uri;
                        name = this.getString(reader, NAME);
                        if (name != null) {
                            restBinding.setName(name);
                        }
                        if ((uri = this.getURIString(reader, URI)) == null) break;
                        restBinding.setURI(uri);
                        break;
                    }
                    if (HEADERS_QNAME.equals(elementName)) break;
                    if (HEADER_QNAME.equals(elementName)) {
                        name = this.getString(reader, NAME);
                        String value = this.getURIString(reader, VALUE);
                        if (name == null) break;
                        restBinding.getHttpHeaders().add(new HTTPHeader(name, value));
                        break;
                    }
                    if (RESPONSE_QNAME.equals(elementName)) {
                        reader.next();
                        if (reader.hasNext()) {
                            int sub_event = reader.getEventType();
                            switch (sub_event) {
                                case 1: {
                                    elementName = reader.getName();
                                    break;
                                }
                                default: {
                                    reader.next();
                                    break;
                                }
                            }
                        }
                        if ((extension = this.extensionProcessor.read(reader, context)) == null || !(extension instanceof WireFormat)) break;
                        restBinding.setResponseWireFormat((WireFormat)extension);
                        break;
                    }
                    extension = this.extensionProcessor.read(reader, context);
                    if (extension == null) break;
                    if (extension instanceof WireFormat) {
                        restBinding.setRequestWireFormat((WireFormat)extension);
                        restBinding.setResponseWireFormat((WireFormat)extension);
                        break;
                    }
                    if (!(extension instanceof OperationSelector)) break;
                    restBinding.setOperationSelector((OperationSelector)extension);
                    break;
                }
                case 2: {
                    elementName = reader.getName();
                    if (!RESTBinding.TYPE.equals(elementName)) break;
                    return restBinding;
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return restBinding;
    }

    @Override
    public void write(RESTBinding restBinding, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, RESTBinding.TYPE.getNamespaceURI(), RESTBinding.TYPE.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        if (restBinding.getName() != null) {
            writer.writeAttribute(NAME, restBinding.getName());
        }
        if (restBinding.getURI() != null) {
            writer.writeAttribute(URI, restBinding.getURI());
        }
        if (restBinding.getOperationSelector() != null) {
            this.extensionProcessor.write(restBinding.getOperationSelector(), writer, context);
        }
        if (restBinding.getRequestWireFormat() != null) {
            this.extensionProcessor.write(restBinding.getRequestWireFormat(), writer, context);
        }
        if (restBinding.getResponseWireFormat() != null && restBinding.getRequestWireFormat() != restBinding.getResponseWireFormat()) {
            this.writeStart(writer, RESPONSE_QNAME.getNamespaceURI(), RESPONSE_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
            this.extensionProcessor.write(restBinding.getResponseWireFormat(), writer, context);
            this.writeEnd(writer);
        }
        this.writeEnd(writer);
    }

    @Override
    public void resolve(RESTBinding model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }
}

