/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.OperationSelector;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.HTTPBindingFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class HTTPBindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<HTTPBinding> {
    private static final String NAME = "name";
    private static final String URI = "uri";
    private HTTPBindingFactory httpBindingFactory;
    private StAXArtifactProcessor<Object> extensionProcessor;
    private StAXAttributeProcessor<Object> extensionAttributeProcessor;

    public HTTPBindingProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor) {
        FactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.httpBindingFactory = modelFactories.getFactory(HTTPBindingFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.extensionAttributeProcessor = extensionAttributeProcessor;
    }

    @Override
    public QName getArtifactType() {
        return HTTPBinding.TYPE;
    }

    @Override
    public Class<HTTPBinding> getModelType() {
        return HTTPBinding.class;
    }

    @Override
    public HTTPBinding read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        HTTPBinding httpBinding = this.httpBindingFactory.createHTTPBinding();
        while (reader.hasNext()) {
            QName elementName = null;
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    elementName = reader.getName();
                    if (HTTPBinding.TYPE.equals(elementName)) {
                        String uri;
                        String name = this.getString(reader, NAME);
                        if (name != null) {
                            httpBinding.setName(name);
                        }
                        if ((uri = this.getURIString(reader, URI)) == null) break;
                        httpBinding.setURI(uri);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader, context);
                    if (extension == null) break;
                    if (extension instanceof WireFormat) {
                        httpBinding.setRequestWireFormat((WireFormat)extension);
                        break;
                    }
                    if (!(extension instanceof OperationSelector)) break;
                    httpBinding.setOperationSelector((OperationSelector)extension);
                }
            }
            if (event == 2 && HTTPBinding.TYPE.equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return httpBinding;
    }

    @Override
    public void write(HTTPBinding httpBinding, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, HTTPBinding.TYPE.getNamespaceURI(), HTTPBinding.TYPE.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        if (httpBinding.getName() != null) {
            writer.writeAttribute(NAME, httpBinding.getName());
        }
        if (httpBinding.getURI() != null) {
            writer.writeAttribute(URI, httpBinding.getURI());
        }
        this.writeEnd(writer);
    }

    @Override
    public void resolve(HTTPBinding model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }
}

