/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySubject;

public class SCABindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<SCABinding> {
    private static final String NAME = "name";
    private static final String URI = "uri";
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    private static final String BINDING_SCA = "binding.sca";
    private static final QName BINDING_SCA_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.sca");
    private PolicyFactory policyFactory;
    private SCABindingFactory scaBindingFactory;
    private PolicySubjectProcessor policyProcessor;
    private PolicyFactory intentAttachPointTypeFactory;

    public SCABindingProcessor(FactoryExtensionPoint modelFactories) {
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.scaBindingFactory = modelFactories.getFactory(SCABindingFactory.class);
        this.policyProcessor = new PolicySubjectProcessor(this.policyFactory);
        this.intentAttachPointTypeFactory = modelFactories.getFactory(PolicyFactory.class);
    }

    @Override
    public QName getArtifactType() {
        return BINDING_SCA_QNAME;
    }

    @Override
    public Class<SCABinding> getModelType() {
        return SCABinding.class;
    }

    @Override
    public SCABinding read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String uri;
        SCABinding scaBinding = this.scaBindingFactory.createSCABinding();
        BindingType bindingType = this.intentAttachPointTypeFactory.createBindingType();
        bindingType.setType(this.getArtifactType());
        bindingType.setUnresolved(true);
        ((PolicySubject)((Object)scaBinding)).setExtensionType(bindingType);
        this.policyProcessor.readPolicies(scaBinding, reader);
        String name = reader.getAttributeValue(null, NAME);
        if (name != null) {
            scaBinding.setName(name);
        }
        if ((uri = this.getURIString(reader, URI)) != null) {
            scaBinding.setURI(uri);
        }
        while (reader.hasNext() && (reader.next() != 2 || !BINDING_SCA_QNAME.equals(reader.getName()))) {
        }
        return scaBinding;
    }

    @Override
    public void resolve(SCABinding model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        this.policyProcessor.resolvePolicies(model, resolver, context);
    }

    @Override
    public void write(SCABinding scaBinding, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(SCA11_NS, BINDING_SCA);
        this.policyProcessor.writePolicyAttributes(scaBinding, writer);
        if (scaBinding.getName() != null) {
            writer.writeAttribute(NAME, scaBinding.getName());
        }
        if (scaBinding.getURI() != null) {
            writer.writeAttribute(URI, scaBinding.getURI());
        }
        writer.writeEndElement();
    }
}

