/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class EndpointProcessor
extends BaseAssemblyProcessor
implements StAXArtifactProcessor<Endpoint> {
    private static final String ENDPOINT = "endpoint";
    private static final QName ENDPOINT_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "endpoint");
    private ExtensionPointRegistry registry;

    public EndpointProcessor(ExtensionPointRegistry registry, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor) {
        super(EndpointProcessor.modelFactories(registry), extensionProcessor);
        this.registry = registry;
    }

    private static FactoryExtensionPoint modelFactories(ExtensionPointRegistry extensionPoints) {
        return extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
    }

    @Override
    public QName getArtifactType() {
        return ENDPOINT_QNAME;
    }

    @Override
    public Endpoint read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        Object model;
        Endpoint endpoint = this.assemblyFactory.createEndpoint();
        if (reader.getEventType() == 7) {
            reader.nextTag();
        }
        if ((model = this.extensionProcessor.read(reader, context)) instanceof Composite) {
            Composite composite = (Composite)model;
            Component component = composite.getComponents().get(0);
            ComponentService service = component.getServices().get(0);
            Binding binding = service.getBindings().get(0);
            endpoint.setComponent(component);
            endpoint.setService(service);
            endpoint.setBinding(binding);
        }
        return endpoint;
    }

    @Override
    public void write(Endpoint model, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.extensionProcessor.write(this.wrap(model), writer, context);
    }

    private Composite wrap(Endpoint endpoint) {
        try {
            Composite composite = this.assemblyFactory.createComposite();
            composite.setName(ENDPOINT_QNAME);
            composite.setLocal(false);
            if (endpoint.getComponent() != null) {
                Component component = (Component)endpoint.getComponent().clone();
                component.setImplementation(null);
                composite.getComponents().add(component);
                component.getReferences().clear();
                component.getServices().clear();
                if (endpoint.getService() != null) {
                    ComponentService service = (ComponentService)endpoint.getService().clone();
                    component.getServices().add(service);
                    service.getBindings().clear();
                    service.setInterfaceContract(endpoint.getComponentServiceInterfaceContract());
                    if (endpoint.getBinding() != null) {
                        Binding binding = (Binding)endpoint.getBinding().clone();
                        service.getBindings().add(binding);
                    }
                }
            }
            return composite;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public Class<Endpoint> getModelType() {
        return Endpoint.class;
    }

    @Override
    public void resolve(Endpoint model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }
}

