/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.Wire;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.common.xml.xpath.XPathHelper;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ResolverExtension;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.ImplementationType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompositeProcessor
extends BaseAssemblyProcessor
implements StAXArtifactProcessor<Composite> {
    private XPathHelper xpathHelper;
    private PolicyFactory intentAttachPointTypeFactory;
    private StAXAttributeProcessor<Object> extensionAttributeProcessor;
    private ContributionFactory contributionFactory;
    private XSDFactory xsdFactory;
    private StAXHelper staxHelper;

    public CompositeProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor) {
        this(CompositeProcessor.modelFactories(extensionPoints), extensionProcessor, extensionAttributeProcessor);
        this.xpathHelper = XPathHelper.getInstance(extensionPoints);
        this.extensionAttributeProcessor = extensionAttributeProcessor;
        this.xsdFactory = extensionPoints.getExtensionPoint(XSDFactory.class);
        this.staxHelper = StAXHelper.getInstance(extensionPoints);
    }

    private CompositeProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor) {
        super(modelFactories, extensionProcessor);
        this.intentAttachPointTypeFactory = modelFactories.getFactory(PolicyFactory.class);
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.extensionAttributeProcessor = extensionAttributeProcessor;
        this.xsdFactory = modelFactories.getFactory(XSDFactory.class);
    }

    @Override
    public Composite read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException {
        Composite composite = null;
        Composite include = null;
        Component component = null;
        Property property = null;
        ComponentService componentService = null;
        ComponentReference componentReference = null;
        ComponentProperty componentProperty = null;
        CompositeService compositeService = null;
        CompositeReference compositeReference = null;
        Contract contract = null;
        Wire wire = null;
        Callback callback = null;
        QName name = null;
        Monitor monitor = context.getMonitor();
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        Object extension;
                        Object source;
                        name = reader.getName();
                        if (Constants.COMPOSITE_QNAME.equals(name)) {
                            composite = this.assemblyFactory.createComposite();
                            composite.setSpecVersion("http://docs.oasis-open.org/ns/opencsa/sca/200912");
                            composite.setName(new QName(this.getURIString(reader, "targetNamespace"), this.getString(reader, "name")));
                            if (!this.isSet(reader, "targetNamespace")) {
                                this.warning(monitor, "NoCompositeNamespace", composite, composite.getName().toString());
                            }
                            if (this.isSet(reader, "autowire")) {
                                composite.setAutowire(this.getBoolean(reader, "autowire"));
                            }
                            this.readExtendedAttributes(reader, name, composite, this.extensionAttributeProcessor, context);
                            composite.setLocal(this.getBoolean(reader, "local"));
                            this.policyProcessor.readPolicies(composite, reader);
                            break;
                        }
                        if (Constants.INCLUDE_QNAME.equals(name)) {
                            include = this.assemblyFactory.createComposite();
                            include.setName(this.getQName(reader, "name"));
                            include.setURI(this.getURIString(reader, "uri"));
                            include.setUnresolved(true);
                            composite.getIncludes().add(include);
                            break;
                        }
                        if (Constants.SERVICE_QNAME.equals(name)) {
                            if (component != null) {
                                componentService = this.assemblyFactory.createComponentService();
                                contract = componentService;
                                componentService.setName(this.getString(reader, "name"));
                                this.readExtendedAttributes(reader, name, componentService, this.extensionAttributeProcessor, context);
                                component.getServices().add(componentService);
                                this.policyProcessor.readPolicies(contract, reader);
                            } else {
                                compositeService = this.assemblyFactory.createCompositeService();
                                contract = compositeService;
                                compositeService.setName(this.getString(reader, "name"));
                                String promoted = this.getURIString(reader, "promote");
                                if (promoted != null) {
                                    String promotedServiceName;
                                    String promotedComponentName;
                                    int s = promoted.indexOf(47);
                                    if (s == -1) {
                                        promotedComponentName = promoted;
                                        promotedServiceName = null;
                                    } else {
                                        promotedComponentName = promoted.substring(0, s);
                                        promotedServiceName = promoted.substring(s + 1);
                                    }
                                    Component promotedComponent = this.assemblyFactory.createComponent();
                                    promotedComponent.setUnresolved(true);
                                    promotedComponent.setName(promotedComponentName);
                                    compositeService.setPromotedComponent(promotedComponent);
                                    ComponentService promotedService = this.assemblyFactory.createComponentService();
                                    promotedService.setUnresolved(true);
                                    promotedService.setName(promotedServiceName);
                                    compositeService.setPromotedService(promotedService);
                                }
                                this.readExtendedAttributes(reader, name, compositeService, this.extensionAttributeProcessor, context);
                                composite.getServices().add(compositeService);
                                this.policyProcessor.readPolicies(contract, reader);
                            }
                            context.setParentModel(contract);
                            break;
                        }
                        if (Constants.REFERENCE_QNAME.equals(name)) {
                            if (component != null) {
                                String nonOverridable;
                                componentReference = this.assemblyFactory.createComponentReference();
                                contract = componentReference;
                                componentReference.setName(this.getString(reader, "name"));
                                this.readMultiplicity(componentReference, reader);
                                if (this.isSet(reader, "autowire")) {
                                    componentReference.setAutowire(this.getBoolean(reader, "autowire"));
                                }
                                if ((nonOverridable = reader.getAttributeValue(null, "nonOverridable")) != null) {
                                    componentReference.setNonOverridable(Boolean.parseBoolean(nonOverridable));
                                }
                                this.readTargets(componentReference, reader);
                                componentReference.setWiredByImpl(this.getBoolean(reader, "wiredByImpl"));
                                this.readExtendedAttributes(reader, name, componentReference, this.extensionAttributeProcessor, context);
                                component.getReferences().add(componentReference);
                                this.policyProcessor.readPolicies(contract, reader);
                            } else {
                                compositeReference = this.assemblyFactory.createCompositeReference();
                                contract = compositeReference;
                                compositeReference.setName(this.getString(reader, "name"));
                                this.readMultiplicity(compositeReference, reader);
                                this.readTargets(compositeReference, reader);
                                String promote = this.getString(reader, "promote");
                                if (promote != null) {
                                    StringTokenizer tokens = new StringTokenizer(promote);
                                    while (tokens.hasMoreTokens()) {
                                        String refName = tokens.nextToken();
                                        Component promotedComponent = this.assemblyFactory.createComponent();
                                        int index = refName.indexOf(47);
                                        if (index == -1) {
                                            this.error(monitor, "Invalid reference name", (Object)compositeReference, refName);
                                        }
                                        String promotedComponentName = refName.substring(0, index);
                                        promotedComponent.setName(promotedComponentName);
                                        promotedComponent.setUnresolved(true);
                                        compositeReference.getPromotedComponents().add(promotedComponent);
                                        ComponentReference promotedReference = this.assemblyFactory.createComponentReference();
                                        promotedReference.setUnresolved(true);
                                        promotedReference.setName(refName);
                                        compositeReference.getPromotedReferences().add(promotedReference);
                                    }
                                }
                                compositeReference.setWiredByImpl(this.getBoolean(reader, "wiredByImpl"));
                                this.readExtendedAttributes(reader, name, compositeReference, this.extensionAttributeProcessor, context);
                                composite.getReferences().add(compositeReference);
                                this.policyProcessor.readPolicies(contract, reader);
                            }
                            context.setParentModel(contract);
                            break;
                        }
                        if (Constants.PROPERTY_QNAME.equals(name)) {
                            if (component != null) {
                                componentProperty = this.assemblyFactory.createComponentProperty();
                                property = componentProperty;
                                source = this.getURIString(reader, "source");
                                if (source != null) {
                                    source = ((String)source).trim();
                                }
                                componentProperty.setSource((String)source);
                                if (source != null) {
                                    String xPath = this.prepareSourceXPathString((String)source);
                                    try {
                                        componentProperty.setSourceXPathExpression(this.xpathHelper.compile(reader.getNamespaceContext(), xPath));
                                    }
                                    catch (XPathExpressionException e) {
                                        ContributionReadException ce = new ContributionReadException(e);
                                        this.error(monitor, "ContributionReadException", source, ce);
                                    }
                                }
                                componentProperty.setFile(this.getURIString(reader, "file"));
                                this.readExtendedAttributes(reader, name, componentProperty, this.extensionAttributeProcessor, context);
                                this.policyProcessor.readPolicies(property, reader);
                                this.readAbstractProperty(componentProperty, reader, context);
                                Document value = this.readPropertyValue(property.getXSDElement(), property.getXSDType(), property.isMany(), reader, context);
                                property.setValue(value);
                                component.getProperties().add(componentProperty);
                            } else {
                                property = this.assemblyFactory.createProperty();
                                this.policyProcessor.readPolicies(property, reader);
                                this.readAbstractProperty(property, reader, context);
                                Document value = this.readPropertyValue(property.getXSDElement(), property.getXSDType(), property.isMany(), reader, context);
                                property.setValue(value);
                                composite.getProperties().add(property);
                            }
                            if (reader.getEventType() != 2 || !Constants.PROPERTY_QNAME.equals(reader.getName())) break;
                            property = null;
                            componentProperty = null;
                            break;
                        }
                        if (Constants.COMPONENT_QNAME.equals(name)) {
                            component = this.assemblyFactory.createComponent();
                            component.setName(this.getString(reader, "name"));
                            if (this.isSet(reader, "autowire")) {
                                component.setAutowire(this.getBoolean(reader, "autowire"));
                            }
                            if (this.isSet(reader, "uri")) {
                                component.setURI(this.getURIString(reader, "uri"));
                            }
                            this.readExtendedAttributes(reader, name, component, this.extensionAttributeProcessor, context);
                            composite.getComponents().add(component);
                            this.policyProcessor.readPolicies(component, reader);
                            break;
                        }
                        if (Constants.WIRE_QNAME.equals(name)) {
                            wire = this.assemblyFactory.createWire();
                            source = this.assemblyFactory.createComponentReference();
                            source.setUnresolved(true);
                            source.setName(this.getURIString(reader, "source"));
                            wire.setSource((ComponentReference)source);
                            ComponentService target = this.assemblyFactory.createComponentService();
                            target.setUnresolved(true);
                            target.setName(this.getURIString(reader, "target"));
                            wire.setTarget(target);
                            String replace = reader.getAttributeValue(null, "replace");
                            if (replace != null) {
                                wire.setReplace(Boolean.parseBoolean(replace));
                            }
                            this.readExtendedAttributes(reader, name, wire, this.extensionAttributeProcessor, context);
                            composite.getWires().add(wire);
                            this.policyProcessor.readPolicies(wire, reader);
                            break;
                        }
                        if (Constants.CALLBACK_QNAME.equals(name)) {
                            callback = this.assemblyFactory.createCallback();
                            contract.setCallback(callback);
                            callback.setParentContract(contract);
                            this.readExtendedAttributes(reader, name, callback, this.extensionAttributeProcessor, context);
                            this.policyProcessor.readPolicies(callback, reader);
                            context.setParentModel(callback);
                            break;
                        }
                        if (Constants.IMPLEMENTATION_COMPOSITE_QNAME.equals(name)) {
                            Composite implementation = this.assemblyFactory.createComposite();
                            implementation.setName(this.getQName(reader, "name"));
                            implementation.setUnresolved(true);
                            this.readExtendedAttributes(reader, name, implementation, this.extensionAttributeProcessor, context);
                            component.setImplementation(implementation);
                            this.policyProcessor.readPolicies(implementation, reader);
                            break;
                        }
                        if (Constants.REQUIRES_QNAME.equals(name)) {
                            List<QName> intents = this.getQNames(reader, "intents");
                            for (QName i : intents) {
                                Intent intent = this.policyFactory.createIntent();
                                intent.setName(i);
                                if (composite != null) {
                                    composite.getRequiredIntents().add(intent);
                                    continue;
                                }
                                if (component != null) {
                                    component.getRequiredIntents().add(intent);
                                    continue;
                                }
                                if (contract != null) {
                                    contract.getRequiredIntents().add(intent);
                                    continue;
                                }
                                if (callback == null) continue;
                                callback.getRequiredIntents().add(intent);
                            }
                            break;
                        }
                        if (Constants.POLICY_SET_ATTACHMENT_QNAME.equals(name)) {
                            QName ps = this.getQName(reader, "name");
                            if (ps == null) break;
                            PolicySet policySet = this.policyFactory.createPolicySet();
                            policySet.setName(ps);
                            if (composite != null) {
                                composite.getPolicySets().add(policySet);
                                break;
                            }
                            if (component != null) {
                                component.getPolicySets().add(policySet);
                                break;
                            }
                            if (contract != null) {
                                contract.getPolicySets().add(policySet);
                                break;
                            }
                            if (callback == null) break;
                            callback.getPolicySets().add(policySet);
                            break;
                        }
                        if (Constants.EXTENSION_QNAME.equals(name) || (extension = this.extensionProcessor.read(reader, context)) == null) break;
                        if (extension instanceof InterfaceContract) {
                            if (contract != null) {
                                contract.setInterfaceContract((InterfaceContract)extension);
                                break;
                            }
                            if (name.getNamespaceURI().equals("http://docs.oasis-open.org/ns/opencsa/sca/200912")) {
                                this.error(monitor, "UnexpectedInterfaceElement", extension, new Object[0]);
                                break;
                            }
                            composite.getExtensions().add(extension);
                            break;
                        }
                        if (extension instanceof Binding) {
                            if (extension instanceof PolicySubject) {
                                BindingType bindingType = this.intentAttachPointTypeFactory.createBindingType();
                                bindingType.setType(name);
                                bindingType.setUnresolved(true);
                                ((PolicySubject)extension).setExtensionType(bindingType);
                            }
                            if (callback != null) {
                                callback.getBindings().add((Binding)extension);
                                break;
                            }
                            if (contract != null) {
                                contract.getBindings().add((Binding)extension);
                                break;
                            }
                            if (name.getNamespaceURI().equals("http://docs.oasis-open.org/ns/opencsa/sca/200912")) {
                                this.error(monitor, "UnexpectedBindingElement", extension, new Object[0]);
                                break;
                            }
                            composite.getExtensions().add(extension);
                            break;
                        }
                        if (extension instanceof Implementation) {
                            if (extension instanceof PolicySubject) {
                                ImplementationType implType = this.intentAttachPointTypeFactory.createImplementationType();
                                implType.setType(name);
                                implType.setUnresolved(true);
                                ((PolicySubject)extension).setExtensionType(implType);
                            }
                            if (component != null) {
                                component.setImplementation((Implementation)extension);
                                break;
                            }
                            if (name.getNamespaceURI().equals("http://docs.oasis-open.org/ns/opencsa/sca/200912")) {
                                this.error(monitor, "UnexpectedImplementationElement", extension, new Object[0]);
                                break;
                            }
                            composite.getExtensions().add(extension);
                            break;
                        }
                        if (callback != null) {
                            callback.getExtensions().add(extension);
                            break;
                        }
                        if (contract != null) {
                            contract.getExtensions().add(extension);
                            break;
                        }
                        if (property != null) {
                            property.getExtensions().add(extension);
                            break;
                        }
                        if (component != null) {
                            component.getExtensions().add(extension);
                            break;
                        }
                        composite.getExtensions().add(extension);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        name = reader.getName();
                        if (Constants.SERVICE_QNAME.equals(name)) {
                            componentService = null;
                            compositeService = null;
                            contract = null;
                            break;
                        }
                        if (Constants.INCLUDE_QNAME.equals(name)) {
                            include = null;
                            break;
                        }
                        if (Constants.REFERENCE_QNAME.equals(name)) {
                            componentReference = null;
                            compositeReference = null;
                            contract = null;
                            break;
                        }
                        if (Constants.PROPERTY_QNAME.equals(name)) {
                            componentProperty = null;
                            property = null;
                            break;
                        }
                        if (Constants.COMPONENT_QNAME.equals(name)) {
                            component = null;
                            break;
                        }
                        if (Constants.WIRE_QNAME.equals(name)) {
                            wire = null;
                            break;
                        }
                        if (!Constants.CALLBACK_QNAME.equals(name)) break;
                        callback = null;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error(monitor, "XMLStreamException", (Object)reader, ex);
        }
        return composite;
    }

    private String prepareSourceXPathString(String source) {
        String output = null;
        if (source.charAt(0) != '$') {
            return output;
        }
        int slash = source.indexOf(47);
        int bracket = source.indexOf(91);
        if (slash == -1) {
            output = "*";
            if (bracket != -1) {
                output = "*" + source.substring(bracket);
            }
        } else {
            output = "*/" + source.substring(slash + 1);
            if (bracket != -1 && bracket < slash) {
                output = "*" + source.substring(bracket);
            }
        }
        return output;
    }

    @Override
    public void write(Composite composite, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStartDocument(writer, "composite", new BaseStAXArtifactProcessor.XAttr("targetNamespace", composite.getName().getNamespaceURI()), new BaseStAXArtifactProcessor.XAttr("name", composite.getName().getLocalPart()), new BaseStAXArtifactProcessor.XAttr("local", composite.isLocal() ? Boolean.TRUE : null), new BaseStAXArtifactProcessor.XAttr("autowire", composite.getAutowire()), this.policyProcessor.writePolicies(composite));
        this.writeExtendedAttributes(writer, composite, this.extensionAttributeProcessor, context);
        for (Composite include : composite.getIncludes()) {
            String uri = include.isUnresolved() ? include.getURI() : null;
            this.writeStart(writer, "include", new BaseStAXArtifactProcessor.XAttr("name", include.getName()), new BaseStAXArtifactProcessor.XAttr("uri", uri));
            this.writeExtendedAttributes(writer, include, this.extensionAttributeProcessor, context);
            this.writeEnd(writer);
        }
        for (Service service : composite.getServices()) {
            CompositeService compositeService = (CompositeService)service;
            Component promotedComponent = compositeService.getPromotedComponent();
            ComponentService promotedService = compositeService.getPromotedService();
            String promote = promotedService != null ? (promotedService.getName() != null ? promotedComponent.getName() + '/' + promotedService.getName() : promotedComponent.getName()) : null;
            this.writeStart(writer, "service", new BaseStAXArtifactProcessor.XAttr("name", service.getName()), new BaseStAXArtifactProcessor.XAttr("promote", promote), this.policyProcessor.writePolicies(service));
            this.writeExtendedAttributes(writer, service, this.extensionAttributeProcessor, context);
            this.extensionProcessor.write(service.getInterfaceContract(), writer, context);
            for (Binding binding : service.getBindings()) {
                this.extensionProcessor.write(binding, writer, context);
            }
            if (service.getCallback() != null) {
                Callback callback = service.getCallback();
                this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                this.writeExtendedAttributes(writer, callback, this.extensionAttributeProcessor, context);
                for (Binding binding : callback.getBindings()) {
                    this.extensionProcessor.write(binding, writer, context);
                }
                this.writeExtendedElements(writer, service, this.extensionProcessor, context);
                this.writeEnd(writer);
            }
            this.writeExtendedElements(writer, service, this.extensionProcessor, context);
            this.writeEnd(writer);
        }
        for (Component component : composite.getComponents()) {
            Callback callback;
            this.writeStart(writer, "component", new BaseStAXArtifactProcessor.XAttr("name", component.getName()), new BaseStAXArtifactProcessor.XAttr("uri", component.getURI()), new BaseStAXArtifactProcessor.XAttr("autowire", component.getAutowire()), this.policyProcessor.writePolicies(component));
            this.writeExtendedAttributes(writer, component, this.extensionAttributeProcessor, context);
            Implementation implementation = component.getImplementation();
            if (implementation instanceof Composite) {
                this.writeStart(writer, "implementation.composite", new BaseStAXArtifactProcessor.XAttr("name", ((Composite)implementation).getName()), this.policyProcessor.writePolicies(implementation));
                this.writeExtendedAttributes(writer, (Composite)implementation, this.extensionAttributeProcessor, context);
                this.writeEnd(writer);
            } else {
                this.extensionProcessor.write(component.getImplementation(), writer, context);
            }
            for (Object extension : component.getExtensions()) {
                this.extensionProcessor.write(extension, writer, context);
            }
            for (ComponentService service : component.getServices()) {
                this.writeStart(writer, "service", new BaseStAXArtifactProcessor.XAttr("name", service.getName()), this.policyProcessor.writePolicies(service));
                this.writeExtendedAttributes(writer, service, this.extensionAttributeProcessor, context);
                this.extensionProcessor.write(service.getInterfaceContract(), writer, context);
                for (Binding binding : service.getBindings()) {
                    this.extensionProcessor.write(binding, writer, context);
                }
                if (service.getCallback() != null) {
                    callback = service.getCallback();
                    this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                    this.writeExtendedAttributes(writer, callback, this.extensionAttributeProcessor, context);
                    for (Binding binding : callback.getBindings()) {
                        this.extensionProcessor.write(binding, writer, context);
                    }
                    this.writeExtendedElements(writer, callback, this.extensionProcessor, context);
                    this.writeEnd(writer);
                }
                this.writeExtendedElements(writer, service, this.extensionProcessor, context);
                this.writeEnd(writer);
            }
            for (ComponentReference reference : component.getReferences()) {
                this.writeStart(writer, "reference", new BaseStAXArtifactProcessor.XAttr("name", reference.getName()), new BaseStAXArtifactProcessor.XAttr("autowire", reference.getAutowire()), reference.isNonOverridable() ? new BaseStAXArtifactProcessor.XAttr("nonOverridable", true) : null, this.writeMultiplicity(reference), this.writeTargets(reference), this.policyProcessor.writePolicies(reference));
                this.writeExtendedAttributes(writer, reference, this.extensionAttributeProcessor, context);
                this.extensionProcessor.write(reference.getInterfaceContract(), writer, context);
                for (Binding binding : reference.getBindings()) {
                    this.extensionProcessor.write(binding, writer, context);
                }
                if (reference.getCallback() != null) {
                    callback = reference.getCallback();
                    this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                    this.writeExtendedAttributes(writer, callback, this.extensionAttributeProcessor, context);
                    for (Binding binding : callback.getBindings()) {
                        this.extensionProcessor.write(binding, writer, context);
                    }
                    this.writeExtendedElements(writer, callback, this.extensionProcessor, context);
                    this.writeEnd(writer);
                }
                this.writeExtendedElements(writer, reference, this.extensionProcessor, context);
                this.writeEnd(writer);
            }
            for (ComponentProperty property : component.getProperties()) {
                this.writeStart(writer, "property", new BaseStAXArtifactProcessor.XAttr("name", property.getName()), new BaseStAXArtifactProcessor.XAttr("mustSupply", property.isMustSupply()), new BaseStAXArtifactProcessor.XAttr("many", property.isMany()), new BaseStAXArtifactProcessor.XAttr("type", property.getXSDType()), new BaseStAXArtifactProcessor.XAttr("element", property.getXSDElement()), new BaseStAXArtifactProcessor.XAttr("source", property.getSource()), new BaseStAXArtifactProcessor.XAttr("file", property.getFile()), this.policyProcessor.writePolicies(property));
                this.writeExtendedAttributes(writer, property, this.extensionAttributeProcessor, context);
                this.writePropertyValue(property.getValue(), property.getXSDElement(), property.getXSDType(), writer);
                for (Object extension : property.getExtensions()) {
                    this.extensionProcessor.write(extension, writer, context);
                }
                this.writeEnd(writer);
            }
            this.writeEnd(writer);
        }
        for (Reference reference : composite.getReferences()) {
            CompositeReference compositeReference = (CompositeReference)reference;
            ArrayList<String> promote = new ArrayList<String>();
            for (ComponentReference promoted : compositeReference.getPromotedReferences()) {
                promote.add(promoted.getName());
            }
            this.writeStart(writer, "reference", new BaseStAXArtifactProcessor.XAttr("name", reference.getName()), new BaseStAXArtifactProcessor.XAttr("promote", promote), this.writeMultiplicity(reference), this.policyProcessor.writePolicies(reference));
            this.writeExtendedAttributes(writer, reference, this.extensionAttributeProcessor, context);
            this.extensionProcessor.write(reference.getInterfaceContract(), writer, context);
            for (Binding binding : reference.getBindings()) {
                this.extensionProcessor.write(binding, writer, context);
            }
            if (reference.getCallback() != null) {
                Callback callback = reference.getCallback();
                this.writeStart(writer, "callback", new BaseStAXArtifactProcessor.XAttr[0]);
                this.writeExtendedAttributes(writer, callback, this.extensionAttributeProcessor, context);
                for (Binding binding : callback.getBindings()) {
                    this.extensionProcessor.write(binding, writer, context);
                }
                this.writeExtendedElements(writer, callback, this.extensionProcessor, context);
                this.writeEnd(writer);
            }
            this.writeExtendedElements(writer, reference, this.extensionProcessor, context);
            this.writeEnd(writer);
        }
        for (Property property : composite.getProperties()) {
            this.writeStart(writer, "property", new BaseStAXArtifactProcessor.XAttr("name", property.getName()), new BaseStAXArtifactProcessor.XAttr("mustSupply", property.isMustSupply()), new BaseStAXArtifactProcessor.XAttr("many", property.isMany()), new BaseStAXArtifactProcessor.XAttr("type", property.getXSDType()), new BaseStAXArtifactProcessor.XAttr("element", property.getXSDElement()), this.policyProcessor.writePolicies(property));
            this.writeExtendedAttributes(writer, property, this.extensionAttributeProcessor, context);
            this.writePropertyValue(property.getValue(), property.getXSDElement(), property.getXSDType(), writer);
            for (Object extension : property.getExtensions()) {
                this.extensionProcessor.write(extension, writer, context);
            }
            this.writeEnd(writer);
        }
        for (Wire wire : composite.getWires()) {
            this.writeStart(writer, "wire", new BaseStAXArtifactProcessor.XAttr("source", wire.getSource().getName()), new BaseStAXArtifactProcessor.XAttr("target", wire.getTarget().getName()), wire.isReplace() ? new BaseStAXArtifactProcessor.XAttr("replace", true) : null);
            this.writeExtendedAttributes(writer, wire, this.extensionAttributeProcessor, context);
            for (Object extension : wire.getExtensions()) {
                this.extensionProcessor.write(extension, writer, context);
            }
            this.writeEnd(writer);
        }
        for (Object extension : composite.getExtensions()) {
            this.extensionProcessor.write(extension, writer, context);
        }
        this.writeEndDocument(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolve(Composite composite, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        Monitor monitor = context.getMonitor();
        try {
            monitor.pushContext("Composite: " + composite.getName());
            int n = composite.getIncludes().size();
            for (int i = 0; i < n; ++i) {
                ContributionResolveException ce;
                Composite include = composite.getIncludes().get(i);
                if (include == null) continue;
                Composite resolved = resolver.resolveModel(Composite.class, include, context);
                if (!resolved.isUnresolved()) {
                    if (composite.isLocal() && resolved.isLocal() || !composite.isLocal() && !resolved.isLocal()) {
                        composite.getIncludes().set(i, resolved);
                        continue;
                    }
                    ce = new ContributionResolveException("[ASM60041] Error: Composite " + composite.getName() + " can only include another composite with the identical @local attribute value");
                    this.error(monitor, "ContributionResolveException", (Object)include, ce);
                    continue;
                }
                ce = new ContributionResolveException("[ASM60042] Error: Composite " + include.getName() + " is not a valid composite within the domain");
                this.error(monitor, "ContributionResolveException", (Object)include, ce);
            }
            for (Object extension : composite.getExtensions()) {
                if (extension == null) continue;
                this.extensionProcessor.resolve(extension, resolver, context);
            }
            this.resolveContracts(composite, composite.getServices(), resolver, context);
            this.resolveContracts(composite, composite.getReferences(), resolver, context);
            for (Property property : composite.getProperties()) {
                this.resolvePropertyType("composite " + composite.getName().toString(), property, context.getContribution(), context);
            }
            for (Component component : composite.getComponents()) {
                this.resolveContracts(component, component.getServices(), resolver, context);
                this.resolveContracts(component, component.getReferences(), resolver, context);
                for (ComponentProperty componentProperty : component.getProperties()) {
                    if (componentProperty.getFile() != null) {
                        Artifact artifact = this.contributionFactory.createArtifact();
                        artifact.setURI(componentProperty.getFile());
                        artifact = resolver.resolveModel(Artifact.class, artifact, context);
                        if (artifact.getLocation() != null) {
                            componentProperty.setFile(artifact.getLocation());
                        }
                    }
                    this.resolvePropertyType("component " + component.getName(), componentProperty, context.getContribution(), context);
                }
                Implementation implementation = component.getImplementation();
                if (implementation != null) {
                    ArrayList<PolicySet> policySets = new ArrayList<PolicySet>(implementation.getPolicySets());
                    ArrayList<Intent> intents = new ArrayList<Intent>(implementation.getRequiredIntents());
                    implementation = this.resolveImplementation(implementation, resolver, context);
                    if (!policySets.isEmpty() || !component.getPolicySets().isEmpty()) {
                        implementation.getPolicySets().clear();
                        implementation.getPolicySets().addAll(policySets);
                    }
                    implementation.getRequiredIntents().addAll(intents);
                    component.setImplementation(implementation);
                }
                if (!(component instanceof ResolverExtension)) continue;
                ((ResolverExtension)((Object)component)).setModelResolver(resolver);
            }
            for (Service service : composite.getServices()) {
                CompositeService compositeService = (CompositeService)service;
                Component promotedComponent = compositeService.getPromotedComponent();
                if (!(promotedComponent instanceof ResolverExtension)) continue;
                ((ResolverExtension)((Object)promotedComponent)).setModelResolver(resolver);
            }
        }
        finally {
            monitor.popContext();
        }
    }

    @Override
    public QName getArtifactType() {
        return Constants.COMPOSITE_QNAME;
    }

    @Override
    public Class<Composite> getModelType() {
        return Composite.class;
    }

    protected void writePropertyValue(Object propertyValue, QName element, QName type, XMLStreamWriter writer) throws XMLStreamException {
        if (propertyValue instanceof Document) {
            Document document = (Document)propertyValue;
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int item = 0; item < nodeList.getLength(); ++item) {
                Node node = nodeList.item(item);
                short nodeType = node.getNodeType();
                if (nodeType == 1) {
                    XMLStreamReader reader = this.staxHelper.createXMLStreamReader(node);
                    block7: while (reader.hasNext()) {
                        switch (reader.next()) {
                            case 1: {
                                int i;
                                QName name = reader.getName();
                                writer.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
                                int namespaces = reader.getNamespaceCount();
                                boolean elementNamespaceAdded = false;
                                for (i = 0; i < namespaces; ++i) {
                                    String prefix = reader.getNamespacePrefix(i);
                                    String ns = reader.getNamespaceURI(i);
                                    writer.writeNamespace(prefix, ns);
                                    if (!ns.equals(name.getNamespaceURI())) continue;
                                    elementNamespaceAdded = true;
                                }
                                if (!"".equals(name.getNamespaceURI()) && !elementNamespaceAdded) {
                                    writer.writeNamespace(name.getPrefix(), name.getNamespaceURI());
                                }
                                namespaces = reader.getAttributeCount();
                                for (i = 0; i < namespaces; ++i) {
                                    String ns = reader.getAttributeNamespace(i);
                                    String prefix = reader.getAttributePrefix(i);
                                    String qname = reader.getAttributeLocalName(i);
                                    String value = reader.getAttributeValue(i);
                                    writer.writeAttribute(prefix, ns, qname, value);
                                }
                                continue block7;
                            }
                            case 12: {
                                writer.writeCData(reader.getText());
                                break;
                            }
                            case 4: {
                                writer.writeCharacters(reader.getText());
                                break;
                            }
                            case 2: {
                                writer.writeEndElement();
                            }
                        }
                    }
                    continue;
                }
                writer.writeCharacters(node.getTextContent());
            }
        }
    }

    private static FactoryExtensionPoint modelFactories(ExtensionPointRegistry extensionPoints) {
        return extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
    }

    private void resolvePropertyType(String parentName, Property property, Contribution contribution, ProcessorContext context) {
        if (property.getXSDType() != null && !property.getXSDType().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            XSDefinition xsdDefinition = this.xsdFactory.createXSDefinition();
            xsdDefinition.setUnresolved(true);
            xsdDefinition.setNamespace(property.getXSDType().getNamespaceURI());
            if (contribution != null && contribution.getModelResolver() != null) {
                XSDefinition resolved = contribution.getModelResolver().resolveModel(XSDefinition.class, xsdDefinition, context);
                if (resolved == null || resolved.isUnresolved()) {
                    this.warning(context.getMonitor(), "PropertyTypeNotFound", property, property.getXSDType().toString(), property.getName(), parentName);
                } else {
                    property.setXSDDefinition(resolved);
                }
            }
        }
    }
}

