/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.AbstractProperty;
import org.apache.tuscany.sca.assembly.AbstractReference;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Base;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class BaseAssemblyProcessor
extends BaseStAXArtifactProcessor {
    protected AssemblyFactory assemblyFactory;
    protected PolicyFactory policyFactory;
    protected StAXArtifactProcessor<Object> extensionProcessor;
    protected PolicySubjectProcessor policyProcessor;
    private DocumentBuilderFactory documentBuilderFactory;

    protected BaseAssemblyProcessor(AssemblyFactory assemblyFactory, PolicyFactory policyFactory, DocumentBuilderFactory documentBuilderFactory, StAXArtifactProcessor extensionProcessor) {
        this.assemblyFactory = assemblyFactory;
        this.policyFactory = policyFactory;
        this.documentBuilderFactory = documentBuilderFactory;
        this.extensionProcessor = extensionProcessor;
        this.policyProcessor = new PolicySubjectProcessor(policyFactory);
    }

    protected BaseAssemblyProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor staxProcessor) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.documentBuilderFactory = modelFactories.getFactory(DocumentBuilderFactory.class);
        this.extensionProcessor = staxProcessor;
        this.policyProcessor = new PolicySubjectProcessor(this.policyFactory);
    }

    protected void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "org.apache.tuscany.sca.assembly.xml.assembly-xml-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    protected void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "org.apache.tuscany.sca.assembly.xml.assembly-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    protected void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "org.apache.tuscany.sca.assembly.xml.assembly-xml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }

    protected void writeStart(XMLStreamWriter writer, String name, BaseStAXArtifactProcessor.XAttr ... attrs) throws XMLStreamException {
        super.writeStart(writer, "http://docs.oasis-open.org/ns/opencsa/sca/200912", name, attrs);
    }

    protected void writeStartDocument(XMLStreamWriter writer, String name, BaseStAXArtifactProcessor.XAttr ... attrs) throws XMLStreamException {
        super.writeStartDocument(writer, "http://docs.oasis-open.org/ns/opencsa/sca/200912", name, attrs);
    }

    protected void readTargets(Reference reference, XMLStreamReader reader) {
        String value = this.getString(reader, "target");
        ComponentService target = null;
        if (value != null) {
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                target = this.assemblyFactory.createComponentService();
                target.setUnresolved(true);
                target.setName(tokens.nextToken());
                reference.getTargets().add(target);
            }
        }
    }

    protected BaseStAXArtifactProcessor.XAttr writeTargets(Reference reference) {
        ArrayList<String> targets = new ArrayList<String>();
        for (ComponentService target : reference.getTargets()) {
            targets.add(target.getName());
        }
        return new BaseStAXArtifactProcessor.XAttr("target", targets);
    }

    protected void readMultiplicity(AbstractReference reference, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "multiplicity");
        if ("0..1".equals(value)) {
            reference.setMultiplicity(Multiplicity.ZERO_ONE);
        } else if ("1..n".equals(value)) {
            reference.setMultiplicity(Multiplicity.ONE_N);
        } else if ("0..n".equals(value)) {
            reference.setMultiplicity(Multiplicity.ZERO_N);
        } else if ("1..1".equals(value)) {
            reference.setMultiplicity(Multiplicity.ONE_ONE);
        }
    }

    protected BaseStAXArtifactProcessor.XAttr writeMultiplicity(AbstractReference reference) {
        Multiplicity multiplicity = reference.getMultiplicity();
        if (multiplicity != null) {
            String value = null;
            if (Multiplicity.ZERO_ONE.equals((Object)multiplicity)) {
                value = "0..1";
            } else if (Multiplicity.ONE_N.equals((Object)multiplicity)) {
                value = "1..n";
            } else if (Multiplicity.ZERO_N.equals((Object)multiplicity)) {
                value = "0..n";
            } else if (Multiplicity.ONE_ONE.equals((Object)multiplicity)) {
                value = "1..1";
                return null;
            }
            return new BaseStAXArtifactProcessor.XAttr("multiplicity", value);
        }
        return null;
    }

    protected void readAbstractProperty(AbstractProperty property, XMLStreamReader reader, ProcessorContext context) throws XMLStreamException, ContributionReadException {
        property.setName(this.getString(reader, "name"));
        property.setMany(this.getBoolean(reader, "many"));
        property.setMustSupply(this.getBoolean(reader, "mustSupply"));
        property.setXSDElement(this.getQName(reader, "element"));
        property.setXSDType(this.getQName(reader, "type"));
        if (property.getXSDElement() != null && property.getXSDType() != null) {
            ContributionReadException ce = new ContributionReadException("[ASM40010,ASM60040] Error: property has both @type and @element attribute values - " + property.getName());
            this.error(context.getMonitor(), "ContributionReadException", (Object)property, ce);
        }
    }

    protected Implementation resolveImplementation(Implementation implementation, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (implementation != null && implementation.isUnresolved() && (implementation = resolver.resolveModel(Implementation.class, implementation, context)).isUnresolved()) {
            this.extensionProcessor.resolve(implementation, resolver, context);
            if (!implementation.isUnresolved()) {
                resolver.addModel(implementation, context);
            }
        }
        return implementation;
    }

    protected <C extends Contract> void resolveContracts(List<C> contracts, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        this.resolveContracts(null, contracts, resolver, context);
    }

    protected <C extends Contract> void resolveContracts(Base parent, List<C> contracts, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        String parentName = parent instanceof Composite ? ((Composite)parent).getName().toString() : (parent instanceof Component ? ((Component)parent).getName() : "UNKNOWN");
        for (Contract contract : contracts) {
            Binding binding;
            int i;
            InterfaceContract interfaceContract = contract.getInterfaceContract();
            if (interfaceContract != null) {
                this.extensionProcessor.resolve(interfaceContract, resolver, context);
            }
            int n = contract.getBindings().size();
            for (i = 0; i < n; ++i) {
                binding = contract.getBindings().get(i);
                this.extensionProcessor.resolve(binding, resolver, context);
            }
            if (contract.getCallback() == null) continue;
            n = contract.getCallback().getBindings().size();
            for (i = 0; i < n; ++i) {
                binding = contract.getCallback().getBindings().get(i);
                this.extensionProcessor.resolve(binding, resolver, context);
            }
        }
    }

    protected <C extends AbstractContract> void resolveAbstractContracts(List<C> contracts, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        for (AbstractContract contract : contracts) {
            InterfaceContract interfaceContract = contract.getInterfaceContract();
            if (interfaceContract == null) continue;
            this.extensionProcessor.resolve(interfaceContract, resolver, context);
        }
    }

    protected Document readPropertyValue(QName element, QName type, boolean isMany, XMLStreamReader reader, ProcessorContext context) throws XMLStreamException, ContributionReadException {
        Document document;
        try {
            if (this.documentBuilderFactory == null) {
                this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
                this.documentBuilderFactory.setNamespaceAware(true);
            }
            document = this.documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error(context.getMonitor(), "ContributionReadException", (Object)this.documentBuilderFactory, ce);
            throw ce;
        }
        Element root = document.createElementNS("http://docs.oasis-open.org/ns/opencsa/sca/200912", "sca:property");
        String nameAttr = this.getString(reader, "name");
        if (nameAttr != null) {
            root.setAttributeNS("http://docs.oasis-open.org/ns/opencsa/sca/200912", "sca:name", nameAttr);
        }
        this.declareNamespace(root, "sca", "http://docs.oasis-open.org/ns/opencsa/sca/200912");
        if (type != null) {
            Attr xsi = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi");
            xsi.setValue("http://www.w3.org/2001/XMLSchema-instance");
            root.setAttributeNodeNS(xsi);
            String prefix = type.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                prefix = "ns";
            }
            this.declareNamespace(root, prefix, type.getNamespaceURI());
            Attr xsiType = document.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type");
            xsiType.setValue(prefix + ":" + type.getLocalPart());
            root.setAttributeNodeNS(xsiType);
        }
        document.appendChild(root);
        QName name = reader.getName();
        String valueAttr = this.getString(reader, "value");
        if (valueAttr != null) {
            Element valueElement = document.createElementNS("http://docs.oasis-open.org/ns/opencsa/sca/200912", "value");
            root.appendChild(valueElement);
            valueElement.setTextContent(valueAttr);
        }
        boolean gotOneValue = false;
        boolean isTextForProperty = true;
        StringBuffer text = new StringBuffer();
        int event = reader.getEventType();
        while (true) {
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (Constants.PROPERTY_QNAME.equals(name)) {
                        isTextForProperty = true;
                        break;
                    }
                    isTextForProperty = false;
                    if (valueAttr != null) {
                        this.error(context.getMonitor(), "ASM50033: value attribute exists for the property element", (Object)name, name);
                    }
                    if (Constants.VALUE_QNAME.equals(name)) {
                        if (!gotOneValue || !isMany) {
                            // empty if block
                        }
                        this.loadElement(reader, root);
                        gotOneValue = true;
                        break;
                    }
                    this.loadElement(reader, root);
                    break;
                }
                case 4: 
                case 12: {
                    if (!isTextForProperty) break;
                    text.append(reader.getText());
                    break;
                }
                case 2: {
                    name = reader.getName();
                    if (!Constants.PROPERTY_QNAME.equals(name)) break;
                    if (root.getChildNodes().getLength() == 0 && isTextForProperty && text.length() > 0) {
                        Element valueElement = document.createElementNS("http://docs.oasis-open.org/ns/opencsa/sca/200912", "value");
                        root.appendChild(valueElement);
                        valueElement.setTextContent(text.toString());
                    }
                    return document;
                }
            }
            if (!reader.hasNext()) break;
            event = reader.next();
        }
        return document;
    }

    private Element createElement(Document document, QName name) {
        String prefix = name.getPrefix();
        String qname = prefix != null && prefix.length() > 0 ? prefix + ":" + name.getLocalPart() : name.getLocalPart();
        return document.createElementNS(name.getNamespaceURI(), qname);
    }

    private void declareNamespace(Element element, String prefix, String ns) {
        NamedNodeMap attrs;
        if (ns == null) {
            ns = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        String qname = null;
        qname = "".equals(prefix) ? "xmlns" : "xmlns:" + prefix;
        boolean declared = false;
        for (Node node = element; node != null && node.getNodeType() == 1 && (attrs = node.getAttributes()) != null; node = node.getParentNode()) {
            Node attr = attrs.getNamedItem(qname);
            if (attr == null) continue;
            declared = ns.equals(attr.getNodeValue());
            break;
        }
        if (!declared) {
            Attr attr = element.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", qname);
            attr.setValue(ns);
            element.setAttributeNodeNS(attr);
        }
    }

    private void loadElement(XMLStreamReader reader, Element root) throws XMLStreamException {
        Document document = root.getOwnerDocument();
        Node current = root;
        while (true) {
            switch (reader.getEventType()) {
                case 1: {
                    int i;
                    QName name = reader.getName();
                    Element child = this.createElement(document, name);
                    current.appendChild(child);
                    current = child;
                    int count = reader.getNamespaceCount();
                    for (i = 0; i < count; ++i) {
                        String prefix = reader.getNamespacePrefix(i);
                        String ns = reader.getNamespaceURI(i);
                        this.declareNamespace(child, prefix, ns);
                    }
                    if (!"".equals(name.getNamespaceURI())) {
                        this.declareNamespace(child, name.getPrefix(), name.getNamespaceURI());
                    }
                    count = reader.getAttributeCount();
                    for (i = 0; i < count; ++i) {
                        String ns = reader.getAttributeNamespace(i);
                        String prefix = reader.getAttributePrefix(i);
                        String qname = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (prefix != null && prefix.length() != 0) {
                            qname = prefix + ":" + qname;
                        }
                        child.setAttributeNS(ns, qname, value);
                        if (ns == null) continue;
                        this.declareNamespace(child, prefix, ns);
                    }
                    break;
                }
                case 12: {
                    current.appendChild(document.createCDATASection(reader.getText()));
                    break;
                }
                case 4: {
                    current.appendChild(document.createTextNode(reader.getText()));
                    break;
                }
                case 5: {
                    current.appendChild(document.createComment(reader.getText()));
                    break;
                }
                case 2: {
                    current = current.getParentNode();
                    if (current != root) break;
                    return;
                }
            }
            if (!reader.hasNext()) break;
            reader.next();
        }
    }

    protected void readExtendedAttributes(XMLStreamReader reader, QName elementName, Extensible extensible, StAXAttributeProcessor extensionAttributeProcessor, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        super.readExtendedAttributes(reader, extensible, extensionAttributeProcessor, this.assemblyFactory, context);
    }
}

