/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.builder.ContractBuilder;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;

public class EndpointReferenceImpl
implements EndpointReference {
    private static final long serialVersionUID = 8838066441709300972L;
    protected transient ExtensionPointRegistry registry;
    protected transient BuilderExtensionPoint builders;
    protected transient ContractBuilder contractBuilder;
    protected boolean unresolved = true;
    protected String uri;
    protected Component component;
    protected ComponentReference reference;
    protected Binding binding;
    protected List<PolicySet> policySets = new ArrayList<PolicySet>();
    protected List<Intent> requiredIntents = new ArrayList<Intent>();
    protected InterfaceContract interfaceContract;
    protected EndpointReference.Status status = EndpointReference.Status.NOT_CONFIGURED;
    protected Endpoint targetEndpoint;
    protected Endpoint callbackEndpoint;

    protected EndpointReferenceImpl(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EndpointReference cloned = (EndpointReference)super.clone();
        if (this.targetEndpoint != null) {
            cloned.setTargetEndpoint((Endpoint)this.targetEndpoint.clone());
        }
        return cloned;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean unresolved) {
        this.unresolved = unresolved;
    }

    @Override
    public Component getComponent() {
        this.resolve();
        return this.component;
    }

    @Override
    public void setComponent(Component component) {
        this.component = component;
        this.reset();
    }

    @Override
    public ComponentReference getReference() {
        this.resolve();
        return this.reference;
    }

    @Override
    public void setReference(ComponentReference reference) {
        this.reference = reference;
        this.reset();
    }

    @Override
    public Binding getBinding() {
        this.resolve();
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
        this.reset();
    }

    @Override
    public Endpoint getTargetEndpoint() {
        this.resolve();
        return this.targetEndpoint;
    }

    @Override
    public void setTargetEndpoint(Endpoint targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
        this.reset();
    }

    @Override
    public InterfaceContract getComponentReferenceInterfaceContract() {
        this.resolve();
        if (this.interfaceContract == null && this.reference != null) {
            this.interfaceContract = this.reference.getInterfaceContract();
        }
        return this.interfaceContract;
    }

    public void setInterfaceContract(InterfaceContract interfaceContract) {
        this.interfaceContract = interfaceContract;
        this.reset();
    }

    @Override
    public List<PolicySet> getPolicySets() {
        this.resolve();
        return this.policySets;
    }

    @Override
    public List<Intent> getRequiredIntents() {
        this.resolve();
        return this.requiredIntents;
    }

    @Override
    public ExtensionType getExtensionType() {
        this.getBinding();
        if (this.binding instanceof PolicySubject) {
            return ((PolicySubject)((Object)this.binding)).getExtensionType();
        }
        return null;
    }

    @Override
    public void setExtensionType(ExtensionType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Endpoint getCallbackEndpoint() {
        this.resolve();
        return this.callbackEndpoint;
    }

    @Override
    public void setCallbackEndpoint(Endpoint callbackEndpoint) {
        this.callbackEndpoint = callbackEndpoint;
        this.reset();
    }

    public String toStringWithoutHash() {
        StringBuffer output = new StringBuffer("EndpointReference: ");
        if (this.getURI() != null) {
            output.append(" URI = ").append(this.getURI());
        }
        output.append(" ").append((Object)this.status);
        if (this.targetEndpoint != null) {
            output.append(" Target = ").append(this.targetEndpoint);
        }
        return output.toString();
    }

    public String toString() {
        return "(@" + this.hashCode() + ")" + this.toStringWithoutHash();
    }

    @Override
    public String getURI() {
        if (this.uri == null) {
            if (this.component != null && this.reference != null && this.binding != null) {
                String bindingName = this.binding.getName();
                if (bindingName == null) {
                    bindingName = this.reference.getName();
                }
                this.uri = this.component.getURI() + "#reference-binding(" + this.reference.getName() + "/" + bindingName + ")";
            } else if (this.component != null && this.reference != null) {
                this.uri = this.component.getURI() + "#reference(" + this.reference.getName() + ")";
            } else if (this.component != null) {
                this.uri = this.component.getURI();
            }
        }
        return this.uri;
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    protected void resolve() {
    }

    protected void reset() {
        this.uri = null;
    }

    public void setExtensionPointRegistry(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public EndpointReference.Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EndpointReference.Status status) {
        this.status = status;
    }

    @Override
    public boolean isAsyncInvocation() {
        if (this.reference != null && this.reference.getName().endsWith("_asyncCallback")) {
            return false;
        }
        for (Intent intent : this.getRequiredIntents()) {
            if (!intent.getName().getLocalPart().equals("asyncInvocation")) continue;
            return true;
        }
        return this.targetEndpoint != null && this.targetEndpoint.isAsyncInvocation();
    }
}

