/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.impl.ExtensibleImpl;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;

public class ComponentImpl
extends ExtensibleImpl
implements Component,
Cloneable {
    private Implementation implementation;
    private String name;
    private String uri;
    private List<ComponentProperty> properties = new ArrayList<ComponentProperty>();
    private List<ComponentReference> references = new ArrayList<ComponentReference>();
    private List<ComponentService> services = new ArrayList<ComponentService>();
    private List<Intent> requiredIntents = new ArrayList<Intent>();
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    private Boolean autowire;
    private ExtensionType type;

    protected ComponentImpl() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ComponentImpl clone = (ComponentImpl)super.clone();
        clone.properties = new ArrayList<ComponentProperty>();
        for (ComponentProperty property : this.getProperties()) {
            clone.properties.add((ComponentProperty)property.clone());
        }
        clone.references = new ArrayList<ComponentReference>();
        for (ComponentReference reference : this.getReferences()) {
            clone.references.add((ComponentReference)reference.clone());
        }
        clone.services = new ArrayList<ComponentService>();
        for (ComponentService service : this.getServices()) {
            clone.services.add((ComponentService)service.clone());
        }
        if (this.implementation instanceof Composite) {
            clone.implementation = (Composite)((Composite)this.implementation).clone();
        }
        clone.requiredIntents = new ArrayList<Intent>(this.getRequiredIntents());
        clone.policySets = new ArrayList<PolicySet>(this.getPolicySets());
        return clone;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public Implementation getImplementation() {
        return this.implementation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ComponentProperty> getProperties() {
        return this.properties;
    }

    @Override
    public ComponentProperty getProperty(String name) {
        for (ComponentProperty property : this.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public List<ComponentReference> getReferences() {
        return this.references;
    }

    @Override
    public ComponentReference getReference(String name) {
        for (ComponentReference ref : this.getReferences()) {
            if (!ref.getName().equals(name)) continue;
            return ref;
        }
        return null;
    }

    @Override
    public List<ComponentService> getServices() {
        return this.services;
    }

    @Override
    public ComponentService getService(String name) {
        for (ComponentService service : this.getServices()) {
            if (!service.getName().equals(name)) continue;
            return service;
        }
        return null;
    }

    @Override
    public void setImplementation(Implementation implementation) {
        this.implementation = implementation;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Intent> getRequiredIntents() {
        return this.requiredIntents;
    }

    @Override
    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    public boolean isAutowire() {
        return this.autowire == null ? false : this.autowire;
    }

    @Override
    public void setAutowire(Boolean autowire) {
        this.autowire = autowire;
    }

    @Override
    public Boolean getAutowire() {
        return this.autowire;
    }

    @Override
    public ExtensionType getExtensionType() {
        return this.type;
    }

    @Override
    public void setExtensionType(ExtensionType type) {
        this.type = type;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Component (");
        buf.append("uri=").append(this.uri);
        buf.append(",name=").append(this.name);
        buf.append(",implementation=").append(this.implementation);
        buf.append(")");
        return buf.toString();
    }
}

