/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import org.apache.tuscany.sca.Node;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.core.DefaultExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.ModuleActivatorExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.core.assembly.impl.EndpointRegistryImpl;
import org.apache.tuscany.sca.deployment.Deployer;
import org.apache.tuscany.sca.impl.NodeImpl;
import org.apache.tuscany.sca.monitor.ValidationException;
import org.apache.tuscany.sca.node.configuration.ContributionConfiguration;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.apache.tuscany.sca.runtime.ActivationException;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.RuntimeProperties;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.oasisopen.sca.ServiceRuntimeException;

public class TuscanyRuntime {
    private Deployer deployer;
    private ExtensionPointRegistry extensionPointRegistry;
    private CompositeActivator compositeActivator;
    private ExtensibleDomainRegistryFactory domainRegistryFactory;
    private RuntimeAssemblyFactory assemblyFactory;

    public static TuscanyRuntime newInstance() {
        return new TuscanyRuntime(null);
    }

    public static TuscanyRuntime newInstance(Properties config) {
        return new TuscanyRuntime(config);
    }

    public static Node runComposite(String compositeURI, String contributionURL, String ... dependentContributionURLs) {
        return TuscanyRuntime.runComposite(null, compositeURI, contributionURL, dependentContributionURLs);
    }

    public static Node runComposite(TuscanyRuntime runtime, String compositeURI, String contributionURL, String ... dependentContributionURLs) {
        try {
            boolean sharedRuntime;
            boolean bl = sharedRuntime = runtime != null;
            if (runtime == null) {
                runtime = TuscanyRuntime.newInstance();
            }
            EndpointRegistryImpl endpointRegistry = new EndpointRegistryImpl(runtime.extensionPointRegistry, null, null);
            NodeImpl node = new NodeImpl("default", runtime.deployer, runtime.compositeActivator, endpointRegistry, runtime.extensionPointRegistry, sharedRuntime ? null : runtime);
            if (dependentContributionURLs != null) {
                for (int i = dependentContributionURLs.length - 1; i > -1; --i) {
                    node.installContribution(null, dependentContributionURLs[i], null, null, false);
                }
            }
            String curi = node.installContribution(null, contributionURL, null, null, compositeURI == null);
            if (compositeURI != null) {
                node.start(curi, compositeURI);
            }
            return node;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected TuscanyRuntime(Properties config) {
        this.init(config);
    }

    public Node createNode() {
        return this.createNode(null);
    }

    public Node createNode(String domainURI) {
        String domainName = "default";
        if (domainURI != null) {
            domainName = this.getDomainName(domainURI);
        }
        EndpointRegistry endpointRegistry = this.domainRegistryFactory.getEndpointRegistry(domainURI, domainName);
        return new NodeImpl(domainName, this.deployer, this.compositeActivator, endpointRegistry, this.extensionPointRegistry, null);
    }

    public Node createNodeFromXML(String configURL) throws ContributionReadException, ActivationException, ValidationException {
        NodeConfiguration configuration = this.loadConfiguration(configURL);
        Node node = this.createNode(configuration.getDomainURI());
        for (ContributionConfiguration c : configuration.getContributions()) {
            node.installContribution(c.getURI(), c.getLocation(), c.getMetaDataURL(), c.getDependentContributionURIs(), c.isStartDeployables());
        }
        return node;
    }

    public void stop() {
        this.extensionPointRegistry.stop();
    }

    protected void init(Properties config) {
        if (config == null) {
            config = new Properties();
        }
        this.extensionPointRegistry = new DefaultExtensionPointRegistry();
        this.extensionPointRegistry.start();
        FactoryExtensionPoint modelFactories = this.extensionPointRegistry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = new RuntimeAssemblyFactory(this.extensionPointRegistry);
        modelFactories.addFactory(this.assemblyFactory);
        UtilityExtensionPoint utilities = this.extensionPointRegistry.getExtensionPoint(UtilityExtensionPoint.class);
        this.compositeActivator = utilities.getUtility(CompositeActivator.class);
        this.deployer = utilities.getUtility(Deployer.class);
        utilities.getUtility(RuntimeProperties.class).setProperties(config);
        utilities.getUtility(WorkScheduler.class);
        this.extensionPointRegistry.getExtensionPoint(ModuleActivatorExtensionPoint.class);
        this.domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance(this.extensionPointRegistry);
    }

    public ExtensionPointRegistry getExtensionPointRegistry() {
        return this.extensionPointRegistry;
    }

    public Deployer getDeployer() {
        return this.deployer;
    }

    public AssemblyFactory getAssemblyFactory() {
        return this.assemblyFactory;
    }

    private String getDomainName(String domainURI) {
        int scheme = domainURI.indexOf(58);
        int qm = domainURI.indexOf(63);
        if (qm == -1) {
            return domainURI.substring(scheme + 1);
        }
        return domainURI.substring(scheme + 1, qm);
    }

    protected NodeConfiguration loadConfiguration(String configURL) {
        InputStream xml = null;
        try {
            URL base = IOHelper.getLocationAsURL(configURL);
            xml = IOHelper.openStream(base);
            InputStreamReader reader = new InputStreamReader(xml, "UTF-8");
            ProcessorContext context = this.deployer.createProcessorContext();
            NodeConfiguration config = (NodeConfiguration)this.deployer.loadXMLDocument(reader, context.getMonitor());
            if (base != null && config != null) {
                for (ContributionConfiguration c : config.getContributions()) {
                    String location = c.getLocation();
                    if (location == null) continue;
                    URL url = new URL(base, location);
                    url = IOHelper.normalize(url);
                    c.setLocation(url.toString());
                }
            }
            NodeConfiguration nodeConfiguration = config;
            return nodeConfiguration;
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
        finally {
            try {
                if (xml != null) {
                    xml.close();
                }
            }
            catch (IOException e) {
                throw new ServiceRuntimeException(e);
            }
        }
    }
}

