/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ziplock;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.ziplock.ClassLoaders;

public class JarLocation {
    public static File get() {
        return JarLocation.jarLocation(JarLocation.class);
    }

    public static File jarFromPrefix(String prefix) {
        return JarLocation.jarFromRegex(prefix + ".*\\.jar");
    }

    public static File jarFromRegex(String regex) {
        Pattern pattern = Pattern.compile(regex);
        try {
            Set<URL> urls = ClassLoaders.findUrls(Thread.currentThread().getContextClassLoader());
            for (URL url : urls) {
                String decode = JarLocation.decode(url.getFile());
                File f = new File(decode.replaceFirst("file:", ""));
                if (!f.exists() && f.getPath().endsWith("!")) {
                    f = new File(f.getPath().substring(0, f.getPath().length() - 1));
                }
                if (!f.exists() || !pattern.matcher(f.getName()).matches()) continue;
                return f;
            }
            throw new IllegalArgumentException(regex + " not found in " + String.valueOf(urls));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static File jarFromResource(String resourceName) {
        return JarLocation.jarFromResource(Thread.currentThread().getContextClassLoader(), resourceName);
    }

    public static File jarFromResource(ClassLoader loader, String resourceName) {
        try {
            URL url = loader.getResource(resourceName);
            if (url == null) {
                throw new IllegalStateException("classloader.getResource(classFileName) returned a null URL");
            }
            if ("jar".equals(url.getProtocol())) {
                String spec = url.getFile();
                int separator = spec.indexOf(33);
                if (separator == -1) {
                    throw new MalformedURLException("no ! found in jar url spec:" + spec);
                }
                url = new URL(spec.substring(0, separator++));
                return new File(JarLocation.decode(url.getFile()));
            }
            if ("file".equals(url.getProtocol())) {
                return JarLocation.toFile(resourceName, url);
            }
            throw new IllegalArgumentException("Unsupported URL scheme: " + url.toExternalForm());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static File jarLocation(Class clazz) {
        try {
            String classFileName = clazz.getName().replace(".", "/") + ".class";
            ClassLoader loader = clazz.getClassLoader();
            return JarLocation.jarFromResource(loader, classFileName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static File toFile(String classFileName, URL url) {
        String path = url.getFile();
        path = path.substring(0, path.length() - classFileName.length());
        return new File(JarLocation.decode(path));
    }

    public static String decode(String fileName) {
        return ClassLoaders.decode(fileName);
    }
}

