/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;

public class SecurityConstaintBuilder {
    private final SecurityConstraint securityConstraint = new SecurityConstraint();

    public SecurityConstaintBuilder authConstraint(boolean authConstraint) {
        this.securityConstraint.setAuthConstraint(authConstraint);
        return this;
    }

    public SecurityConstaintBuilder displayName(String displayName) {
        this.securityConstraint.setDisplayName(displayName);
        return this;
    }

    public SecurityConstaintBuilder userConstraint(String constraint) {
        this.securityConstraint.setUserConstraint(constraint);
        return this;
    }

    public SecurityConstaintBuilder addAuthRole(String authRole) {
        this.securityConstraint.addAuthRole(authRole);
        return this;
    }

    public SecurityConstaintBuilder addCollection(String name, String pattern, String ... methods) {
        SecurityCollection collection = new SecurityCollection();
        collection.setName(name);
        collection.addPattern(pattern);
        for (String httpMethod : methods) {
            collection.addMethod(httpMethod);
        }
        this.securityConstraint.addCollection(collection);
        return this;
    }

    public void setAuthConstraint(boolean authConstraint) {
        this.securityConstraint.setAuthConstraint(authConstraint);
    }

    public void setDisplayName(String displayName) {
        this.securityConstraint.setDisplayName(displayName);
    }

    public void setUserConstraint(String userConstraint) {
        this.securityConstraint.setUserConstraint(userConstraint);
    }

    public void setAuthRole(String authRole) {
        this.addAuthRole(authRole);
    }

    public void setCollection(String value) {
        String[] split = value.split(":");
        if (split.length != 3 && split.length != 2) {
            throw new IllegalArgumentException("Can't parse " + value + ", syntax is: name:pattern:method1/method2");
        }
        this.addCollection(split[0], split[1], split.length == 2 ? new String[]{} : split[2].split("/"));
    }

    public SecurityConstraint build() {
        return this.securityConstraint;
    }
}

