/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.bootstrap;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Ports {
    private static final List<Port> allocated = new CopyOnWriteArrayList<Port>();

    private Ports() {
    }

    public static int allocate() {
        return Ports.allocate(1).iterator().next();
    }

    public static Iterable<Integer> allocate(int count) {
        allocated.removeIf(Port::isOld);
        final List ports = Stream.generate(Port::new).filter(Ports::isNotReserved).limit(count).collect(Collectors.toList());
        allocated.addAll(ports);
        return () -> new Iterator<Integer>(){

            @Override
            public boolean hasNext() {
                return ports.size() > 0;
            }

            @Override
            public Integer next() {
                Port port = (Port)ports.remove(0);
                return port.release();
            }
        };
    }

    private static boolean isNotReserved(Port port) {
        if (allocated.contains(port)) {
            port.release();
            return false;
        }
        return true;
    }

    static class Port {
        private final ServerSocket serverSocket;
        private final int port;
        private volatile long closed;
        private long tolerance;

        Port() {
            this(TimeUnit.MINUTES.toNanos(1L));
        }

        Port(long nanoseconds) {
            this.tolerance = nanoseconds;
            try {
                this.serverSocket = new ServerSocket(0);
                this.port = this.serverSocket.getLocalPort();
                this.closed = 0L;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create a server socket with random port", e);
            }
        }

        public boolean isOld() {
            return this.closed != 0L && this.closed < System.nanoTime();
        }

        public int get() {
            return this.port;
        }

        public int release() {
            if (this.serverSocket.isClosed()) {
                throw new IllegalStateException("Port has already been consumed");
            }
            int port = this.serverSocket.getLocalPort();
            try {
                this.serverSocket.close();
                this.closed = System.nanoTime() + this.tolerance;
                return port;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close server socket and free port " + port, e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Port port1 = (Port)o;
            return this.port == port1.port;
        }

        public int hashCode() {
            return this.port;
        }
    }
}

