/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.tck.testng;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.reporters.TestHTMLReporter;

public class HTMLReporter
extends TestHTMLReporter {
    private static final Class<?>[] API = new Class[]{ITestResult.class};

    public void onFinish(ITestContext context) {
        context.getPassedConfigurations().getAllResults().addAll(this.doWrap(context.getPassedConfigurations().getAllResults()));
        context.getFailedConfigurations().getAllResults().addAll(this.doWrap(context.getFailedConfigurations().getAllResults()));
        context.getSkippedConfigurations().getAllResults().addAll(this.doWrap(context.getSkippedConfigurations().getAllResults()));
        context.getPassedTests().getAllResults().addAll(this.doWrap(context.getPassedTests().getAllResults()));
        context.getFailedTests().getAllResults().addAll(this.doWrap(context.getFailedTests().getAllResults()));
        context.getSkippedTests().getAllResults().addAll(this.doWrap(context.getSkippedTests().getAllResults()));
        context.getFailedButWithinSuccessPercentageTests().getAllResults().addAll(this.doWrap(context.getFailedButWithinSuccessPercentageTests().getAllResults()));
        super.onFinish(context);
    }

    private List<ITestResult> doWrap(Set<ITestResult> raw) {
        ArrayList<ITestResult> wrapped = new ArrayList<ITestResult>(raw.size());
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (final ITestResult result : raw) {
            wrapped.add((ITestResult)ITestResult.class.cast(Proxy.newProxyInstance(loader, API, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("getParameters")) {
                        return new Object[method.getParameterTypes().length];
                    }
                    return method.invoke((Object)result, args);
                }
            })));
        }
        return wrapped;
    }
}

