/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.tck.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.openejb.tck.OpenEJBTCKRuntimeException;

public class AbstractContainers {
    protected static final String tmpDir = System.getProperty("java.io.tmpdir");

    protected void writeToFile(File file, InputStream archive) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            int bytesRead;
            FileOutputStream fos = new FileOutputStream(file);
            byte[] buffer = new byte[4096];
            while ((bytesRead = archive.read(buffer)) > -1) {
                fos.write(buffer, 0, bytesRead);
            }
            Util.close(fos);
        }
        catch (Exception e) {
            throw new OpenEJBTCKRuntimeException(e);
        }
    }

    protected static void delete(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                AbstractContainers.delete(f);
            }
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    protected static final class Util {
        protected Util() {
        }

        static void close(Closeable closeable) throws IOException {
            if (closeable == null) {
                return;
            }
            try {
                if (closeable instanceof Flushable) {
                    ((Flushable)((Object)closeable)).flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

