/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openejb.loader.Options;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.OptionsLog;

public class MulticastPulseAgent
implements DiscoveryAgent,
ServerService,
SelfManaging {
    private static final Logger LOG = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("discovery").createChild("multipulse"), MulticastPulseAgent.class);
    private static NetworkInterface[] interfaces = null;
    private static ExecutorService executor = null;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int TTL = Integer.parseInt(System.getProperty("org.apache.openejb.multipulse.ttl", "32"));
    public static final String SERVER = "OpenEJB.MCP.Server:";
    public static final String CLIENT = "OpenEJB.MCP.Client:";
    public static final String BADURI = ":BadUri:";
    public static final String EMPTY = "NoService";
    private final ReentrantLock lock = new ReentrantLock();
    private final Set<String> ignore = Collections.synchronizedSet(new HashSet());
    private final Set<URI> uriSet = new HashSet<URI>();
    private final AtomicBoolean running = new AtomicBoolean(false);
    final ArrayList<Future> futures = new ArrayList();
    private MulticastSocket[] sockets = null;
    private InetSocketAddress address = null;
    private String multicast = "239.255.3.2";
    private String group = "default";
    private int port = 6142;
    private DatagramPacket response = null;
    private DiscoveryListener listener = null;
    private boolean loopbackOnly = true;

    private static synchronized NetworkInterface[] getInterfaces() {
        if (null == interfaces) {
            interfaces = MulticastPulseAgent.getNetworkInterfaces();
        }
        return interfaces;
    }

    private static synchronized ExecutorService getExecutorService() {
        if (null == executor) {
            int length = MulticastPulseAgent.getInterfaces().length;
            if (length < 1) {
                length = 1;
            }
            executor = Executors.newFixedThreadPool(length * 3, (ThreadFactory)new DaemonThreadFactory(new Object[]{"multicast-pulse-agent-"}));
        }
        return executor;
    }

    public void init(Properties p) throws Exception {
        Options o = new Options(p);
        o.setLogger((Options.Log)new OptionsLog(LOG));
        this.ignore.add("localhost");
        this.ignore.add("::1");
        this.ignore.add("127.0.0.1");
        try {
            String[] ignoreList;
            for (String s : ignoreList = o.get("ignore", "").split(",")) {
                if (null == s || s.trim().length() <= 0) continue;
                this.ignore.add(s.trim().toLowerCase());
            }
        }
        catch (Exception e) {
            LOG.warning("Invalid ignore parameter. Should be a lowercase single host or comma seperated list of hosts to ignore like: ignore=host1,host2,ipv4,ipv6");
        }
        this.multicast = o.get("bind", this.multicast);
        this.port = o.get("port", this.port);
        this.group = o.get("group", this.group);
        InetAddress ia = InetAddress.getByName(this.multicast);
        this.address = new InetSocketAddress(ia, this.port);
        this.buildPacket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPacket() throws SocketException {
        ReentrantLock l = this.lock;
        l.lock();
        try {
            this.loopbackOnly = true;
            for (URI uri : this.uriSet) {
                if (MulticastPulseAgent.isLoopback(uri.getHost())) continue;
                this.loopbackOnly = false;
                break;
            }
            String hosts = MulticastPulseAgent.getHosts(this.ignore);
            StringBuilder sb = new StringBuilder(SERVER);
            sb.append(this.group);
            sb.append(':');
            if (this.uriSet.size() > 0) {
                for (URI uri : this.uriSet) {
                    sb.append(uri.toASCIIString());
                    sb.append('|');
                }
            } else {
                sb.append(EMPTY);
                sb.append('|');
            }
            sb.append(hosts);
            byte[] bytes = sb.toString().getBytes(UTF8);
            this.response = new DatagramPacket(bytes, bytes.length, this.address);
            if (LOG.isDebugEnabled()) {
                LOG.debug("MultiPulse packet is: " + String.valueOf(sb));
            }
            if (bytes.length > 2048) {
                LOG.warning("MultiPulse packet is larger than 2048 bytes, clients will not be able to read the packet\n - You should define the 'ignore' property to filter out unreachable addresses: " + String.valueOf(sb));
            }
        }
        finally {
            l.unlock();
        }
    }

    public DatagramPacket getResponsePacket() {
        ReentrantLock l = this.lock;
        l.lock();
        try {
            DatagramPacket datagramPacket = this.response;
            return datagramPacket;
        }
        finally {
            l.unlock();
        }
    }

    public void setDiscoveryListener(DiscoveryListener listener) {
        this.listener = listener;
    }

    public DiscoveryListener getDiscoveryListener() {
        return this.listener;
    }

    public void registerService(URI uri) throws IOException {
        if (this.uriSet.add(uri = this.parseUri(uri))) {
            this.buildPacket();
            this.fireEvent(uri, true);
        }
    }

    public void unregisterService(URI uri) throws IOException {
        URI tmp = this.parseUri(uri);
        if (this.uriSet.remove(tmp)) {
            this.fireEvent(uri, false);
        }
    }

    public void reportFailed(URI serviceUri) throws IOException {
        this.unregisterService(serviceUri);
    }

    private URI parseUri(URI uri) {
        return URI.create(uri.getSchemeSpecificPart());
    }

    private void fireEvent(final URI uri, final boolean add) {
        if (null != this.listener) {
            final DiscoveryListener dl = this.listener;
            MulticastPulseAgent.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    if (add) {
                        dl.serviceAdded(uri);
                    } else {
                        dl.serviceRemoved(uri);
                    }
                }
            });
        }
    }

    public void start() throws ServiceException {
        if (!this.running.getAndSet(true)) {
            try {
                this.sockets = MulticastPulseAgent.getSockets(this.multicast, this.port);
            }
            catch (Exception e) {
                throw new ServiceException("Failed to get Multicast sockets", (Throwable)e);
            }
            final CountDownLatch latch = new CountDownLatch(this.sockets.length);
            final String mpg = this.group;
            final boolean isLoopBackOnly = this.loopbackOnly;
            ExecutorService executorService = MulticastPulseAgent.getExecutorService();
            final MulticastPulseAgent agent = this;
            for (final MulticastSocket socket : this.sockets) {
                String socketKey;
                try {
                    socketKey = socket.getNetworkInterface().toString();
                }
                catch (SocketException e) {
                    LOG.error("Failed to get network interface name on: " + String.valueOf(socket), (Throwable)e);
                    continue;
                }
                final Sender sender = new Sender(this, socketKey, socket);
                this.futures.add(executorService.submit(sender));
                this.futures.add(executorService.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DatagramPacket request = new DatagramPacket(new byte[2048], 2048);
                        latch.countDown();
                        while (agent.running.get()) {
                            try {
                                String req;
                                socket.receive(request);
                                SocketAddress sa = request.getSocketAddress();
                                if (null == sa || !(req = new String(request.getData(), 0, request.getLength())).startsWith(MulticastPulseAgent.CLIENT)) continue;
                                int ix = req.indexOf(MulticastPulseAgent.BADURI);
                                String badUri = null;
                                if (ix > 0) {
                                    badUri = req.substring(ix).replace(MulticastPulseAgent.BADURI, "");
                                    req = req.substring(0, ix).replace(MulticastPulseAgent.CLIENT, "");
                                } else {
                                    req = req.replace(MulticastPulseAgent.CLIENT, "");
                                }
                                if (!mpg.equals(req) && !"*".equals(req)) continue;
                                if (null != badUri) {
                                    if (MulticastPulseAgent.getHosts(agent.ignore).contains(badUri)) {
                                        ReentrantLock l = agent.lock;
                                        l.lock();
                                        try {
                                            if (agent.ignore.add(badUri)) {
                                                agent.buildPacket();
                                                LOG.warning("This server has removed the unreachable host '" + badUri + "' from discovery, you should consider adding this to the 'ignore' property in the multipulse.properties file");
                                            }
                                        }
                                        finally {
                                            l.unlock();
                                        }
                                    }
                                    agent.fireEvent(URI.create("OpenEJB:BadUri:" + badUri), false);
                                    continue;
                                }
                                String client = ((InetSocketAddress)sa).getAddress().getHostAddress();
                                if (isLoopBackOnly && !MulticastPulseAgent.isLocalAddress(client, false)) {
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug(String.format("Ignoring remote client %1$s pulse request for group: %2$s - No remote services available", client, req));
                                    continue;
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(String.format("Answering client '%1$s' pulse request for group: '%2$s' on '%3$s'", client, req, socketKey));
                                }
                                sender.pulseResponse();
                            }
                            catch (Exception e) {
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug("MulticastPulseAgent request error: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }));
            }
            try {
                latch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ServiceException {
        if (this.running.getAndSet(false)) {
            try {
                for (Future future : this.futures) {
                    try {
                        future.cancel(true);
                    }
                    catch (Throwable throwable) {}
                }
                for (Future future : this.futures) {
                    try {
                        future.get();
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                this.futures.clear();
            }
            if (null != this.sockets) {
                try {
                    for (MulticastSocket s : this.sockets) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    this.sockets = null;
                }
            }
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    public void service(Socket socket) throws ServiceException, IOException {
    }

    public String getName() {
        return "multipulse";
    }

    public String getIP() {
        return this.multicast;
    }

    public int getPort() {
        return this.port;
    }

    public String getHosts() {
        return MulticastPulseAgent.getHosts(this.ignore);
    }

    public boolean removeFromIgnore(String host) {
        return this.ignore.remove(host);
    }

    public static MulticastSocket[] getSockets(String multicastAddress, int port) throws Exception {
        InetAddress ia;
        try {
            ia = InetAddress.getByName(multicastAddress);
        }
        catch (UnknownHostException e) {
            throw new ServiceException(multicastAddress + " is not a valid address", (Throwable)e);
        }
        if (null == ia || !ia.isMulticastAddress()) {
            throw new ServiceException(multicastAddress + " is not a valid multicast address");
        }
        return MulticastPulseAgent.getSockets(ia, port);
    }

    private static MulticastSocket[] getSockets(InetAddress ia, int port) throws Exception {
        ArrayList<MulticastSocket> list = new ArrayList<MulticastSocket>();
        for (NetworkInterface ni : MulticastPulseAgent.getInterfaces()) {
            MulticastSocket ms = null;
            try {
                ms = new MulticastSocket(port);
                ms.setNetworkInterface(ni);
                ms.setSoTimeout(0);
                ms.setTimeToLive(TTL);
                if (!ms.getBroadcast()) {
                    ms.setBroadcast(true);
                }
                ms.joinGroup(ia);
                list.add(ms);
                LOG.debug(String.format("Created MulticastSocket for '%1$s:%2$s' on network adapter: %3$s", ia.getHostName(), port, ni));
            }
            catch (Throwable e) {
                if (null == ms) continue;
                try {
                    ms.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return list.toArray(new MulticastSocket[list.size()]);
    }

    private static NetworkInterface[] getNetworkInterfaces() {
        HashSet<NetworkInterface> list = new HashSet<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface next = interfaces.nextElement();
                if (!next.supportsMulticast() || !next.isUp()) continue;
                list.add(next);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return list.toArray(new NetworkInterface[list.size()]);
    }

    public static boolean isLoopback(String host) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return addr.isLoopbackAddress();
    }

    public static boolean isLocalAddress(String host, boolean wildcardIsLocal) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (wildcardIsLocal && addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    private static String getHosts(Set<String> ignore) {
        TreeSet<String> hosts = new TreeSet<String>(new Comparator<String>(){

            private boolean isIPv4LiteralAddress(InetAddress val) {
                return Inet4Address.class.isInstance(val);
            }

            private boolean isIPv6LiteralAddress(InetAddress val) {
                return Inet6Address.class.isInstance(val);
            }

            @Override
            public int compare(String h1, String h2) {
                try {
                    InetAddress address1 = null;
                    InetAddress address2 = null;
                    try {
                        address1 = InetAddress.getByName(h1);
                        address2 = InetAddress.getByName(h2);
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    if (this.isIPv4LiteralAddress(address1)) {
                        if (this.isIPv6LiteralAddress(address2)) {
                            return -1;
                        }
                    } else if (this.isIPv6LiteralAddress(address1)) {
                        if (this.isIPv4LiteralAddress(address2)) {
                            return 1;
                        }
                    } else if (0 != h1.compareTo(h2)) {
                        return -1;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return h1.compareTo(h2);
            }
        });
        try {
            InetAddress[] all;
            InetAddress localhost = InetAddress.getLocalHost();
            hosts.add(localhost.getHostAddress());
            for (InetAddress ip : all = InetAddress.getAllByName(localhost.getHostName())) {
                String ha;
                if (ip.isLinkLocalAddress() || ip.isMulticastAddress() || (ha = ip.getHostAddress()).replace("[", "").startsWith("2001:0:")) continue;
                hosts.add(ha);
                hosts.add(ip.getHostName());
            }
        }
        catch (UnknownHostException e) {
            LOG.warning("Failed to list machine hosts", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        for (String host : hosts) {
            String lc = host.toLowerCase();
            if (ignore.contains(lc)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(host);
        }
        return sb.toString();
    }

    private static class Sender
    implements Runnable {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final MulticastPulseAgent agent;
        private final String socketKey;
        private final MulticastSocket socket;

        private Sender(MulticastPulseAgent agent, String socketKey, MulticastSocket socket) {
            this.agent = agent;
            this.socketKey = socketKey;
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: while (this.agent.running.get()) {
                AtomicInteger atomicInteger = this.counter;
                synchronized (atomicInteger) {
                    block11: {
                        try {
                            this.counter.wait();
                        }
                        catch (InterruptedException e) {
                            if (this.agent.running.get()) break block11;
                            break;
                        }
                    }
                }
                while (this.counter.decrementAndGet() > 0) {
                    block12: {
                        try {
                            this.socket.send(this.agent.getResponsePacket());
                        }
                        catch (Exception e) {
                            if (!LOG.isDebugEnabled()) break block12;
                            LOG.debug("MulticastPulseAgent client error: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        continue block9;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pulseResponse() {
            AtomicInteger atomicInteger = this.counter;
            synchronized (atomicInteger) {
                this.counter.set(100);
                this.counter.notifyAll();
            }
        }

        public String toString() {
            return this.socketKey;
        }
    }
}

