/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.discovery;

import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import org.apache.openejb.server.discovery.MultipointServer;
import org.apache.openejb.server.discovery.Tracker;

public class EchoNet {
    public static void _main(String[] args) throws Exception {
        MultipointServer a = new MultipointServer(1111, new Tracker.Builder().build()).start();
        MultipointServer b = new MultipointServer(3333, new Tracker.Builder().build()).start();
        a.connect(b);
        b.connect(a);
        a.connect(b);
        b.connect(a);
        a.connect(b);
        b.connect(a);
        a.connect(b);
        b.connect(a);
    }

    public static void main(String[] args) throws Exception {
        boolean multiple = true;
        int base = 2000;
        int servers = 50;
        if (args.length > 0) {
            servers = Integer.parseInt(args[0]);
        }
        if (servers < 1) {
            System.out.println("number of servers must be greater than zero");
            return;
        }
        servers += 2000;
        MultipointServer lastServer = null;
        for (int i = 2000; i < servers; ++i) {
            MultipointServer newServer = new MultipointServer(1 * i, new Tracker.Builder().build()).start();
            if (lastServer != null) {
                newServer.connect(lastServer);
            }
            lastServer = newServer;
        }
        new CountDownLatch(1).await();
    }

    public static class Calc {
        public static void main(String[] args) {
            HashSet<Item> set = new HashSet<Item>();
            int x = 150;
            for (int i = 1; i <= x; ++i) {
                for (int j = 1; j <= x; ++j) {
                    if (i == j) continue;
                    Item item = new Item(i, j);
                    boolean bl = set.add(item);
                }
            }
            System.out.println(x + " ? 2 = " + set.size());
        }

        static class Item {
            int a;
            int b;

            Item(int a, int b) {
                this.a = a;
                this.b = b;
            }

            public boolean equals(Object o) {
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Item set = (Item)o;
                if (this.a == set.a && this.b == set.b) {
                    return true;
                }
                return this.a == set.b && this.b == set.a;
            }

            public int hashCode() {
                return 1;
            }

            public String toString() {
                return this.a + " " + this.b;
            }
        }
    }
}

