/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit5;

import java.util.List;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.junit5.AfterAllReleaser;
import org.apache.openejb.junit5.AfterEachReleaser;
import org.apache.openejb.junit5.ApplicationComposerExtensionBase;
import org.apache.openejb.junit5.ApplicationComposerPerJVMExtension;
import org.apache.openejb.testing.ApplicationComposers;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;

abstract class ApplicationComposerPerXYExtensionBase
extends ApplicationComposerExtensionBase
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ApplicationComposerPerXYExtensionBase.class.getName()});
    private final Object[] modules;

    public ApplicationComposerPerXYExtensionBase() {
        this(null);
    }

    public ApplicationComposerPerXYExtensionBase(Object ... modules) {
        this.modules = modules;
    }

    protected void validate(ExtensionContext context) {
        if (!this.isPerJvm(context) && ApplicationComposerPerJVMExtension.isStarted()) {
            throw new OpenEJBRuntimeException("Cannot run PER_JVM in combination with PER_ALL, PER_EACH or AUTO");
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        AfterAllReleaser releaser = (AfterAllReleaser)context.getStore(NAMESPACE).get(AfterAllReleaser.class, AfterAllReleaser.class);
        if (releaser != null) {
            releaser.run(context);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        AfterEachReleaser releaser = (AfterEachReleaser)context.getStore(NAMESPACE).get(AfterEachReleaser.class, AfterEachReleaser.class);
        if (releaser != null) {
            releaser.run(context);
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.validate(extensionContext);
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
    }

    void doInit(ExtensionContext extensionContext) {
        Class oClazz = (Class)extensionContext.getTestClass().orElseThrow(() -> new OpenEJBRuntimeException("Could not get test class from the given extension context."));
        extensionContext.getStore(NAMESPACE).put(ApplicationComposers.class, (Object)new ApplicationComposers(oClazz, this.modules));
    }

    void doStart(ExtensionContext extensionContext) throws Exception {
        TestInstances oTestInstances = (TestInstances)extensionContext.getTestInstances().orElseThrow(() -> new OpenEJBRuntimeException("No test instances available for the given extension context."));
        List testInstances = oTestInstances.getAllInstances();
        ApplicationComposers delegate = (ApplicationComposers)extensionContext.getStore(NAMESPACE).get(ApplicationComposers.class, ApplicationComposers.class);
        testInstances.forEach(t -> {
            try {
                delegate.before(t);
            }
            catch (Exception e) {
                throw new OpenEJBRuntimeException(e);
            }
        });
    }

    void doInject(ExtensionContext extensionContext) {
        TestInstances oTestInstances = (TestInstances)extensionContext.getTestInstances().orElseThrow(() -> new OpenEJBRuntimeException("No test instances available for the given extension context."));
        List testInstances = oTestInstances.getAllInstances();
        testInstances.forEach(target -> {
            try {
                this.doInject(target, extensionContext);
            }
            catch (Exception e) {
                throw new OpenEJBRuntimeException(e);
            }
        });
    }

    void doInject(Object target, ExtensionContext context) throws Exception {
        ApplicationComposers delegate = (ApplicationComposers)context.getStore(NAMESPACE).get(ApplicationComposers.class, ApplicationComposers.class);
        delegate.enrich(target);
    }

    void addAfterAllReleaser(ExtensionContext context) {
        context.getStore(NAMESPACE).put(AfterAllReleaser.class, (Object)new AfterAllReleaser(NAMESPACE));
    }

    void addAfterEachReleaser(ExtensionContext context) {
        context.getStore(NAMESPACE).put(AfterEachReleaser.class, (Object)new AfterEachReleaser(NAMESPACE));
    }
}

