/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit5.security;

import jakarta.ejb.EJBAccessException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.openejb.junit.TestSecurity;
import org.apache.openejb.junit5.OpenEjbExtension;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;

public class TestSecurityTemplateInvocationContextProvider
implements TestTemplateInvocationContextProvider {
    public boolean supportsTestTemplate(ExtensionContext extensionContext) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        TestSecurity testSecurity = null;
        if (extensionContext.getTestMethod().isPresent() && ((Method)extensionContext.getTestMethod().get()).isAnnotationPresent(TestSecurity.class)) {
            testSecurity = ((Method)extensionContext.getTestMethod().get()).getAnnotation(TestSecurity.class);
        } else if (extensionContext.getTestClass().isPresent() && ((Class)extensionContext.getTestClass().get()).isAnnotationPresent(TestSecurity.class)) {
            testSecurity = ((Class)extensionContext.getTestClass().get()).getAnnotation(TestSecurity.class);
        }
        if (testSecurity != null) {
            String[] authorized = testSecurity.authorized();
            String[] unauthorized = testSecurity.unauthorized();
            ArrayList<TestTemplateInvocationContext> contexts = new ArrayList<TestTemplateInvocationContext>();
            for (String role : authorized) {
                contexts.add(this.invocationContext(role, true));
            }
            for (String role : unauthorized) {
                contexts.add(this.invocationContext(role, false));
            }
            return contexts.stream();
        }
        return Stream.of(new TestTemplateInvocationContext(){

            public List<Extension> getAdditionalExtensions() {
                return Collections.singletonList(new OpenEjbExtension());
            }
        });
    }

    private TestTemplateInvocationContext invocationContext(final String role, final boolean authorized) {
        return new TestTemplateInvocationContext(){
            private boolean ejbAccessThrown = false;

            public String getDisplayName(int invocationIndex) {
                if (role.equals("")) {
                    return "unauthenticated";
                }
                return role;
            }

            public List<Extension> getAdditionalExtensions() {
                ArrayList<Extension> extensions = new ArrayList<Extension>();
                extensions.add((Extension)new TestExecutionExceptionHandler(){

                    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
                        if (!authorized) {
                            if (throwable instanceof EJBAccessException) {
                                ejbAccessThrown = true;
                                return;
                            }
                            throw throwable;
                        }
                        throw throwable;
                    }
                });
                extensions.add((Extension)new AfterEachCallback(){

                    public void afterEach(ExtensionContext extensionContext) throws Exception {
                        if (!authorized && !ejbAccessThrown) {
                            throw new RuntimeException("Expected 'EJBAccessException' but caught none.");
                        }
                    }
                });
                extensions.add((Extension)new OpenEjbExtension(role));
                return extensions;
            }
        };
    }
}

