/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit5.jee;

import jakarta.ejb.embeddable.EJBContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import org.apache.openejb.Injector;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.injection.FallbackPropertyInjector;
import org.apache.openejb.junit.jee.config.Property;
import org.apache.openejb.junit.jee.config.PropertyFile;
import org.apache.openejb.junit.jee.resources.TestResource;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.osgi.client.LocalInitialContextFactory;
import org.apache.openejb.testing.TestInstance;
import org.apache.openejb.util.Classes;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class EjbContainerExtension
implements AfterAllCallback,
BeforeAllCallback,
BeforeEachCallback {
    private Properties properties;
    private EJBContainer container;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        org.apache.openejb.junit.jee.config.Properties annotationConfig;
        String path;
        Class clazz = (Class)extensionContext.getTestClass().orElseThrow(() -> new OpenEJBRuntimeException("Could not get class from extension context"));
        this.properties = new Properties();
        StringBuilder b = new StringBuilder();
        for (Class c : Classes.ancestors((Class)clazz)) {
            if (c == Object.class) continue;
            b.append(c.getName()).append(",");
        }
        b.setLength(b.length() - 1);
        this.properties.put("openejb.additionnal.callers", b.toString());
        try (InputStream is = clazz.getClassLoader().getResourceAsStream("openejb-junit.properties");){
            if (is != null) {
                this.properties.load(is);
            }
        }
        PropertyFile propertyFile = clazz.getAnnotation(PropertyFile.class);
        if (propertyFile != null && !(path = propertyFile.value()).isEmpty()) {
            try (InputStream is = null;){
                is = clazz.getClassLoader().getResourceAsStream(path);
                if (is == null) {
                    File file = new File(path);
                    if (file.exists()) {
                        is = new FileInputStream(file);
                    } else {
                        throw new OpenEJBException("properties resource '" + path + "' not found");
                    }
                }
                this.properties.load(is);
            }
        }
        if ((annotationConfig = clazz.getAnnotation(org.apache.openejb.junit.jee.config.Properties.class)) != null) {
            for (Property property : annotationConfig.value()) {
                this.properties.put(property.key(), property.value());
            }
        }
        if (!this.properties.containsKey("java.naming.factory.initial")) {
            this.properties.setProperty("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
        }
        this.container = EJBContainer.createEJBContainer((Map)this.properties);
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Class clazz = extensionContext.getTestClass().orElse(null);
        Object test = extensionContext.getTestInstance().orElse(null);
        if (clazz != null) {
            while (!Object.class.equals((Object)clazz)) {
                for (Field field : clazz.getDeclaredFields()) {
                    TestResource resource = field.getAnnotation(TestResource.class);
                    if (resource == null) continue;
                    if (Context.class.isAssignableFrom(field.getType())) {
                        field.setAccessible(true);
                        field.set(Modifier.isStatic(field.getModifiers()) ? null : test, this.getContainer().getContext());
                        continue;
                    }
                    if (Hashtable.class.isAssignableFrom(field.getType())) {
                        field.setAccessible(true);
                        field.set(Modifier.isStatic(field.getModifiers()) ? null : test, this.getProperties());
                        continue;
                    }
                    if (EJBContainer.class.isAssignableFrom(field.getType())) {
                        field.setAccessible(true);
                        field.set(Modifier.isStatic(field.getModifiers()) ? null : test, this.getContainer());
                        continue;
                    }
                    throw new OpenEJBException("can't inject field '" + field.getName() + "'");
                }
                clazz = clazz.getSuperclass();
            }
        }
        if (test != null) {
            SystemInstance.get().setComponent(TestInstance.class, (Object)new TestInstance(test.getClass(), test));
            SystemInstance.get().getComponent(FallbackPropertyInjector.class);
            Injector.inject((Object)test);
        }
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (this.container != null) {
            this.container.close();
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public EJBContainer getContainer() {
        return this.container;
    }
}

