/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit.jee;

import javax.naming.NamingException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.junit.jee.statement.InjectStatement;
import org.apache.openejb.junit.jee.statement.ShutingDownStatement;
import org.apache.openejb.junit.jee.statement.StartingStatement;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class EJBContainerRule
implements TestRule {
    private final Object test;
    private StartingStatement startingStatement;

    public EJBContainerRule() {
        this(null);
    }

    public EJBContainerRule(Object test) {
        this.test = test;
    }

    public Statement apply(final Statement base, Description description) {
        this.startingStatement = this.test == null ? new StartingStatement(base, description.getTestClass()) : new StartingStatement(new Statement(){

            public void evaluate() throws Throwable {
                new InjectStatement(base, EJBContainerRule.this.test.getClass(), EJBContainerRule.this.test, EJBContainerRule.this.startingStatement).evaluate();
            }
        }, description.getTestClass());
        return new ShutingDownStatement(this.startingStatement, this.startingStatement);
    }

    public void inject(Object target) {
        try {
            new InjectStatement(null, target.getClass(), target, this.startingStatement).evaluate();
        }
        catch (Throwable throwable) {
            throw new OpenEJBRuntimeException(throwable.getMessage(), throwable);
        }
    }

    public <T> T resource(Class<T> type, String name) {
        try {
            return type.cast(((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext().lookup("java:openejb/Resource/" + name));
        }
        catch (NamingException e) {
            throw new OpenEJBRuntimeException((Exception)e);
        }
    }

    StartingStatement getStartingStatement() {
        return this.startingStatement;
    }
}

