/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit.context;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.api.LocalClient;
import org.apache.openejb.junit.ContextConfig;
import org.apache.openejb.junit.Property;
import org.apache.openejb.junit.RunTestAs;
import org.apache.openejb.junit.TestResource;
import org.apache.openejb.junit.context.TestContext;
import org.apache.openejb.junit.context.Util;
import org.apache.openejb.loader.SystemInstance;

public class OpenEjbTestContext
implements TestContext {
    protected static final String REALM_PROPERTY_KEY = "openejb.authentication.realmName";
    protected static final String LOGIN_CONFIG_RESOURCE = "/META-INF/openejb-test-login.config";
    protected static final String DEFAULT_CONFIG_FILE_RESOURCE = "/META-INF/default-openejb-test-config.properties";
    protected Properties contextConfig;
    private InitialContext initialContext;
    private final Class<?> clazz;
    private Method method;
    private String securityRole;

    public OpenEjbTestContext(Class clazz) {
        this(clazz, null);
    }

    public OpenEjbTestContext(Method method) {
        this(method, null);
    }

    public OpenEjbTestContext(Class clazz, String securityRole) {
        this.clazz = clazz;
        this.securityRole = securityRole;
    }

    public OpenEjbTestContext(Method method, String securityRole) {
        this.clazz = method.getDeclaringClass();
        this.method = method;
        this.securityRole = securityRole;
    }

    @Override
    public void configureTest(Object testObj) {
        try {
            if (testObj.getClass().isAnnotationPresent(LocalClient.class)) {
                this.getInitialContext().bind("inject", testObj);
            }
            this.performInjections(testObj);
        }
        catch (IOException e) {
            throw new OpenEJBRuntimeException("Failed to load configuration.", (Throwable)e);
        }
        catch (NamingException e) {
            throw new OpenEJBRuntimeException("Failed to configure object.", (Throwable)e);
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException("Unknown error trying to configure object.", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.initialContext != null) {
                this.initialContext.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        OpenEJB.destroy();
        SystemInstance.reset();
    }

    protected InitialContext getInitialContext() throws NamingException {
        if (this.initialContext == null) {
            String loginConfig = OpenEjbTestContext.class.getResource(LOGIN_CONFIG_RESOURCE).toExternalForm();
            System.setProperty("java.security.auth.login.config", URLDecoder.decode(loginConfig));
            try {
                Properties config = this.getContextConfig();
                this.initialContext = new InitialContext(config);
            }
            catch (IOException e) {
                throw new NamingException("Failed to load initial context configuration: " + e.getMessage());
            }
        }
        return this.initialContext;
    }

    protected Properties getContextConfig() throws IOException {
        if (this.contextConfig != null) {
            return this.contextConfig;
        }
        Properties env = new Properties();
        boolean loadedConfig = false;
        if (this.clazz.isAnnotationPresent(ContextConfig.class)) {
            loadedConfig |= this.loadConfig(env, this.clazz.getAnnotation(ContextConfig.class));
        }
        if (this.method != null && this.method.isAnnotationPresent(ContextConfig.class)) {
            loadedConfig |= this.loadConfig(env, this.method.getAnnotation(ContextConfig.class));
        }
        if (!loadedConfig) {
            InputStream in = OpenEjbTestContext.class.getResourceAsStream(DEFAULT_CONFIG_FILE_RESOURCE);
            if (in == null) {
                throw new FileNotFoundException("Default configuration file not found. Specify configuration properties to initialize OpenEJB using @ContextConfig.");
            }
            env.load(in);
            if (env.size() == 0) {
                throw new IOException("Context configuration failed to load, so OpenEJB won't load either. Specify configuration properties for initializing OpenEJB using @ContextConfig.");
            }
        }
        this.configureSecurity(env);
        this.contextConfig = env;
        return env;
    }

    protected boolean loadConfig(Properties env, ContextConfig contextConfig) throws IOException {
        boolean loadedConfig = false;
        loadedConfig = this.loadConfigFile(env, contextConfig);
        return loadedConfig |= this.loadConfigProperties(env, contextConfig);
    }

    protected boolean loadConfigProperties(Properties env, ContextConfig contextConfig) {
        boolean loadedConfig = false;
        if (contextConfig.properties().length > 0) {
            for (Property p : contextConfig.properties()) {
                if (p.value() == null) continue;
                loadedConfig = true;
                Util.addProperty(env, p.value());
            }
        }
        return loadedConfig;
    }

    protected boolean loadConfigFile(Properties env, ContextConfig contextConfig) throws IOException {
        if (contextConfig.configFile().length() > 0) {
            InputStream in = this.clazz.getResourceAsStream(contextConfig.configFile());
            if (in == null) {
                throw new FileNotFoundException("Cannot find resource '" + contextConfig.configFile() + "' in classpath: " + this.clazz.getName());
            }
            env.load(in);
            return env.size() > 0;
        }
        return false;
    }

    protected void configureSecurity(Properties env) {
        if (this.securityRole == null) {
            if (this.method != null && this.method.isAnnotationPresent(RunTestAs.class)) {
                this.securityRole = this.method.getAnnotation(RunTestAs.class).value();
            } else if (this.clazz.isAnnotationPresent(RunTestAs.class)) {
                this.securityRole = this.clazz.getAnnotation(RunTestAs.class).value();
            }
        }
        if (this.securityRole != null) {
            env.put(REALM_PROPERTY_KEY, "OpenEjbJunitSecurityRealm");
            env.put("java.naming.security.principal", this.securityRole);
            env.put("java.naming.security.credentials", "[no-password-needed]");
        }
    }

    private void performInjections(Object testObj) throws Exception {
        for (Field field : this.clazz.getDeclaredFields()) {
            Object injectValue = this.getInjectionValue(field);
            if (injectValue == null) continue;
            try {
                Method setterMethod = Util.findSetter(this.clazz, field, injectValue);
                if (setterMethod != null) {
                    setterMethod.invoke(testObj, injectValue);
                    continue;
                }
            }
            catch (Exception e) {
                System.err.println("Failed to perform setter injection on: " + this.clazz.getCanonicalName() + "." + field.getName());
                e.printStackTrace();
            }
            try {
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                field.set(testObj, injectValue);
            }
            catch (Exception e) {
                throw new OpenEJBRuntimeException("Failed to inject on: " + this.clazz.getCanonicalName() + "." + field.getName(), (Throwable)e);
            }
        }
    }

    protected Object getInjectionValue(Field field) throws Exception {
        if (field.isAnnotationPresent(TestResource.class)) {
            TestResource resourceConfig = field.getAnnotation(TestResource.class);
            String resourceType = resourceConfig.value();
            if (resourceType == null) {
                throw new IllegalArgumentException("Null TestResource type '" + resourceType + "' on field: " + this.clazz.getCanonicalName() + "." + field.getName());
            }
            if ("org.apache.openejb.junit.context-config".equals(resourceType)) {
                return this.getContextConfig();
            }
            if ("org.apache.openejb.junit.initial-context".equals(resourceType)) {
                return this.getInitialContext();
            }
            return this.getOtherTestResource(resourceConfig);
        }
        return null;
    }

    protected Object getOtherTestResource(TestResource resourceConfig) {
        return null;
    }

    protected Class<?> getTestClass() {
        return this.clazz;
    }

    protected Method getTestMethod() {
        return this.method;
    }
}

