/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.ws.WebServiceRef;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import org.apache.openejb.test.servlet.EjbServlet;
import org.apache.openejb.test.servlet.HelloEjb;
import org.apache.openejb.test.servlet.HelloPojo;
import org.junit.Assert;

public class WebserviceServlet
extends HttpServlet {
    @WebServiceRef
    private HelloPojo helloPojo;
    @WebServiceRef
    private HelloEjb helloEjb;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        ServletOutputStream out = response.getOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)out);
        String methodName = request.getParameter("method");
        if (methodName == null) {
            this.testAll(printStream);
        } else {
            try {
                Method method = ((Object)((Object)this)).getClass().getMethod(methodName, new Class[0]);
                method.invoke((Object)this, new Object[0]);
            }
            catch (Throwable e) {
                printStream.println("FAILED");
                e.printStackTrace(printStream);
            }
        }
        printStream.flush();
    }

    public void testAll(PrintStream printStream) {
        for (Method method : EjbServlet.class.getMethods()) {
            if (!method.getName().startsWith("invoke")) continue;
            try {
                method.invoke((Object)this, new Object[0]);
                printStream.println(method.getName() + " PASSED");
            }
            catch (Throwable e) {
                printStream.println(method.getName() + " FAILED");
                e.printStackTrace(printStream);
                printStream.flush();
            }
            printStream.println();
        }
    }

    public void invokePojoWebservice() {
        Assert.assertEquals((Object)"Hello Bob from Pojo Webservice!", (Object)this.helloPojo.hello("Bob"));
    }

    public void invokeEjbWebservice() {
        Assert.assertEquals((Object)"Hello Bob from EJB Webservice!", (Object)this.helloEjb.hello("Bob"));
    }
}

