/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.ejb.PostActivate;
import jakarta.ejb.PrePassivate;
import jakarta.ejb.Stateful;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.ExcludeClassInterceptors;
import jakarta.interceptor.Interceptors;
import jakarta.interceptor.InvocationContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.openejb.test.SuperInterceptedBean;
import org.apache.openejb.test.interceptor.ClassInterceptor;
import org.apache.openejb.test.interceptor.Interceptor;
import org.apache.openejb.test.interceptor.MethodInterceptor;
import org.apache.openejb.test.interceptor.SecondClassInterceptor;
import org.apache.openejb.test.stateful.BasicStatefulInterceptedLocal;
import org.apache.openejb.test.stateful.BasicStatefulInterceptedRemote;

@Stateful(name="ThirdStatefulIntercepted")
@Interceptors(value={ClassInterceptor.class, SecondClassInterceptor.class})
public class ThirdStatefulInterceptedBean
extends SuperInterceptedBean
implements BasicStatefulInterceptedLocal,
BasicStatefulInterceptedRemote {
    private static Map<String, Object> contextData = new HashMap<String, Object>();

    public String concat(String str1, String str2) {
        return str1.concat(str2);
    }

    @Interceptors(value={MethodInterceptor.class})
    public String reverse(String str) {
        StringBuffer b = new StringBuffer(str);
        return b.reverse().toString();
    }

    @ExcludeClassInterceptors
    public Map<String, Object> getContextData() {
        return contextData;
    }

    private void setContextData(Map<String, Object> ctxData) {
        contextData.putAll(ctxData);
    }

    @AroundInvoke
    public Object inBeanInterceptor(InvocationContext ctx) throws Exception {
        Map ctxData = Interceptor.profile((InvocationContext)ctx, (String)"inBeanInterceptor");
        this.setContextData(ctxData);
        return ctx.proceed();
    }

    @PostConstruct
    public void inBeanInterceptorPostConstruct() throws Exception {
        Map ctxData = Interceptor.profile((SuperInterceptedBean)this, (String)"inBeanInterceptorPostConstruct");
        this.setContextData(ctxData);
    }

    @PostActivate
    public void inBeanInterceptorPostActivate() throws Exception {
        Map ctxData = Interceptor.profile((SuperInterceptedBean)this, (String)"inBeanInterceptorPostActivate");
        this.setContextData(ctxData);
    }

    @PrePassivate
    public void inBeanInterceptorPrePassivate() throws Exception {
        Map ctxData = Interceptor.profile((SuperInterceptedBean)this, (String)"inBeanInterceptorPrePassivate");
        this.setContextData(ctxData);
    }

    @PreDestroy
    public void inBeanInterceptorPreDestroy() throws Exception {
        Map ctxData = Interceptor.profile((SuperInterceptedBean)this, (String)"inBeanInterceptorPreDestroy");
        this.setContextData(ctxData);
    }
}

