/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import jakarta.ejb.EJBObject;
import java.rmi.NoSuchObjectException;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateful.BasicStatefulTestClient;

public class StatefulPojoHandleTests
extends BasicStatefulTestClient {
    public StatefulPojoHandleTests() {
        super("PojoHandle.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateful/BasicStatefulPojoHome");
        this.ejbHome = (BasicStatefulHome)obj;
        this.ejbObject = this.ejbHome.createObject("StatefulPojoHandleTests Bean");
        this.ejbHandle = this.ejbObject.getHandle();
    }

    public void test01_getEJBObject() {
        try {
            EJBObject object = this.ejbHandle.getEJBObject();
            StatefulPojoHandleTests.assertNotNull((String)"The EJBObject is null", (Object)object);
            StatefulPojoHandleTests.assertTrue((String)"EJBObjects are not identical", (boolean)object.isIdentical((EJBObject)this.ejbObject));
        }
        catch (Exception e) {
            StatefulPojoHandleTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_EJBHome_remove() {
        try {
            this.ejbHome.remove(this.ejbHandle);
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                StatefulPojoHandleTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (NoSuchObjectException e) {
                StatefulPojoHandleTests.assertTrue((boolean)true);
                return;
            }
        }
        catch (Exception e) {
            StatefulPojoHandleTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }
}

