/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.openejb.test.entity.cmp.ComplexCmpBeanPk;
import org.apache.openejb.test.entity.cmp.ComplexCmpHome;
import org.apache.openejb.test.entity.cmp.ComplexCmpObject;
import org.apache.openejb.test.entity.cmp.ComplexCmpTestClient;

public class ComplexHomeIntfcTests
extends ComplexCmpTestClient {
    public ComplexHomeIntfcTests() {
        super("ComplexPk.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp/ComplexCmpHome");
        this.ejbHome = (ComplexCmpHome)obj;
    }

    public void test01_create() {
        try {
            this.ejbObject = this.ejbHome.createObject("First Bean");
            ComplexHomeIntfcTests.assertNotNull((String)"The EJBObject is null", (Object)this.ejbObject);
        }
        catch (Exception e) {
            ComplexHomeIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_findByPrimaryKey() {
        try {
            this.ejbPrimaryKey = this.ejbObject.getPrimaryKey();
            ComplexHomeIntfcTests.assertTrue((String)("Expected (ejbPrimaryKey instanceof ComplexCmpBeanPk) but was instanceof " + this.ejbPrimaryKey.getClass().getName()), (boolean)(this.ejbPrimaryKey instanceof ComplexCmpBeanPk));
            this.ejbObject = this.ejbHome.findByPrimaryKey((ComplexCmpBeanPk)this.ejbPrimaryKey);
            ComplexHomeIntfcTests.assertNotNull((String)"The EJBObject is null", (Object)this.ejbObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            ComplexHomeIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test03_findByLastName() {
        HashSet<ComplexCmpBeanPk> keys = new HashSet<ComplexCmpBeanPk>();
        try {
            this.ejbObject = this.ejbHome.createObject("David Blevins");
            this.ejbPrimaryKey = this.ejbObject.getPrimaryKey();
            ComplexHomeIntfcTests.assertTrue((String)("Expected (ejbPrimaryKey instanceof ComplexCmpBeanPk) but was instanceof " + this.ejbPrimaryKey.getClass().getName()), (boolean)(this.ejbPrimaryKey instanceof ComplexCmpBeanPk));
            keys.add((ComplexCmpBeanPk)this.ejbObject.getPrimaryKey());
            this.ejbObject = this.ejbHome.createObject("Dennis Blevins");
            this.ejbPrimaryKey = this.ejbObject.getPrimaryKey();
            ComplexHomeIntfcTests.assertTrue((String)("Expected (ejbPrimaryKey instanceof ComplexCmpBeanPk) but was instanceof " + this.ejbPrimaryKey.getClass().getName()), (boolean)(this.ejbPrimaryKey instanceof ComplexCmpBeanPk));
            keys.add((ComplexCmpBeanPk)this.ejbObject.getPrimaryKey());
            this.ejbObject = this.ejbHome.createObject("Claude Blevins");
            this.ejbPrimaryKey = this.ejbObject.getPrimaryKey();
            ComplexHomeIntfcTests.assertTrue((String)("Expected (ejbPrimaryKey instanceof ComplexCmpBeanPk) but was instanceof " + this.ejbPrimaryKey.getClass().getName()), (boolean)(this.ejbPrimaryKey instanceof ComplexCmpBeanPk));
            keys.add((ComplexCmpBeanPk)this.ejbObject.getPrimaryKey());
        }
        catch (Exception e) {
            ComplexHomeIntfcTests.fail((String)("Received exception while preparing the test: " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
        try {
            Collection objects = this.ejbHome.findByLastName("Blevins");
            HashSet<ComplexCmpBeanPk> foundKeys = new HashSet<ComplexCmpBeanPk>();
            ComplexHomeIntfcTests.assertNotNull((String)"The Collection is null", (Object)objects);
            ComplexHomeIntfcTests.assertEquals((String)"The Collection is not the right size.", (long)keys.size(), (long)objects.size());
            for (Object object : objects) {
                this.ejbObject = (ComplexCmpObject)object;
                ComplexCmpBeanPk foundKey = (ComplexCmpBeanPk)this.ejbObject.getPrimaryKey();
                ComplexHomeIntfcTests.assertTrue((String)("Extra ejb found " + String.valueOf(this.ejbObject.getPrimaryKey())), (boolean)keys.contains(foundKey));
                foundKeys.add(foundKey);
            }
            keys.removeAll(foundKeys);
            ComplexHomeIntfcTests.assertEquals((String)"Some keys were not found", (Object)Collections.EMPTY_SET, keys);
        }
        catch (Exception e) {
            e.printStackTrace();
            ComplexHomeIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test04_homeMethod() {
        try {
            int expected = 8;
            int actual = this.ejbHome.sum(5, 3);
            ComplexHomeIntfcTests.assertEquals((String)"home method returned wrong result", (long)8L, (long)actual);
        }
        catch (Exception e) {
            ComplexHomeIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }
}

